/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common.multiplexer;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.WrappingMapTemplate;
import com.linkedin.restli.common.multiplexer.IndividualRequest;
import java.util.List;
import java.util.Map;

public class IndividualRequestMap
extends WrappingMapTemplate<IndividualRequest> {
    private static final MapDataSchema SCHEMA = (MapDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"IndividualRequest\",\"namespace\":\"com.linkedin.restli.common.multiplexer\",\"doc\":\"Individual HTTP request within a multiplexed request. For security reasons, cookies are not allowed to be specified in the IndividualRequest. Instead, it MUST be specified in the top level envelope request.\",\"fields\":[{\"name\":\"method\",\"type\":\"string\",\"doc\":\"HTTP method name\"},{\"name\":\"headers\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"HTTP headers specific to the individual request. All common headers should be specified in the top level envelope request. If IndividualRequest headers contain a header that is also specified in the top level envelope request, the header in the IndividualRequest will be used. In additions, for security reasons, headers in IndividualRequest are whitelisted. Only headers within the whitelist can be specified here.\",\"default\":{}},{\"name\":\"relativeUrl\",\"type\":\"string\",\"doc\":\"Relative URL of the request\"},{\"name\":\"body\",\"type\":{\"type\":\"record\",\"name\":\"IndividualBody\",\"doc\":\"Represents content that may be in the body of an individual request / response\",\"fields\":[]},\"doc\":\"Request body\",\"optional\":true},{\"name\":\"dependentRequests\",\"type\":{\"type\":\"map\",\"values\":\"IndividualRequest\"},\"doc\":\"Requests that should be executed after the current request is processed (sequential ordering). Dependent requests are executed in parallel. Keys of the dependent requests are used to correlate responses with requests. They should be unique within the multiplexed request\",\"default\":{}}]}}");

    public IndividualRequestMap() {
        this(new DataMap());
    }

    public IndividualRequestMap(int initialCapacity) {
        this(new DataMap(initialCapacity));
    }

    public IndividualRequestMap(int initialCapacity, float loadFactor) {
        this(new DataMap(initialCapacity, loadFactor));
    }

    public IndividualRequestMap(Map<String, IndividualRequest> m) {
        this(IndividualRequestMap.newDataMapOfSize((int)m.size()));
        this.putAll(m);
    }

    public IndividualRequestMap(DataMap data) {
        super(data, SCHEMA, IndividualRequest.class);
    }

    public IndividualRequestMap clone() throws CloneNotSupportedException {
        return (IndividualRequestMap)super.clone();
    }

    public IndividualRequestMap copy() throws CloneNotSupportedException {
        return (IndividualRequestMap)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public IndividualRequest.Fields values() {
            return new IndividualRequest.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

