/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateRuntimeException;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;

public class TypeSpec<T> {
    private final Class<T> _type;
    private final DataSchema _schema;

    public static <T> TypeSpec<T> forClassMaybeNull(Class<T> type) {
        if (type == null) {
            return null;
        }
        return new TypeSpec<T>(type);
    }

    public TypeSpec(Class<T> type) {
        this(type, TypeSpec.backfillSchemaIfPossible(type));
    }

    private static DataSchema backfillSchemaIfPossible(Class<?> type) {
        if (type == CompoundKey.class || type == ComplexResourceKey.class || type == Void.class) {
            return null;
        }
        try {
            return DataTemplateUtil.getSchema(type);
        }
        catch (TemplateRuntimeException e) {
            return null;
        }
    }

    public TypeSpec(Class<T> type, DataSchema schema) {
        if (type == null) {
            throw new IllegalArgumentException("type must be non-null.");
        }
        this._type = type;
        this._schema = schema;
    }

    public Class<T> getType() {
        return this._type;
    }

    public boolean hasSchema() {
        return this._schema != null;
    }

    public DataSchema getSchema() {
        return this._schema;
    }

    public String toString() {
        return "TypeSpec{_type=" + this._type + ", _schema=" + this._schema + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeSpec)) {
            return false;
        }
        TypeSpec typeSpec = (TypeSpec)o;
        if (!this._type.equals(typeSpec._type)) {
            return false;
        }
        return !(this._schema != null ? !this._schema.equals((Object)typeSpec._schema) : typeSpec._schema != null);
    }

    public int hashCode() {
        int result = this._type.hashCode();
        result = 31 * result + (this._schema != null ? this._schema.hashCode() : 0);
        return result;
    }
}

