/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.data.ByteString;
import com.linkedin.data.DataMap;
import com.linkedin.multipart.MultiPartMIMEReader;
import com.linkedin.multipart.MultiPartMIMEReaderCallback;
import com.linkedin.multipart.SinglePartMIMEReaderCallback;
import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.FullEntityReader;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.RestLiDecodingException;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.attachments.RestLiAttachmentReader;
import com.linkedin.restli.internal.client.ResponseImpl;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.CookieUtil;
import com.linkedin.restli.internal.common.DataMapConverter;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeTypeParseException;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

public abstract class RestResponseDecoder<T> {
    public void decodeResponse(final StreamResponse streamResponse, final Callback<Response<T>> responseCallback) throws RestLiDecodingException {
        String contentTypeString = streamResponse.getHeader("Content-Type");
        if (contentTypeString != null) {
            ContentType contentType = null;
            try {
                contentType = new ContentType(contentTypeString);
            }
            catch (ParseException parseException) {
                responseCallback.onError((Throwable)((Object)new RestLiDecodingException("Could not decode Content-Type header in response", parseException)));
                return;
            }
            if (contentType.getBaseType().equalsIgnoreCase("multipart/related")) {
                MultiPartMIMEReader multiPartMIMEReader = MultiPartMIMEReader.createAndAcquireStream((StreamResponse)streamResponse);
                TopLevelReaderCallback topLevelReaderCallback = new TopLevelReaderCallback(responseCallback, streamResponse, multiPartMIMEReader);
                multiPartMIMEReader.registerReaderCallback((MultiPartMIMEReaderCallback)topLevelReaderCallback);
                return;
            }
        }
        FullEntityReader fullEntityReader = new FullEntityReader((Callback)new Callback<ByteString>(){

            public void onError(Throwable e) {
                responseCallback.onError(e);
            }

            public void onSuccess(ByteString result) {
                try {
                    responseCallback.onSuccess((Object)RestResponseDecoder.this.createResponse(streamResponse.getHeaders(), streamResponse.getStatus(), result, streamResponse.getCookies()));
                }
                catch (Exception exception) {
                    this.onError(exception);
                }
            }
        });
        streamResponse.getEntityStream().setReader((Reader)fullEntityReader);
    }

    public Response<T> decodeResponse(RestResponse restResponse) throws RestLiDecodingException {
        return this.createResponse(restResponse.getHeaders(), restResponse.getStatus(), restResponse.getEntity(), restResponse.getCookies());
    }

    private ResponseImpl<T> createResponse(Map<String, String> headers, int status, ByteString entity, List<String> cookies) throws RestLiDecodingException {
        ResponseImpl<T> response = new ResponseImpl<T>(status, headers, CookieUtil.decodeSetCookies(cookies));
        try {
            DataMap dataMap = entity.isEmpty() ? null : DataMapConverter.bytesToDataMap(headers, (ByteString)entity);
            response.setEntity(this.wrapResponse(dataMap, headers, ProtocolVersionUtil.extractProtocolVersion(response.getHeaders())));
            return response;
        }
        catch (MimeTypeParseException e) {
            throw new RestLiDecodingException("Could not decode REST response", e);
        }
        catch (IOException e) {
            throw new RestLiDecodingException("Could not decode REST response", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public abstract Class<?> getEntityClass();

    @Deprecated
    public T wrapResponse(DataMap dataMap) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IOException, IllegalAccessException {
        return this.wrapResponse(dataMap, Collections.emptyMap(), AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion());
    }

    public abstract T wrapResponse(DataMap var1, Map<String, String> var2, ProtocolVersion var3) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException;

    private class FirstPartReaderCallback
    implements SinglePartMIMEReaderCallback {
        private final TopLevelReaderCallback _topLevelReaderCallback;
        private final MultiPartMIMEReader.SinglePartMIMEReader _singlePartMIMEReader;
        private final StreamResponse _streamResponse;
        private final Callback<Response<T>> _responseCallback;
        private final ByteString.Builder _builder = new ByteString.Builder();

        public FirstPartReaderCallback(TopLevelReaderCallback topLevelReaderCallback, MultiPartMIMEReader.SinglePartMIMEReader singlePartMIMEReader, StreamResponse streamResponse, Callback<Response<T>> responseCallback) {
            this._topLevelReaderCallback = topLevelReaderCallback;
            this._singlePartMIMEReader = singlePartMIMEReader;
            this._streamResponse = streamResponse;
            this._responseCallback = responseCallback;
        }

        public void onPartDataAvailable(ByteString partData) {
            this._builder.append(partData);
            this._singlePartMIMEReader.requestPartData();
        }

        public void onFinished() {
            try {
                HashMap headers = new HashMap(this._streamResponse.getHeaders());
                headers.put("Content-Type", this._singlePartMIMEReader.dataSourceHeaders().get("Content-Type"));
                this._topLevelReaderCallback.setResponse(RestResponseDecoder.this.createResponse(headers, this._streamResponse.getStatus(), this._builder.build(), this._streamResponse.getCookies()));
            }
            catch (Exception exception) {
                this._responseCallback.onError((Throwable)exception);
            }
        }

        public void onDrainComplete() {
            this._responseCallback.onError((Throwable)new IllegalStateException("Serious error. There should never be a call to drain part data when decoding the first part in a multipart mime response."));
        }

        public void onStreamError(Throwable throwable) {
        }
    }

    private class TopLevelReaderCallback
    implements MultiPartMIMEReaderCallback {
        private final Callback<Response<T>> _responseCallback;
        private final StreamResponse _streamResponse;
        private final MultiPartMIMEReader _multiPartMIMEReader;
        private ResponseImpl<T> _response = null;

        private TopLevelReaderCallback(Callback<Response<T>> responseCallback, StreamResponse streamResponse, MultiPartMIMEReader multiPartMIMEReader) {
            this._responseCallback = responseCallback;
            this._streamResponse = streamResponse;
            this._multiPartMIMEReader = multiPartMIMEReader;
        }

        private void setResponse(ResponseImpl<T> response) {
            this._response = response;
        }

        public void onNewPart(MultiPartMIMEReader.SinglePartMIMEReader singlePartMIMEReader) {
            if (this._response == null) {
                FirstPartReaderCallback firstPartReaderCallback = new FirstPartReaderCallback(this, singlePartMIMEReader, this._streamResponse, this._responseCallback);
                singlePartMIMEReader.registerReaderCallback((SinglePartMIMEReaderCallback)firstPartReaderCallback);
                singlePartMIMEReader.requestPartData();
            } else {
                this._response.setAttachmentReader(new RestLiAttachmentReader(this._multiPartMIMEReader));
                this._responseCallback.onSuccess(this._response);
            }
        }

        public void onFinished() {
            if (this._response == null) {
                this._responseCallback.onError((Throwable)new RemoteInvocationException("Did not receive any parts in the multipart mime response!"));
                return;
            }
            this._response.setAttachmentReader(null);
            this._responseCallback.onSuccess(this._response);
        }

        public void onDrainComplete() {
        }

        public void onStreamError(Throwable throwable) {
            this._responseCallback.onError(throwable);
        }
    }
}

