/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.reporter.RecursiveScheduledReporter;

public abstract class RecursiveScheduledMetricReporter
extends RecursiveScheduledReporter {
    private MetricFilter filter;

    public RecursiveScheduledMetricReporter(MetricRegistry registry, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super(registry, name, filter, rateUnit, durationUnit);
        this.filter = filter;
    }

    @Override
    public void reportRegistry(MetricRegistry registry) {
        Map tags = Maps.newHashMap();
        if (registry instanceof MetricContext) {
            tags = Maps.transformValues(((MetricContext)registry).getTagMap(), (Function)new Function<Object, String>(){

                public String apply(Object input) {
                    return input.toString();
                }
            });
        }
        this.report(registry.getGauges(this.filter), registry.getCounters(this.filter), registry.getHistograms(this.filter), registry.getMeters(this.filter), registry.getTimers(this.filter), tags);
    }

    public abstract void report(SortedMap<String, Gauge> var1, SortedMap<String, Counter> var2, SortedMap<String, Histogram> var3, SortedMap<String, Meter> var4, SortedMap<String, Timer> var5, Map<String, String> var6);
}

