/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.topology;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.TopologySpec;
import org.apache.gobblin.service.modules.topology.TopologySpecFactory;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class ConfigBasedTopologySpecFactory
implements TopologySpecFactory {
    private static final Splitter SPLIT_BY_COMMA = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private final Config _config;
    private final Logger _log;
    private final ClassAliasResolver<SpecExecutor> _aliasResolver;

    public ConfigBasedTopologySpecFactory(Config config) {
        this(config, (Optional<Logger>)Optional.absent());
    }

    public ConfigBasedTopologySpecFactory(Config config, Optional<Logger> log) {
        Preconditions.checkNotNull((Object)config, (Object)"Config should not be null");
        this._log = log.isPresent() ? (Logger)log.get() : LoggerFactory.getLogger(this.getClass());
        this._config = config;
        this._aliasResolver = new ClassAliasResolver(SpecExecutor.class);
    }

    @Override
    public Collection<TopologySpec> getTopologies() {
        if (!this._config.hasPath("topologySpecFactory.topologyNames")) {
            return Collections.EMPTY_LIST;
        }
        ArrayList topologySpecs = Lists.newArrayList();
        List topologyNames = SPLIT_BY_COMMA.splitToList((CharSequence)this._config.getString("topologySpecFactory.topologyNames"));
        for (String topologyName : topologyNames) {
            SpecExecutor specExecutor;
            Preconditions.checkArgument((boolean)this._config.hasPath("topologySpecFactory." + topologyName), (Object)("Config does not contain Topology Factory descriptor for Topology " + topologyName));
            Config topologyConfig = this._config.getConfig("topologySpecFactory." + topologyName);
            String description = ConfigUtils.getString((Config)topologyConfig, (String)"description", (String)"NA");
            String version = ConfigUtils.getString((Config)topologyConfig, (String)"version", (String)"-1");
            String specExecutorClass = "org.apache.gobblin.runtime.spec_executorInstance.InMemorySpecExecutor";
            if (topologyConfig.hasPath("specExecutorInstance.class")) {
                specExecutorClass = topologyConfig.getString("specExecutorInstance.class");
            }
            try {
                this._log.info("Using SpecProducer class name/alias " + specExecutorClass);
                specExecutor = (SpecExecutor)ConstructorUtils.invokeConstructor(Class.forName(this._aliasResolver.resolve(specExecutorClass)), (Object[])new Object[]{topologyConfig});
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            TopologySpec.Builder topologySpecBuilder = TopologySpec.builder((String)topologyConfig.getString("uri")).withConfig(topologyConfig).withDescription(description).withVersion(version).withSpecExecutor(specExecutor);
            topologySpecs.add(topologySpecBuilder.build());
        }
        return topologySpecs;
    }
}

