/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class FileSystemKey
implements SharedResourceKey {
    private final URI uri;
    private final Configuration configuration;

    public FileSystemKey(URI uri, Configuration configuration) {
        this.configuration = configuration;
        this.uri = this.resolveURI(uri, configuration);
    }

    private URI resolveURI(URI uri, Configuration configuration) {
        URI defaultUri;
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        if (scheme == null && authority == null) {
            return FileSystem.getDefaultUri((Configuration)configuration);
        }
        if (scheme != null && authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri((Configuration)configuration)).getScheme()) && defaultUri.getAuthority() != null) {
            return defaultUri;
        }
        try {
            return new URI(scheme, Strings.nullToEmpty((String)authority), "/", null, null);
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    public String toConfigurationKey() {
        return this.uri.getScheme() + (this.uri.getHost() == null ? "" : "." + this.uri.getHost());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemKey that = (FileSystemKey)o;
        return this.uri == null ? that.uri == null : this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.uri != null ? this.uri.hashCode() : 0;
    }

    public URI getUri() {
        return this.uri;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

