/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    private static final Logger log = LoggerFactory.getLogger(PathUtils.class);
    public static final Pattern GLOB_TOKENS = Pattern.compile("[,\\?\\*\\[\\{]");

    public static Path mergePaths(Path path1, Path path2) {
        String path2Str = path2.toUri().getPath();
        if (!path2Str.startsWith("/")) {
            path2Str = "/" + path2Str;
        }
        return new Path(path1.toUri().getScheme(), path1.toUri().getAuthority(), path1.toUri().getPath() + path2Str);
    }

    public static Path relativizePath(Path fullPath, Path pathPrefix) {
        return new Path(PathUtils.getPathWithoutSchemeAndAuthority(pathPrefix).toUri().relativize(PathUtils.getPathWithoutSchemeAndAuthority(fullPath).toUri()));
    }

    public static boolean isAncestor(Path possibleAncestor, Path fullPath) {
        return !PathUtils.relativizePath(fullPath, possibleAncestor).equals((Object)PathUtils.getPathWithoutSchemeAndAuthority(fullPath));
    }

    public static Path getPathWithoutSchemeAndAuthority(Path path) {
        return new Path(null, null, path.toUri().getPath());
    }

    public static Path getRootPath(Path path) {
        if (path.isRoot()) {
            return path;
        }
        return PathUtils.getRootPath(path.getParent());
    }

    public static Path withoutLeadingSeparator(Path path) {
        return new Path(StringUtils.removeStart((String)path.toString(), (String)"/"));
    }

    public static Path deepestNonGlobPath(Path input) {
        Path commonRoot;
        for (commonRoot = input; commonRoot != null && PathUtils.isGlob(commonRoot); commonRoot = commonRoot.getParent()) {
        }
        return commonRoot;
    }

    public static boolean isGlob(Path path) {
        return path != null && GLOB_TOKENS.matcher(path.toString()).find();
    }

    public static Path removeExtension(Path path, String ... extensions) {
        String pathString = path.toString();
        for (String extension : extensions) {
            pathString = StringUtils.remove((String)pathString, (String)extension);
        }
        return new Path(pathString);
    }

    public static Path addExtension(Path path, String ... extensions) {
        StringBuilder pathStringBuilder = new StringBuilder(path.toString());
        for (String extension : extensions) {
            if (Strings.isNullOrEmpty((String)extension)) continue;
            pathStringBuilder.append(extension);
        }
        return new Path(pathStringBuilder.toString());
    }

    public static Path combinePaths(String ... paths) {
        if (paths.length == 0) {
            throw new IllegalArgumentException("Paths cannot be empty!");
        }
        Path path = new Path(paths[0]);
        for (int i = 1; i < paths.length; ++i) {
            path = new Path(path, paths[i]);
        }
        return path;
    }

    public static boolean isAbsoluteAndSchemeAuthorityNull(Path path) {
        return path.isAbsolute() && path.toUri().getScheme() == null && path.toUri().getAuthority() == null;
    }

    public static void deleteEmptyParentDirectories(FileSystem fs, Path limitPath, Path startPath) throws IOException {
        if (PathUtils.isAncestor(limitPath, startPath) && !PathUtils.getPathWithoutSchemeAndAuthority(limitPath).equals((Object)PathUtils.getPathWithoutSchemeAndAuthority(startPath)) && fs.listStatus(startPath).length == 0) {
            if (!fs.delete(startPath, false)) {
                log.warn("Failed to delete empty directory " + startPath);
            } else {
                log.info("Deleted empty directory " + startPath);
            }
            PathUtils.deleteEmptyParentDirectories(fs, limitPath, startPath.getParent());
        }
    }

    public static boolean compareWithoutSchemeAndAuthority(Path path1, Path path2) {
        return PathUtils.getPathWithoutSchemeAndAuthority(path1).equals((Object)PathUtils.getPathWithoutSchemeAndAuthority(path2));
    }
}

