/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gobblin.password.PasswordManager;
import org.apache.hadoop.fs.Path;
import org.jasypt.util.text.BasicTextEncryptor;
import org.jasypt.util.text.StrongTextEncryptor;
import org.jasypt.util.text.TextEncryptor;

public class CLIPasswordEncryptor {
    private static final char HELP_OPTION = 'h';
    private static final char PLAIN_PWD_OPTION = 'p';
    private static final char MASTER_PWD_OPTION = 'm';
    private static final char STRONG_ENCRYPTOR_OPTION = 's';
    private static final char MASTER_PWD_FILE_OPTION = 'f';
    private static final char ENCRYPTED_PWD_OPTION = 'e';
    private static final Pattern ENCRYPTED_PATTERN = Pattern.compile("ENC\\(([^)]+)\\)");
    private static final Options CLI_OPTIONS = new Options();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws ParseException {
        CommandLine cl = CLIPasswordEncryptor.parseArgs(args);
        if (CLIPasswordEncryptor.shouldPrintUsageAndExit(cl)) {
            CLIPasswordEncryptor.printUsage();
            return;
        }
        String masterPassword = CLIPasswordEncryptor.getMasterPassword(cl);
        TextEncryptor encryptor = CLIPasswordEncryptor.getEncryptor(cl, masterPassword);
        if (cl.hasOption('e')) {
            Matcher matcher = ENCRYPTED_PATTERN.matcher(cl.getOptionValue('e'));
            if (!matcher.find()) throw new RuntimeException("Input encrypted password does not match pattern \"ENC(...)\"");
            String encrypted = matcher.group(1);
            System.out.println(encryptor.decrypt(encrypted));
            return;
        } else if (cl.hasOption('p')) {
            System.out.println("ENC(" + encryptor.encrypt(cl.getOptionValue('p')) + ")");
            return;
        } else {
            CLIPasswordEncryptor.printUsage();
            throw new RuntimeException(String.format("Must provide -%s or -%s option.", Character.valueOf('p'), Character.valueOf('e')));
        }
    }

    private static TextEncryptor getEncryptor(CommandLine cl, String masterPassword) {
        if (cl.hasOption('s')) {
            StrongTextEncryptor encryptor = new StrongTextEncryptor();
            encryptor.setPassword(masterPassword);
            return encryptor;
        }
        BasicTextEncryptor encryptor = new BasicTextEncryptor();
        encryptor.setPassword(masterPassword);
        return encryptor;
    }

    private static String getMasterPassword(CommandLine cl) {
        if (cl.hasOption('m')) {
            if (cl.hasOption('f')) {
                System.out.println(String.format("both -%s and -%s are provided. Using -%s", Character.valueOf('m'), Character.valueOf('f'), Character.valueOf('m')));
            }
            return cl.getOptionValue('m');
        }
        Path masterPwdLoc = new Path(cl.getOptionValue('f'));
        Optional masterPwd = PasswordManager.getMasterPassword((Path)masterPwdLoc);
        if (masterPwd.isPresent()) {
            return (String)masterPwd.get();
        }
        throw new RuntimeException("Failed to get master password from " + masterPwdLoc);
    }

    private static CommandLine parseArgs(String[] args) throws ParseException {
        CLIPasswordEncryptor.initOptions(CLI_OPTIONS);
        return new DefaultParser().parse(CLI_OPTIONS, args);
    }

    private static Options initOptions(Options options) {
        options.addOption(new Option("h", "print this message"));
        options.addOption(Option.builder((String)"p").argName("plain password").hasArg().desc("plain password to be encrypted").build());
        options.addOption(Option.builder((String)"m").argName("master password").hasArg().desc("master password used to encrypt the plain password").build());
        options.addOption(Option.builder((String)"f").argName("master password file").hasArg().desc("file that contains the master password used to encrypt the plain password").build());
        options.addOption(new Option("s", "use strong encryptor"));
        options.addOption(Option.builder((String)"e").argName("decrypt the input").hasArg().build());
        return options;
    }

    private static boolean shouldPrintUsageAndExit(CommandLine cl) {
        if (cl.hasOption('h')) {
            return true;
        }
        return !CLIPasswordEncryptor.masterpasswordProvided(cl);
    }

    private static boolean masterpasswordProvided(CommandLine cl) {
        return cl.hasOption('m') || cl.hasOption('f');
    }

    private static void printUsage() {
        new HelpFormatter().printHelp(" ", CLI_OPTIONS);
    }
}

