/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.locks;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.runtime.locks.FileBasedJobLockFactory;
import org.apache.gobblin.runtime.locks.JobLock;
import org.apache.gobblin.runtime.locks.JobLockException;
import org.apache.hadoop.fs.Path;

public class FileBasedJobLock
implements JobLock {
    public static final String JOB_LOCK_DIR = "job.lock.dir";
    public static final String LOCK_FILE_EXTENSION = ".lock";
    private final FileBasedJobLockFactory parent;
    private final Path lockFile;

    public FileBasedJobLock(Properties properties) throws JobLockException {
        this(properties.getProperty("job.name"), FileBasedJobLockFactory.createForProperties(properties));
    }

    FileBasedJobLock(String jobName, FileBasedJobLockFactory parent) {
        this.parent = parent;
        this.lockFile = parent.getLockFile(jobName);
    }

    @Override
    public void lock() throws JobLockException {
        this.parent.lock(this.lockFile);
    }

    @Override
    public void unlock() throws JobLockException {
        this.parent.unlock(this.lockFile);
    }

    @Override
    public boolean tryLock() throws JobLockException {
        return this.parent.tryLock(this.lockFile);
    }

    @Override
    public boolean isLocked() throws JobLockException {
        return this.parent.isLocked(this.lockFile);
    }

    @Override
    public void close() throws IOException {
    }

    @VisibleForTesting
    Path getLockFile() {
        return this.lockFile;
    }
}

