/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_monitor;

import com.codahale.metrics.Meter;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.reporter.util.SchemaVersionWriter;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.MutableJobCatalog;
import org.apache.gobblin.runtime.job_monitor.KafkaJobMonitor;
import org.apache.gobblin.util.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaAvroJobMonitor<T>
extends KafkaJobMonitor {
    private static final Logger log = LoggerFactory.getLogger(KafkaAvroJobMonitor.class);
    private final Schema schema;
    private final ThreadLocal<BinaryDecoder> decoder;
    private final ThreadLocal<SpecificDatumReader<T>> reader;
    private final SchemaVersionWriter<?> versionWriter;
    private Meter messageParseFailures;

    public KafkaAvroJobMonitor(String topic, MutableJobCatalog catalog, Config config, Schema schema, SchemaVersionWriter<?> versionWriter) {
        super(topic, catalog, config);
        this.schema = schema;
        this.decoder = new ThreadLocal<BinaryDecoder>(){

            @Override
            protected BinaryDecoder initialValue() {
                ByteArrayInputStream dummyInputStream = new ByteArrayInputStream(new byte[0]);
                return DecoderFactory.get().binaryDecoder((InputStream)dummyInputStream, null);
            }
        };
        this.reader = new ThreadLocal<SpecificDatumReader<T>>(){

            @Override
            protected SpecificDatumReader<T> initialValue() {
                return new SpecificDatumReader(KafkaAvroJobMonitor.this.schema);
            }
        };
        this.versionWriter = versionWriter;
    }

    @Override
    protected List<Tag<?>> getTagsForMetrics() {
        List<Tag<?>> tags = super.getTagsForMetrics();
        tags.add(new Tag("schema", (Object)this.schema.getName()));
        return tags;
    }

    @Override
    protected void createMetrics() {
        super.createMetrics();
        this.messageParseFailures = this.getMetricContext().meter("gobblin.jobMonitor.kafka.messageParseFailures");
    }

    @Override
    public Collection<Either<JobSpec, URI>> parseJobSpec(byte[] message) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(message);
        this.versionWriter.readSchemaVersioningInformation(new DataInputStream(is));
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)is, this.decoder.get());
        try {
            Object decodedMessage = this.reader.get().read(null, (Decoder)decoder);
            return this.parseJobSpec(decodedMessage);
        }
        catch (IOException | AvroRuntimeException exc) {
            this.messageParseFailures.mark();
            if (this.messageParseFailures.getFiveMinuteRate() < 1.0) {
                log.warn("Unable to decode input message.", exc);
            } else {
                log.warn("Unable to decode input message.");
            }
            return Lists.newArrayList();
        }
    }

    public abstract Collection<Either<JobSpec, URI>> parseJobSpec(T var1);

    public SchemaVersionWriter<?> getVersionWriter() {
        return this.versionWriter;
    }

    public Meter getMessageParseFailures() {
        return this.messageParseFailures;
    }
}

