/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.instance;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.AbstractIdleService;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.gobblin.broker.SharedResourcesBrokerFactory;
import org.apache.gobblin.broker.SharedResourcesBrokerImpl;
import org.apache.gobblin.broker.SimpleScope;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.ScopeInstance;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.api.Configurable;
import org.apache.gobblin.runtime.api.GobblinInstanceDriver;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.GobblinInstanceLauncher;
import org.apache.gobblin.runtime.instance.StandardGobblinInstanceDriver;
import org.apache.gobblin.runtime.std.DefaultConfigurableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardGobblinInstanceLauncher
extends AbstractIdleService
implements GobblinInstanceLauncher {
    private final Logger _log;
    private final String _name;
    private final Configurable _instanceConf;
    private final StandardGobblinInstanceDriver _driver;
    private final MetricContext _metricContext;
    private final boolean _instrumentationEnabled;
    private final SharedResourcesBroker<GobblinScopeTypes> _instanceBroker;

    protected StandardGobblinInstanceLauncher(String name, Configurable instanceConf, StandardGobblinInstanceDriver.Builder driverBuilder, Optional<MetricContext> metricContext, Optional<Logger> log, SharedResourcesBroker<GobblinScopeTypes> instanceBroker) {
        this._log = (Logger)log.or((Object)LoggerFactory.getLogger(this.getClass()));
        this._name = name;
        this._instanceConf = instanceConf;
        this._driver = driverBuilder.withInstanceEnvironment(this).build();
        this._instrumentationEnabled = metricContext.isPresent();
        this._metricContext = (MetricContext)metricContext.orNull();
        this._instanceBroker = instanceBroker;
    }

    @Override
    public Config getConfig() {
        return this._instanceConf.getConfig();
    }

    @Override
    public Properties getConfigAsProperties() {
        return this._instanceConf.getConfigAsProperties();
    }

    @Override
    public GobblinInstanceDriver getDriver() throws IllegalStateException {
        return this._driver;
    }

    @Override
    public String getInstanceName() {
        return this._name;
    }

    @Override
    public SharedResourcesBroker<GobblinScopeTypes> getInstanceBroker() {
        return this._instanceBroker;
    }

    protected void startUp() throws Exception {
        this._driver.startUp();
    }

    protected void shutDown() throws Exception {
        this._driver.shutDown();
    }

    public static Builder builder() {
        return new Builder();
    }

    public MetricContext getMetricContext() {
        return this._metricContext;
    }

    public boolean isInstrumentationEnabled() {
        return this._instrumentationEnabled;
    }

    public List<Tag<?>> generateTags(State state) {
        return Collections.emptyList();
    }

    public void switchMetricContext(List<Tag<?>> tags) {
        throw new UnsupportedOperationException();
    }

    public void switchMetricContext(MetricContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getLog() {
        return this._log;
    }

    @Override
    public Configurable getSysConfig() {
        return this;
    }

    public static class Builder
    implements GobblinInstanceEnvironment {
        static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(1);
        Optional<String> _name = Optional.absent();
        Optional<Logger> _log = Optional.absent();
        StandardGobblinInstanceDriver.Builder _driver = new StandardGobblinInstanceDriver.Builder();
        Optional<? extends Configurable> _instanceConfig = Optional.absent();
        Optional<Boolean> _instrumentationEnabled = Optional.absent();
        Optional<MetricContext> _metricContext = Optional.absent();
        Optional<SharedResourcesBroker<GobblinScopeTypes>> _instanceBroker = Optional.absent();

        public Builder() {
            this._driver.withInstanceEnvironment(this);
        }

        public String getDefaultInstanceName() {
            return StandardGobblinInstanceLauncher.class.getSimpleName() + "-" + INSTANCE_COUNT.getAndIncrement();
        }

        @Override
        public String getInstanceName() {
            if (!this._name.isPresent()) {
                this._name = Optional.of((Object)this.getDefaultInstanceName());
            }
            return (String)this._name.get();
        }

        public Builder withInstanceName(String instanceName) {
            this._name = Optional.of((Object)instanceName);
            return this;
        }

        public Logger getDefaultLog() {
            return LoggerFactory.getLogger((String)this.getInstanceName());
        }

        @Override
        public Logger getLog() {
            if (!this._log.isPresent()) {
                this._log = Optional.of((Object)this.getDefaultLog());
            }
            return (Logger)this._log.get();
        }

        public Builder withLog(Logger log) {
            this._log = Optional.of((Object)log);
            return this;
        }

        public StandardGobblinInstanceDriver.Builder driver() {
            return this._driver;
        }

        public Configurable getDefaultSysConfig() {
            return DefaultConfigurableImpl.createFromConfig(ConfigFactory.load());
        }

        @Override
        public Configurable getSysConfig() {
            if (!this._instanceConfig.isPresent()) {
                this._instanceConfig = Optional.of((Object)this.getDefaultSysConfig());
            }
            return (Configurable)this._instanceConfig.get();
        }

        public Builder withSysConfig(Config instanceConfig) {
            this._instanceConfig = Optional.of((Object)DefaultConfigurableImpl.createFromConfig(instanceConfig));
            return this;
        }

        public Builder withSysConfig(Properties instanceConfig) {
            this._instanceConfig = Optional.of((Object)DefaultConfigurableImpl.createFromProperties(instanceConfig));
            return this;
        }

        public Builder setInstrumentationEnabled(boolean enabled) {
            this._instrumentationEnabled = Optional.of((Object)enabled);
            return this;
        }

        public boolean isInstrumentationEnabled() {
            if (!this._instrumentationEnabled.isPresent()) {
                this._instrumentationEnabled = Optional.of((Object)this.getDefaultInstrumentationEnabled());
            }
            return (Boolean)this._instrumentationEnabled.get();
        }

        public Builder setMetricContext(MetricContext metricContext) {
            this._metricContext = Optional.of((Object)metricContext);
            return this;
        }

        public MetricContext getMetricContext() {
            if (!this._metricContext.isPresent()) {
                this._metricContext = Optional.of((Object)this.getDefaultMetricContext());
            }
            return (MetricContext)this._metricContext.get();
        }

        private MetricContext getDefaultMetricContext() {
            State fakeState = new State(this.getSysConfig().getConfigAsProperties());
            return Instrumented.getMetricContext((State)fakeState, StandardGobblinInstanceLauncher.class);
        }

        private boolean getDefaultInstrumentationEnabled() {
            return GobblinMetrics.isEnabled((Config)this.getSysConfig().getConfig());
        }

        public Builder withInstanceBroker(SharedResourcesBroker<GobblinScopeTypes> broker) {
            this._instanceBroker = Optional.of(broker);
            return this;
        }

        @Override
        public SharedResourcesBroker<GobblinScopeTypes> getInstanceBroker() {
            if (!this._instanceBroker.isPresent()) {
                this._instanceBroker = Optional.of(this.getDefaultInstanceBroker());
            }
            return (SharedResourcesBroker)this._instanceBroker.get();
        }

        public SharedResourcesBroker<GobblinScopeTypes> getDefaultInstanceBroker() {
            SharedResourcesBrokerImpl globalBroker = SharedResourcesBrokerFactory.createDefaultTopLevelBroker((Config)this.getSysConfig().getConfig(), (ScopeInstance)GobblinScopeTypes.GLOBAL.defaultScopeInstance());
            return globalBroker.newSubscopedBuilder((ScopeInstance)new SimpleScope((ScopeType)GobblinScopeTypes.INSTANCE, this.getInstanceName())).build();
        }

        public StandardGobblinInstanceLauncher build() {
            return new StandardGobblinInstanceLauncher(this.getInstanceName(), this.getSysConfig(), this.driver(), (Optional<MetricContext>)(this.isInstrumentationEnabled() ? Optional.of((Object)this.getMetricContext()) : Optional.absent()), (Optional<Logger>)Optional.of((Object)this.getLog()), this.getInstanceBroker());
        }

        public List<Tag<?>> generateTags(State state) {
            return Collections.emptyList();
        }

        public void switchMetricContext(List<Tag<?>> tags) {
            throw new UnsupportedOperationException();
        }

        public void switchMetricContext(MetricContext context) {
            throw new UnsupportedOperationException();
        }
    }
}

