/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cli;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.linkedin.r2.RemoteInvocationException;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.gobblin.cli.AdminClient;
import org.apache.gobblin.cli.Cli;
import org.apache.gobblin.cli.Command;
import org.apache.gobblin.cli.JobInfoPrintUtils;
import org.apache.gobblin.rest.JobExecutionInfo;
import org.apache.gobblin.rest.QueryListType;

public class JobCommand
implements Command {
    private Options options;
    private static final String HELP_OPT = "help";
    private static final String DETAILS_OPT = "details";
    private static final String LIST_OPT = "list";
    private static final String NAME_OPT = "name";
    private static final String ID_OPT = "id";
    private static final String PROPS_OPT = "properties";
    private static final String RECENT_OPT = "recent";
    private static final int DEFAULT_RESULTS_LIMIT = 10;
    private static final Map<String, SubCommand> subCommandMap = ImmutableMap.of((Object)"list", (Object)new ListAllItemsCommand(), (Object)"details", (Object)new ListOneItemWithDetails(), (Object)"properties", (Object)new ListItemsWithPropertiesCommand());

    private SubCommand getAction(CommandLine parsedOpts) {
        for (Map.Entry<String, SubCommand> entry : subCommandMap.entrySet()) {
            if (!parsedOpts.hasOption(entry.getKey())) continue;
            return entry.getValue();
        }
        this.printHelpAndExit("Unknown subcommand");
        throw new IllegalStateException("unreached...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Cli.GlobalOptions globalOptions, String[] otherArgs) {
        this.options = this.createCommandLineOptions();
        DefaultParser parser = new DefaultParser();
        try (AdminClient adminClient = null;){
            CommandLine parsedOpts = parser.parse(this.options, otherArgs);
            int resultLimit = this.parseResultsLimit(parsedOpts);
            adminClient = new AdminClient(globalOptions.getAdminServerHost(), globalOptions.getAdminServerPort());
            try {
                this.getAction(parsedOpts).execute(parsedOpts, adminClient, resultLimit);
            }
            catch (CommandException e) {
                this.printHelpAndExit(e.getMessage());
            }
        }
    }

    private Options createCommandLineOptions() {
        Options options = new Options();
        OptionGroup actionGroup = new OptionGroup();
        actionGroup.addOption(new Option("h", HELP_OPT, false, "Shows the help message."));
        actionGroup.addOption(new Option("d", DETAILS_OPT, false, "Show details about a job/task."));
        actionGroup.addOption(new Option("l", LIST_OPT, false, "List jobs/tasks."));
        actionGroup.addOption(new Option("p", PROPS_OPT, false, "Fetch properties with the query."));
        actionGroup.setRequired(true);
        options.addOptionGroup(actionGroup);
        OptionGroup idGroup = new OptionGroup();
        idGroup.addOption(new Option("j", NAME_OPT, true, "Find job(s) matching given job name."));
        idGroup.addOption(new Option("i", ID_OPT, true, "Find the job/task with the given id."));
        options.addOptionGroup(idGroup);
        options.addOption("n", true, "Limit the number of results returned. (default:10)");
        options.addOption("r", RECENT_OPT, false, "List the most recent jobs (instead of a list of unique jobs)");
        return options;
    }

    private int parseResultsLimit(CommandLine parsedOpts) {
        if (parsedOpts.hasOption("n")) {
            try {
                return Integer.parseInt(parsedOpts.getOptionValue("n"));
            }
            catch (NumberFormatException e) {
                this.printHelpAndExit("Could not parse integer value for option n.");
                return 0;
            }
        }
        return 10;
    }

    private void printHelpAndExit(String errorMsg) {
        System.out.println(errorMsg);
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("gobblin-admin.sh jobs [options]", this.options);
        System.exit(1);
    }

    private static class ListItemsWithPropertiesCommand
    implements SubCommand {
        private ListItemsWithPropertiesCommand() {
        }

        @Override
        public void execute(CommandLine parsedOpts, AdminClient adminClient, int resultsLimit) throws CommandException {
            block6: {
                try {
                    if (parsedOpts.hasOption(JobCommand.ID_OPT)) {
                        JobInfoPrintUtils.printJobProperties(adminClient.queryByJobId(parsedOpts.getOptionValue(JobCommand.ID_OPT)));
                        break block6;
                    }
                    if (parsedOpts.hasOption(JobCommand.NAME_OPT)) {
                        List<JobExecutionInfo> infos = adminClient.queryByJobName(parsedOpts.getOptionValue(JobCommand.NAME_OPT), 1);
                        if (infos.size() == 0) {
                            System.out.println("No job by that name found");
                        } else {
                            JobInfoPrintUtils.printJobProperties((Optional<JobExecutionInfo>)Optional.of((Object)infos.get(0)));
                        }
                        break block6;
                    }
                    throw new CommandException("Please specify a job id or name");
                }
                catch (RemoteInvocationException e) {
                    throw new CommandException("Error talking to adminServer: " + e.getMessage());
                }
            }
        }
    }

    private static class ListOneItemWithDetails
    implements SubCommand {
        private ListOneItemWithDetails() {
        }

        @Override
        public void execute(CommandLine parsedOpts, AdminClient adminClient, int resultsLimit) throws CommandException {
            try {
                if (!parsedOpts.hasOption(JobCommand.ID_OPT)) {
                    throw new CommandException("Please specify an id");
                }
                JobInfoPrintUtils.printJob(adminClient.queryByJobId(parsedOpts.getOptionValue(JobCommand.ID_OPT)));
            }
            catch (RemoteInvocationException e) {
                throw new CommandException("Error talking to adminServer: " + e.getMessage());
            }
        }
    }

    private static class ListAllItemsCommand
    implements SubCommand {
        private ListAllItemsCommand() {
        }

        @Override
        public void execute(CommandLine parsedOpts, AdminClient adminClient, int resultsLimit) throws CommandException {
            try {
                if (parsedOpts.hasOption(JobCommand.NAME_OPT)) {
                    JobInfoPrintUtils.printJobRuns(adminClient.queryByJobName(parsedOpts.getOptionValue(JobCommand.NAME_OPT), resultsLimit));
                } else if (parsedOpts.hasOption(JobCommand.RECENT_OPT)) {
                    JobInfoPrintUtils.printAllJobs(adminClient.queryAllJobs(QueryListType.RECENT, resultsLimit), resultsLimit);
                } else {
                    JobInfoPrintUtils.printAllJobs(adminClient.queryAllJobs(QueryListType.DISTINCT, resultsLimit), resultsLimit);
                }
            }
            catch (RemoteInvocationException e) {
                throw new CommandException("Error talking to adminServer: " + e.getMessage());
            }
        }
    }

    private static interface SubCommand {
        public void execute(CommandLine var1, AdminClient var2, int var3) throws CommandException;
    }

    private static class CommandException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CommandException(String msg) {
            super(msg);
        }
    }
}

