/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.stats;

import com.linkedin.common.stats.LongStats;
import com.linkedin.common.util.ConfigHelper;
import java.util.Arrays;

public class LongTracking {
    private static final int DEFAULT_INITIAL_CAPACITY = 1000;
    private static final double DEFAULT_GROWTH_FACTOR = 2.0;
    private static final int DEFAULT_MAX_CAPACITY = 4000;
    private long[] _buffer;
    private int _bufferSize;
    private final int _initialCapacity;
    private final double _growthFactor;
    private final int _maxCapacity;
    private int _count;
    private long _min;
    private long _max;
    private long _sum;
    private long _sumOfSquares;
    private int _sortedEnd;
    private int _nextIndex;
    private int _keepRatio;

    public LongTracking() {
        this(4000, 1000, 2.0);
    }

    public LongTracking(Config config) {
        this(config.getMaxCapacity(), config.getInitialCapacity(), config.getGrowthFactor());
    }

    public LongTracking(int maxCapacity, int initialCapacity, double growthFactor) {
        if (initialCapacity > maxCapacity || initialCapacity <= 0) {
            initialCapacity = maxCapacity;
        }
        if (growthFactor <= 1.0) {
            growthFactor = 2.0;
        }
        this._buffer = new long[initialCapacity];
        this._bufferSize = initialCapacity;
        this._initialCapacity = initialCapacity;
        this._growthFactor = growthFactor;
        this._maxCapacity = maxCapacity;
        this.reset();
    }

    public void reset() {
        this._count = 0;
        this._min = 0L;
        this._max = 0L;
        this._sum = 0L;
        this._sumOfSquares = 0L;
        this._sortedEnd = 0;
        this._nextIndex = 0;
        this._keepRatio = 1;
    }

    public void addValue(long value) {
        if (this._count == 0) {
            this._min = this._max = value;
        } else if (value < this._min) {
            this._min = value;
        } else if (value > this._max) {
            this._max = value;
        }
        this._sum += value;
        this._sumOfSquares += value * value;
        ++this._count;
        if (this._keepRatio > 1 && this._count % this._keepRatio != 0) {
            return;
        }
        if (this._nextIndex >= this._bufferSize) {
            if (this._bufferSize < this._maxCapacity) {
                this.grow();
            } else {
                this.dropHalf();
            }
        }
        this._buffer[this._nextIndex] = value;
        ++this._nextIndex;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public int getInitialCapacity() {
        return this._initialCapacity;
    }

    public double getGrowthFactor() {
        return this._growthFactor;
    }

    public int getMaxCapacity() {
        return this._maxCapacity;
    }

    public LongStats getStats() {
        return new LongStats(this.getCount(), this.getAverage(), this.getStandardDeviation(), this.getMinimum(), this.getMaximum(), this.get50Pct(), this.get90Pct(), this.get95Pct(), this.get99Pct());
    }

    private int getCount() {
        return this._count;
    }

    private double getAverage() {
        return LongTracking.safeDivide(this._sum, this._count);
    }

    private double getStandardDeviation() {
        double variation = LongTracking.safeDivide((double)this._sumOfSquares - (double)this._sum * this.getAverage(), this.getCount());
        return Math.sqrt(variation);
    }

    private long getMinimum() {
        return this._min;
    }

    private long getMaximum() {
        return this._max;
    }

    private long get50Pct() {
        return this.getPercentile(0.5);
    }

    private long get90Pct() {
        return this.getPercentile(0.9);
    }

    private long get95Pct() {
        return this.getPercentile(0.95);
    }

    private long get99Pct() {
        return this.getPercentile(0.99);
    }

    private long getPercentile(double pct) {
        if (this._count == 0) {
            return 0L;
        }
        if (this._sortedEnd < this._nextIndex) {
            Arrays.sort(this._buffer, 0, this._nextIndex);
            this._sortedEnd = this._nextIndex;
        }
        if (pct < 0.0) {
            pct = 0.0;
        } else if (pct > 1.0) {
            pct = 1.0;
        }
        int index = (int)Math.round(pct * (double)(this._sortedEnd - 1));
        return this._buffer[index];
    }

    private void dropHalf() {
        this._nextIndex = (this._nextIndex + 1) / 2;
        this._sortedEnd = (this._sortedEnd + 1) / 2;
        this._keepRatio += this._keepRatio;
        int destIndex = 1;
        int lastSrcIndex = 0;
        while (destIndex < this._nextIndex) {
            this._buffer[destIndex++] = this._buffer[lastSrcIndex += 2];
        }
    }

    private void grow() {
        int newBufferSize = (int)((double)this._bufferSize * this._growthFactor);
        if (newBufferSize == this._bufferSize) {
            newBufferSize += 1000;
        }
        if (newBufferSize > this._maxCapacity) {
            newBufferSize = this._maxCapacity;
        }
        long[] newBuffer = new long[newBufferSize];
        System.arraycopy(this._buffer, 0, newBuffer, 0, this._nextIndex);
        this._buffer = newBuffer;
        this._bufferSize = newBufferSize;
    }

    private static double safeDivide(double numerator, double denominator) {
        return denominator != 0.0 ? numerator / denominator : 0.0;
    }

    public static class Config {
        private Integer _maxCapacity = 4000;
        private Integer _initialCapacity = 1000;
        private Double _growthFactor = 2.0;

        Config() {
        }

        public int getMaxCapacity() {
            return ConfigHelper.getRequired(this._maxCapacity);
        }

        public void setMaxCapacity(int maxCapacity) {
            this._maxCapacity = maxCapacity;
        }

        public int getInitialCapacity() {
            return ConfigHelper.getRequired(this._initialCapacity);
        }

        public void setInitialCapacity(int initialCapacity) {
            this._initialCapacity = initialCapacity;
        }

        public double getGrowthFactor() {
            return ConfigHelper.getRequired(this._growthFactor);
        }

        public void setGrowthFactor(double growthFactor) {
            this._growthFactor = growthFactor;
        }
    }
}

