/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.caprep.db;

import com.linkedin.r2.caprep.db.DbSink;
import com.linkedin.r2.caprep.db.DirectoryDbUtil;
import com.linkedin.r2.caprep.db.MessageSerializer;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class DirectoryDbSink
implements DbSink {
    private final File _dir;
    private final MessageSerializer _serializer;
    private final AtomicInteger _count;

    public DirectoryDbSink(String dir, MessageSerializer serializer) throws IOException {
        this(new File(dir), serializer);
    }

    public DirectoryDbSink(File dir, MessageSerializer serializer) throws IOException {
        this._dir = dir;
        if (!this._dir.exists() & !this._dir.mkdirs()) {
            throw new IOException("Could not create directory: " + this._dir);
        }
        this._serializer = serializer;
        int maxCount = -1;
        for (String id : DirectoryDbUtil.listRequestIds(this._dir)) {
            maxCount = Math.max(maxCount, DirectoryDbUtil.getIndex(id));
        }
        this._count = new AtomicInteger(maxCount + 1);
    }

    @Override
    public void record(RestRequest req, RestResponse res) throws IOException {
        int id = this._count.getAndIncrement();
        this.writeRequest(req, id);
        this.writeResponse(res, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequest(RestRequest req, int id) throws IOException {
        File file = DirectoryDbUtil.restRequestFileName(this._dir, id);
        try (FileOutputStream out = new FileOutputStream(file);){
            this._serializer.writeRequest(out, req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(RestResponse res, int id) throws IOException {
        File file = DirectoryDbUtil.restResponseFileName(this._dir, id);
        try (FileOutputStream out = new FileOutputStream(file);){
            this._serializer.writeResponse(out, res);
        }
    }
}

