/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectMapTemplate;
import java.util.Map;

public final class FloatMap
extends DirectMapTemplate<Float> {
    private static final MapDataSchema SCHEMA = (MapDataSchema)DataTemplateUtil.parseSchema("{ \"type\" : \"map\", \"values\" : \"float\" }");

    public FloatMap() {
        this(new DataMap());
    }

    public FloatMap(int initialCapacity) {
        this(new DataMap(initialCapacity));
    }

    public FloatMap(int initialCapacity, float loadFactor) {
        this(new DataMap(initialCapacity, loadFactor));
    }

    public FloatMap(Map<String, Float> m) {
        this(FloatMap.newDataMapOfSize(m.size()));
        this.putAll(m);
    }

    public FloatMap(DataMap map) {
        super(map, SCHEMA, Float.class, Float.class);
    }

    @Override
    public FloatMap clone() throws CloneNotSupportedException {
        return (FloatMap)super.clone();
    }

    @Override
    public FloatMap copy() throws CloneNotSupportedException {
        return (FloatMap)super.copy();
    }
}

