/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.AbstractSchemaEncoder;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class SchemaToPdlEncoder
extends AbstractSchemaEncoder {
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("array", "enum", "fixed", "import", "includes", "map", "namespace", "optional", "package", "record", "typeref", "union", "null", "true", "false"));
    private static final JacksonDataCodec CODEC = new JacksonDataCodec();
    private final Writer _out;
    private Map<String, Name> _importsByLocalName;
    private int _indentDepth = 0;
    private String _namespace = null;
    private String _package = null;

    public SchemaToPdlEncoder(Writer out) {
        this._out = out;
    }

    @Override
    public void encode(DataSchema schema) throws IOException {
        this._importsByLocalName = this._typeReferenceFormat != AbstractSchemaEncoder.TypeReferenceFormat.DENORMALIZE ? this.computeImports(schema) : Collections.emptyMap();
        if (schema instanceof NamedDataSchema) {
            NamedDataSchema namedSchema = (NamedDataSchema)schema;
            boolean hasNamespace = StringUtils.isNotBlank((CharSequence)namedSchema.getNamespace());
            boolean hasPackage = StringUtils.isNotBlank((CharSequence)namedSchema.getPackage());
            if (hasNamespace || hasPackage) {
                if (hasNamespace) {
                    this.writeLine("namespace " + this.escapeIdentifier(namedSchema.getNamespace()));
                    this._namespace = namedSchema.getNamespace();
                }
                if (hasPackage) {
                    this.writeLine("package " + this.escapeIdentifier(namedSchema.getPackage()));
                    this._package = namedSchema.getPackage();
                }
                this.newline();
            }
        }
        if (this._importsByLocalName.size() > 0) {
            for (Name importName : new TreeSet<Name>(this._importsByLocalName.values())) {
                if (importName.getNamespace().equals(this._namespace)) continue;
                this.writeLine("import " + this.escapeIdentifier(importName.getFullName()));
            }
            this.newline();
        }
        this.writeInlineSchema(schema);
    }

    private void writeInlineSchema(DataSchema schema) throws IOException {
        boolean hasNamespaceOverride = false;
        boolean hasPackageOverride = false;
        String surroundingNamespace = this._namespace;
        String surroundingPackage = this._package;
        if (schema instanceof NamedDataSchema) {
            NamedDataSchema namedSchema = (NamedDataSchema)schema;
            hasNamespaceOverride = !namedSchema.getNamespace().equals(surroundingNamespace);
            boolean bl = hasPackageOverride = !StringUtils.isEmpty((CharSequence)namedSchema.getPackage()) && !namedSchema.getPackage().equals(surroundingPackage);
            if (hasNamespaceOverride || hasPackageOverride) {
                this.write("{");
                this.newline();
                ++this._indentDepth;
                this.indent();
                if (hasNamespaceOverride) {
                    this.write("namespace ");
                    this.write(namedSchema.getNamespace());
                    this.newline();
                    this.indent();
                    this._namespace = namedSchema.getNamespace();
                }
                if (hasPackageOverride) {
                    this.write("package ");
                    this.write(namedSchema.getPackage());
                    this.newline();
                    this.indent();
                    this._package = namedSchema.getPackage();
                }
            }
        }
        switch (schema.getType()) {
            case RECORD: {
                this.writeRecord((RecordDataSchema)schema);
                break;
            }
            case ENUM: {
                this.writeEnum((EnumDataSchema)schema);
                break;
            }
            case FIXED: {
                this.writeFixed((FixedDataSchema)schema);
                break;
            }
            case TYPEREF: {
                this.writeTyperef((TyperefDataSchema)schema);
                break;
            }
            case ARRAY: {
                this.writeArray((ArrayDataSchema)schema);
                break;
            }
            case MAP: {
                this.writeMap((MapDataSchema)schema);
                break;
            }
            case UNION: {
                this.writeUnion((UnionDataSchema)schema);
                break;
            }
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BYTES: {
                this.writePrimitive((PrimitiveDataSchema)schema);
                break;
            }
            case NULL: {
                this.write("null");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized schema type " + schema.getClass());
            }
        }
        if (hasNamespaceOverride || hasPackageOverride) {
            --this._indentDepth;
            this.newline();
            this.indent();
            this.write("}");
            this._namespace = surroundingNamespace;
            this._package = surroundingPackage;
        }
    }

    private void writeRecord(RecordDataSchema schema) throws IOException {
        boolean hasDoc = this.writeDoc(schema.getDoc());
        boolean hasProperties = this.writeProperties(schema.getProperties());
        if (hasDoc || hasProperties) {
            this.indent();
        }
        this.write("record ");
        this.write(this.toTypeIdentifier(schema));
        List<NamedDataSchema> includes = schema.getInclude();
        if (includes.size() > 0) {
            this.write(" includes ");
            Iterator<NamedDataSchema> iter = includes.iterator();
            while (iter.hasNext()) {
                NamedDataSchema include = iter.next();
                this.writeReferenceOrInline(include, schema.isIncludeDeclaredInline(include));
                if (!iter.hasNext()) continue;
                this.write(", ");
            }
        }
        this.write(" {");
        this.newline();
        ++this._indentDepth;
        for (RecordDataSchema.Field field : schema.getFields()) {
            if (!field.getRecord().equals(schema)) continue;
            if (StringUtils.isNotBlank((CharSequence)field.getDoc()) || !field.getProperties().isEmpty() || field.isDeclaredInline()) {
                this.newline();
            }
            this.writeDoc(field.getDoc());
            this.writeProperties(field.getProperties());
            this.indent();
            this.write(this.escapeIdentifier(field.getName()));
            this.write(": ");
            if (field.getOptional()) {
                this.write("optional ");
            }
            this.writeReferenceOrInline(field.getType(), field.isDeclaredInline());
            if (field.getDefault() != null) {
                this.write(" = ");
                this.write(this.toJson(field.getDefault()));
            }
            this.newline();
        }
        --this._indentDepth;
        this.indent();
        this.write("}");
    }

    private void writeEnum(EnumDataSchema schema) throws IOException {
        boolean hasDoc = this.writeDoc(schema.getDoc());
        DataMap properties = new DataMap((Map<? extends String, ? extends Object>)schema.getProperties());
        DataMap propertiesMap = new DataMap(this.coercePropertyToDataMapOrFail(schema, "symbolProperties", properties.remove("symbolProperties")));
        DataMap deprecatedMap = this.coercePropertyToDataMapOrFail(schema, "deprecatedSymbols", properties.remove("deprecatedSymbols"));
        boolean hasProperties = this.writeProperties(properties);
        if (hasDoc || hasProperties) {
            this.indent();
        }
        this.write("enum ");
        this.write(this.toTypeIdentifier(schema));
        this.write(" {");
        this.newline();
        ++this._indentDepth;
        Map<String, String> docs = schema.getSymbolDocs();
        for (String symbol : schema.getSymbols()) {
            String docString = docs.get(symbol);
            DataMap symbolProperties = this.coercePropertyToDataMapOrFail(schema, "symbolProperties." + symbol, propertiesMap.get(symbol));
            Object deprecated = deprecatedMap.get(symbol);
            if (deprecated != null) {
                symbolProperties.put("deprecated", deprecated);
            }
            if (StringUtils.isNotBlank((CharSequence)docString) || !symbolProperties.isEmpty()) {
                this.newline();
            }
            this.writeDoc(docString);
            this.writeProperties(symbolProperties);
            this.writeLine(symbol);
        }
        --this._indentDepth;
        this.indent();
        this.write("}");
    }

    private void writeFixed(FixedDataSchema schema) throws IOException {
        this.writeDoc(schema.getDoc());
        this.writeProperties(schema.getProperties());
        this.write("fixed ");
        this.write(this.toTypeIdentifier(schema));
        this.write(" ");
        this.write(String.valueOf(schema.getSize()));
    }

    private void writeTyperef(TyperefDataSchema schema) throws IOException {
        this.writeDoc(schema.getDoc());
        this.writeProperties(schema.getProperties());
        this.write("typeref ");
        this.write(this.toTypeIdentifier(schema));
        this.write(" = ");
        DataSchema ref = schema.getRef();
        this.writeReferenceOrInline(ref, schema.isRefDeclaredInline());
    }

    private void writeMap(MapDataSchema schema) throws IOException {
        this.write("map[string, ");
        this.writeReferenceOrInline(schema.getValues(), schema.isValuesDeclaredInline());
        this.write("]");
    }

    private void writeArray(ArrayDataSchema schema) throws IOException {
        this.write("array[");
        this.writeReferenceOrInline(schema.getItems(), schema.isItemsDeclaredInline());
        this.write("]");
    }

    private void writeUnion(UnionDataSchema schema) throws IOException {
        this.write("union[");
        Iterator<DataSchema> iter = schema.getTypes().iterator();
        while (iter.hasNext()) {
            DataSchema member = iter.next();
            this.writeReferenceOrInline(member, schema.isTypeDeclaredInline(member));
            if (!iter.hasNext()) continue;
            this.write(", ");
        }
        this.write("]");
    }

    private void writePrimitive(PrimitiveDataSchema schema) throws IOException {
        this.write(schema.getUnionMemberKey());
    }

    private DataMap coercePropertyToDataMapOrFail(NamedDataSchema schema, String name, Object value) {
        if (value == null) {
            return new DataMap();
        }
        if (!(value instanceof DataMap)) {
            throw new IllegalArgumentException("'" + name + "' in " + schema.getFullName() + " must be of type DataMap, but is: " + value.getClass());
        }
        return (DataMap)value;
    }

    private boolean writeDoc(String doc) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)doc)) {
            this.writeLine("/**");
            for (String line : doc.split("\n")) {
                this.indent();
                this.write(" * ");
                this.write(line);
                this.newline();
            }
            this.writeLine(" */");
            return true;
        }
        return false;
    }

    private String toJson(Object value) throws IOException {
        if (value instanceof DataMap) {
            return CODEC.mapToString((DataMap)value);
        }
        if (value instanceof DataList) {
            return CODEC.listToString((DataList)value);
        }
        if (value instanceof String) {
            return "\"" + StringEscapeUtils.escapeJava((String)((String)value)) + "\"";
        }
        if (value instanceof Number) {
            return String.valueOf(value);
        }
        if (value instanceof Boolean) {
            return String.valueOf(value);
        }
        if (value instanceof ByteString) {
            return ((ByteString)value).asAvroString();
        }
        throw new IllegalArgumentException("Unsupported data type: " + value.getClass());
    }

    private void writeReferenceOrInline(DataSchema dataSchema, boolean originallyInlined) throws IOException {
        AbstractSchemaEncoder.TypeRepresentation representation = this.selectTypeRepresentation(dataSchema, originallyInlined);
        this.markEncountered(dataSchema);
        if (representation == AbstractSchemaEncoder.TypeRepresentation.DECLARED_INLINE) {
            boolean requiresNewlineLayout = this.requiredNewlineLayout(dataSchema);
            if (requiresNewlineLayout) {
                this.newline();
                ++this._indentDepth;
            }
            this.writeInlineSchema(dataSchema);
            if (requiresNewlineLayout) {
                --this._indentDepth;
            }
        } else if (dataSchema instanceof NamedDataSchema) {
            this.write(this.toTypeIdentifier((NamedDataSchema)dataSchema));
        } else {
            throw new IllegalArgumentException("Unnamed not marked as inline: " + dataSchema);
        }
    }

    private boolean requiredNewlineLayout(DataSchema dataSchema) {
        NamedDataSchema named;
        return dataSchema instanceof NamedDataSchema && (StringUtils.isNotBlank((CharSequence)(named = (NamedDataSchema)dataSchema).getDoc()) || !named.getProperties().isEmpty());
    }

    private boolean writeProperties(Map<String, Object> properties) throws IOException {
        this.writeProperties(Collections.emptyList(), properties);
        return !properties.isEmpty();
    }

    private void writeProperties(List<String> prefix, Map<String, Object> properties) throws IOException {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            ArrayList<String> pathParts = new ArrayList<String>(prefix);
            pathParts.add(key);
            if (value instanceof DataMap) {
                this.writeProperties(pathParts, (DataMap)value);
                continue;
            }
            if (value instanceof DataList) {
                this.writeProperty(pathParts, CODEC.listToString((DataList)value));
                continue;
            }
            if (Boolean.TRUE.equals(value)) {
                this.indent();
                this.write("@");
                this.write(this.pathToString(pathParts));
                this.newline();
                continue;
            }
            this.writeProperty(pathParts, value);
        }
    }

    private void writeProperty(List<String> path, Object value) throws IOException {
        this.indent();
        this.write("@");
        this.write(this.pathToString(path));
        this.write(" = ");
        this.write(this.toJson(value));
        this.newline();
    }

    private String pathToString(List<String> path) {
        return path.stream().map(this::escapeIdentifier).collect(Collectors.joining("."));
    }

    private Map<String, Name> computeImports(DataSchema schema) throws IOException {
        HashMap<String, Name> imports = new HashMap<String, Name>();
        this.computeImports(schema, true, imports);
        return imports;
    }

    private void computeImports(DataSchema schema, boolean isDeclaredInline, Map<String, Name> importsAcc) throws IOException {
        if (!isDeclaredInline) {
            if (schema instanceof NamedDataSchema) {
                NamedDataSchema namedSchema = (NamedDataSchema)schema;
                Name name = new Name(namedSchema.getFullName());
                if (name.getNamespace().equals(this._namespace)) {
                    importsAcc.put(name.getName(), name);
                } else {
                    importsAcc.putIfAbsent(name.getName(), name);
                }
            }
        } else if (schema instanceof RecordDataSchema) {
            RecordDataSchema recordSchema = (RecordDataSchema)schema;
            for (RecordDataSchema.Field field : recordSchema.getFields()) {
                this.computeImports(field.getType(), field.isDeclaredInline(), importsAcc);
            }
            for (NamedDataSchema include : recordSchema.getInclude()) {
                this.computeImports(include, true, importsAcc);
            }
        } else if (schema instanceof TyperefDataSchema) {
            TyperefDataSchema typerefSchema = (TyperefDataSchema)schema;
            this.computeImports(typerefSchema.getRef(), typerefSchema.isRefDeclaredInline(), importsAcc);
        } else if (schema instanceof UnionDataSchema) {
            UnionDataSchema unionSchema = (UnionDataSchema)schema;
            for (DataSchema member : unionSchema.getTypes()) {
                this.computeImports(member, unionSchema.isTypeDeclaredInline(member), importsAcc);
            }
        } else if (schema instanceof MapDataSchema) {
            MapDataSchema mapSchema = (MapDataSchema)schema;
            this.computeImports(mapSchema.getValues(), mapSchema.isValuesDeclaredInline(), importsAcc);
        } else if (schema instanceof ArrayDataSchema) {
            ArrayDataSchema arraySchema = (ArrayDataSchema)schema;
            this.computeImports(arraySchema.getItems(), arraySchema.isItemsDeclaredInline(), importsAcc);
        }
    }

    private String toTypeIdentifier(NamedDataSchema schema) {
        if (schema.getNamespace().equals(this._namespace) || this._importsByLocalName.containsKey(schema.getName()) && this._importsByLocalName.get(schema.getName()).getNamespace().equals(schema.getNamespace())) {
            return this.escapeIdentifier(schema.getName());
        }
        return this.escapeIdentifier(schema.getFullName());
    }

    private String escapeIdentifier(String identifier) {
        return Arrays.stream(identifier.split("\\.")).map(part -> {
            if (KEYWORDS.contains(part)) {
                return '`' + part.trim() + '`';
            }
            return part.trim();
        }).collect(Collectors.joining("."));
    }

    private void writeLine(String code) throws IOException {
        this.indent();
        this.write(code);
        this.newline();
    }

    private void indent() throws IOException {
        for (int i = 0; i < this._indentDepth; ++i) {
            this._out.write("  ");
        }
    }

    private void write(String codeFragment) throws IOException {
        this._out.write(codeFragment);
    }

    private void newline() throws IOException {
        this._out.write(System.lineSeparator());
    }
}

