/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.patch.request;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.transform.Escaper;
import com.linkedin.data.transform.patch.request.PatchOpFactory;
import com.linkedin.data.transform.patch.request.PatchTree;
import java.util.Map;

public class PatchCreator {
    public static <T extends RecordTemplate> PatchTree diff(T original, T modified) {
        return PatchCreator.diff(original.data(), modified.data());
    }

    public static PatchTree diff(DataMap original, DataMap modified) {
        DataMap result = PatchCreator.diffMaps(original, modified);
        if (result == null) {
            return new PatchTree();
        }
        return new PatchTree(result);
    }

    private static DataMap diffMaps(DataMap original, DataMap modified) {
        DataMap result = null;
        for (String key : original.keySet()) {
            if (!modified.containsKey((Object)key)) {
                result = result == null ? new DataMap() : result;
                PatchOpFactory.REMOVE_FIELD_OP.store(result, key);
                continue;
            }
            Object oValue = original.get((Object)key);
            Object mValue = modified.get((Object)key);
            if (mValue.getClass() == DataMap.class && oValue.getClass() == DataMap.class) {
                DataMap subDiff = PatchCreator.diffMaps((DataMap)oValue, (DataMap)mValue);
                if (subDiff == null) continue;
                result = result == null ? new DataMap() : result;
                result.put((Object)Escaper.escapePathSegment(key), (Object)subDiff);
                continue;
            }
            if (oValue.equals(mValue)) continue;
            result = result == null ? new DataMap() : result;
            PatchOpFactory.setFieldOp(mValue).store(result, key);
        }
        for (Map.Entry entry : modified.entrySet()) {
            if (original.containsKey(entry.getKey())) continue;
            result = result == null ? new DataMap() : result;
            PatchOpFactory.setFieldOp(entry.getValue()).store(result, (String)entry.getKey());
        }
        return result;
    }
}

