/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.snapshot.gen;

import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.pegasus.generator.GeneratorResult;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.internal.server.model.ResourceModelEncoder;
import com.linkedin.restli.internal.server.model.RestLiApiBuilder;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.server.RestLiConfig;
import com.linkedin.restli.server.util.FileClassNameScanner;
import com.linkedin.restli.tools.compatibility.CompatibilityUtil;
import com.linkedin.restli.tools.idlgen.DocletDocsProvider;
import com.linkedin.restli.tools.idlgen.MultiLanguageDocsProvider;
import com.linkedin.restli.tools.snapshot.gen.SnapshotGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestLiSnapshotExporter {
    private static final Logger log = LoggerFactory.getLogger(RestLiSnapshotExporter.class);
    private DataSchemaResolver _schemaResolver;

    public void setResolverPath(String resolverPath) {
        this._schemaResolver = CompatibilityUtil.getDataSchemaResolver(resolverPath);
    }

    public GeneratorResult export(String apiName, String[] classpath, String[] sourcePaths, String[] resourcePackages, String[] resourceClasses, String outdir) throws IOException {
        return this.export(apiName, classpath, sourcePaths, resourcePackages, resourceClasses, outdir, Collections.emptyList());
    }

    public GeneratorResult export(String apiName, String[] classpath, String[] sourcePaths, String[] resourcePackages, String[] resourceClasses, String outdir, List<ResourceModelEncoder.DocsProvider> additionalDocProviders) throws IOException {
        Object docsProvider;
        RestLiConfig config = new RestLiConfig();
        if (resourcePackages != null) {
            config.addResourcePackageNames(resourcePackages);
        }
        HashMap classFileNames = new HashMap();
        for (String path : sourcePaths) {
            classFileNames.putAll(FileClassNameScanner.scan((String)path));
        }
        ArrayList<String> sourceFileNames = null;
        if (resourceClasses != null || resourcePackages == null) {
            if (resourceClasses != null) {
                config.addResourceClassNames(resourceClasses);
                sourceFileNames = new ArrayList<String>(resourceClasses.length);
                for (String resourceClass : resourceClasses) {
                    String resourceFileName = (String)classFileNames.get(resourceClass);
                    if (resourceFileName == null) {
                        log.warn("Unable to find source file for class " + resourceClass + " .  No Javadoc will be generated for it.");
                        continue;
                    }
                    sourceFileNames.add(resourceFileName);
                }
            } else {
                config.addResourceClassNames(classFileNames.keySet());
            }
        }
        log.info("Executing Rest.li annotation processor...");
        RestLiApiBuilder apiBuilder = new RestLiApiBuilder(config);
        Map rootResourceMap = apiBuilder.build();
        if (rootResourceMap.isEmpty()) {
            return new SnapshotResult();
        }
        DocletDocsProvider javadocProvider = new DocletDocsProvider(apiName, classpath, sourcePaths, resourcePackages);
        if (additionalDocProviders == null || additionalDocProviders.isEmpty()) {
            docsProvider = javadocProvider;
        } else {
            ArrayList<ResourceModelEncoder.DocsProvider> languageSpecificDocsProviders = new ArrayList<ResourceModelEncoder.DocsProvider>();
            languageSpecificDocsProviders.add(javadocProvider);
            languageSpecificDocsProviders.addAll(MultiLanguageDocsProvider.loadExternalProviders(additionalDocProviders));
            docsProvider = new MultiLanguageDocsProvider(languageSpecificDocsProviders);
        }
        log.info("Registering source files with doc providers...");
        docsProvider.registerSourceFiles(classFileNames.values());
        log.info("Exporting snapshot files...");
        GeneratorResult result = this.generateSnapshotFiles(apiName, outdir, rootResourceMap, (ResourceModelEncoder.DocsProvider)docsProvider);
        log.info("Done!");
        return result;
    }

    private GeneratorResult generateSnapshotFiles(String apiName, String outdir, Map<String, ResourceModel> rootResourceMap, ResourceModelEncoder.DocsProvider docsProvider) throws IOException {
        SnapshotResult result = new SnapshotResult();
        File outdirFile = new File(outdir);
        if (!outdirFile.exists() && !outdirFile.mkdirs()) {
            throw new RuntimeException("Output directory '" + outdir + "' could not be created!");
        }
        if (!outdirFile.isDirectory()) {
            throw new RuntimeException("Output directory '" + outdir + "' is not a directory");
        }
        if (!outdirFile.canRead() || !outdirFile.canWrite()) {
            throw new RuntimeException("Output directory '" + outdir + "' must be writeable");
        }
        ResourceModelEncoder encoder = new ResourceModelEncoder(docsProvider);
        ArrayList<ResourceSchema> rootResourceNodes = new ArrayList<ResourceSchema>();
        for (Map.Entry<String, ResourceModel> entry : rootResourceMap.entrySet()) {
            ResourceSchema rootResourceNode = encoder.buildResourceSchema(entry.getValue());
            rootResourceNodes.add(rootResourceNode);
        }
        for (ResourceSchema rootResourceNode : rootResourceNodes) {
            String fileName = rootResourceNode.getName();
            if (rootResourceNode.hasNamespace()) {
                String namespace = rootResourceNode.getNamespace();
                fileName = namespace + "." + fileName;
            }
            if (apiName != null && !apiName.isEmpty()) {
                fileName = apiName + "-" + fileName;
            }
            File writtenFile = this.writeSnapshotFile(outdirFile, fileName, rootResourceNode);
            result.addModifiedFile(writtenFile);
            result.addTargetFile(writtenFile);
        }
        return result;
    }

    private File writeSnapshotFile(File outdirFile, String fileName, ResourceSchema rootResourceNode) throws IOException {
        log.info("Writing file '" + fileName + '\'');
        SnapshotGenerator generator = new SnapshotGenerator(rootResourceNode, this._schemaResolver);
        return generator.writeFile(outdirFile, fileName);
    }

    private static class SnapshotResult
    implements GeneratorResult {
        private List<File> targetFiles = new ArrayList<File>();
        private List<File> modifiedFiles = new ArrayList<File>();

        private SnapshotResult() {
        }

        public void addTargetFile(File file) {
            this.targetFiles.add(file);
        }

        public void addModifiedFile(File file) {
            this.modifiedFiles.add(file);
        }

        public Collection<File> getSourceFiles() {
            throw new UnsupportedOperationException("getSourceFiles is not supported for the RestliSnapshotModelExporter");
        }

        public Collection<File> getTargetFiles() {
            return this.targetFiles;
        }

        public Collection<File> getModifiedFiles() {
            return this.modifiedFiles;
        }
    }
}

