/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.data;

import com.linkedin.data.it.Predicate;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.JsonBuilder;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PegasusSchemaParser;
import com.linkedin.data.schema.SchemaParser;
import com.linkedin.data.schema.SchemaToJsonEncoder;
import com.linkedin.data.schema.util.Filters;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.restli.common.RestConstants;
import com.linkedin.restli.tools.data.PredicateExpressionParser;
import com.linkedin.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterSchemaGenerator {
    private static final Logger _log = LoggerFactory.getLogger(FilterSchemaGenerator.class);
    private static final Options _options = new Options();

    private FilterSchemaGenerator() {
    }

    public static void main(String[] args) {
        File sourceDirectory;
        CommandLine cl = null;
        try {
            GnuParser parser = new GnuParser();
            cl = parser.parse(_options, args);
        }
        catch (ParseException e) {
            _log.error("Invalid arguments: " + e.getMessage());
            FilterSchemaGenerator.reportInvalidArguments();
        }
        String[] directoryArgs = cl.getArgs();
        if (directoryArgs.length != 2) {
            FilterSchemaGenerator.reportInvalidArguments();
        }
        if (!(sourceDirectory = new File(directoryArgs[0])).exists()) {
            _log.error(sourceDirectory.getPath() + " does not exist");
            System.exit(1);
        }
        if (!sourceDirectory.isDirectory()) {
            _log.error(sourceDirectory.getPath() + " is not a directory");
            System.exit(1);
        }
        URI sourceDirectoryURI = sourceDirectory.toURI();
        File outputDirectory = new File(directoryArgs[1]);
        if (outputDirectory.exists() && !sourceDirectory.isDirectory()) {
            _log.error(outputDirectory.getPath() + " is not a directory");
            System.exit(1);
        }
        boolean isAvroMode = cl.hasOption('a');
        String predicateExpression = cl.getOptionValue('e');
        Predicate predicate = PredicateExpressionParser.parse(predicateExpression);
        List sourceFiles = FileUtil.listFiles((File)sourceDirectory, null);
        int exitCode = 0;
        for (File sourceFile : sourceFiles) {
            try {
                ValidationOptions val = new ValidationOptions();
                val.setAvroUnionMode(isAvroMode);
                SchemaParser schemaParser = new SchemaParser();
                schemaParser.setValidationOptions(val);
                schemaParser.parse((InputStream)new FileInputStream(sourceFile));
                if (schemaParser.hasError()) {
                    _log.error("Error parsing " + sourceFile.getPath() + ": " + schemaParser.errorMessageBuilder());
                    exitCode = 1;
                    continue;
                }
                DataSchema originalSchema = (DataSchema)schemaParser.topLevelDataSchemas().get(0);
                if (!(originalSchema instanceof NamedDataSchema)) {
                    _log.error(sourceFile.getPath() + " does not contain valid NamedDataSchema");
                    exitCode = 1;
                    continue;
                }
                SchemaParser filterParser = new SchemaParser();
                filterParser.setValidationOptions(val);
                NamedDataSchema filteredSchema = Filters.removeByPredicate((NamedDataSchema)((NamedDataSchema)originalSchema), (Predicate)predicate, (PegasusSchemaParser)filterParser);
                if (filterParser.hasError()) {
                    _log.error("Error applying predicate: " + filterParser.errorMessageBuilder());
                    exitCode = 1;
                    continue;
                }
                String relativePath = sourceDirectoryURI.relativize(sourceFile.toURI()).getPath();
                String outputFilePath = outputDirectory.getPath() + File.separator + relativePath;
                File outputFile = new File(outputFilePath);
                File outputFileParent = outputFile.getParentFile();
                outputFileParent.mkdirs();
                if (!outputFileParent.exists()) {
                    _log.error("Unable to write filtered schema to " + outputFileParent.getPath());
                    exitCode = 1;
                    continue;
                }
                FileOutputStream fout = new FileOutputStream(outputFile);
                String schemaJson = SchemaToJsonEncoder.schemaToJson((DataSchema)filteredSchema, (JsonBuilder.Pretty)JsonBuilder.Pretty.INDENTED);
                fout.write(schemaJson.getBytes(RestConstants.DEFAULT_CHARSET));
                fout.close();
            }
            catch (IOException e) {
                _log.error(e.getMessage());
                exitCode = 1;
            }
        }
        System.exit(exitCode);
    }

    private static void reportInvalidArguments() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(FilterSchemaGenerator.class.getName() + " sourceDirectoryPath outputDirectoryPath", _options, true);
        System.exit(1);
    }

    static {
        OptionBuilder.withLongOpt((String)"avro");
        OptionBuilder.withDescription((String)"Specify this option if processing Avro schemas");
        _options.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withLongOpt((String)"expr");
        OptionBuilder.withArgName((String)"expression");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"Expression of filter predicate combinations, which are expressed in fully qualified class names");
        _options.addOption(OptionBuilder.create((String)"e"));
    }
}

