/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.compatibility;

import com.linkedin.restli.tools.compatibility.CompatibilityInfoMap;
import com.linkedin.restli.tools.idlcheck.CompatibilityInfo;
import com.linkedin.restli.tools.idlcheck.CompatibilityLevel;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CompatibilityReport {
    private final CompatibilityInfoMap _infoMap;
    private final CompatibilityLevel _compatibilityLevel;

    public CompatibilityReport(CompatibilityInfoMap infoMap, CompatibilityLevel compatibilityLevel) {
        this._infoMap = infoMap;
        this._compatibilityLevel = compatibilityLevel;
    }

    public String createReport() {
        String restSpecCompat = this._infoMap.getRestSpecInfo(CompatibilityInfo.Level.COMPATIBLE).stream().map(it -> "[RS-C]:" + it).collect(Collectors.joining("\n"));
        String restSpecIncompat = this._infoMap.getRestSpecInfo(CompatibilityInfo.Level.INCOMPATIBLE).stream().map(it -> "[RS-I]:" + it).collect(Collectors.joining("\n"));
        String modelCompat = this._infoMap.getModelInfo(CompatibilityInfo.Level.COMPATIBLE).stream().map(it -> "[MD-C]:" + it).collect(Collectors.joining("\n"));
        String modelIncompat = this._infoMap.getModelInfo(CompatibilityInfo.Level.INCOMPATIBLE).stream().map(it -> "[MD-I]:" + it).collect(Collectors.joining("\n"));
        String restSpecIsCompat = String.format("[RS-COMPAT]: %b", this._infoMap.isRestSpecCompatible(this._compatibilityLevel));
        String modelIsCompat = String.format("[MD-COMPAT]: %b", this._infoMap.isModelCompatible(this._compatibilityLevel));
        return Arrays.asList(restSpecIsCompat, modelIsCompat, restSpecCompat, restSpecIncompat, modelCompat, modelIncompat).stream().filter(it -> !it.isEmpty()).collect(Collectors.joining("\n")) + '\n';
    }
}

