/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.promise;

import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromiseException;
import com.linkedin.parseq.promise.PromiseListener;
import com.linkedin.parseq.promise.PromiseUnresolvedException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvedValue<T>
implements Promise<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolvedValue.class);
    private final T _value;

    public ResolvedValue(T value) {
        this._value = value;
    }

    @Override
    public T get() throws PromiseException {
        return this._value;
    }

    @Override
    public Throwable getError() throws PromiseUnresolvedException {
        return null;
    }

    @Override
    public T getOrDefault(T defaultValue) throws PromiseUnresolvedException {
        return this._value;
    }

    @Override
    public void await() throws InterruptedException {
    }

    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    public void addListener(PromiseListener<T> listener) {
        try {
            listener.onResolved(this);
        }
        catch (Throwable e) {
            LOGGER.warn("An exception was thrown by listener: " + listener.getClass(), e);
        }
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public boolean isFailed() {
        return false;
    }
}

