/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.Exceptions;
import com.linkedin.parseq.FusionTraceContext;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.function.Consumer3;
import com.linkedin.parseq.function.Function1;
import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.internal.Continuations;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromisePropagator;
import com.linkedin.parseq.promise.PromiseResolvedException;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.parseq.promise.Settable;
import com.linkedin.parseq.promise.SettablePromise;
import com.linkedin.parseq.trace.Relationship;
import com.linkedin.parseq.trace.ResultType;
import com.linkedin.parseq.trace.ShallowTraceBuilder;
import com.linkedin.parseq.trace.TraceBuilder;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FusionTask<S, T>
extends BaseTask<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionTask.class);
    private static final Continuations CONTINUATIONS = new Continuations();
    private final Consumer3<FusionTraceContext, Promise<S>, Settable<T>> _propagator;
    private final Task<S> _asyncTask;
    private final ShallowTraceBuilder _predecessorShallowTraceBuilder;

    private FusionTask(String desc, Task<S> task, PromisePropagator<S, T> propagator) {
        super(desc);
        this._propagator = this.completing(FusionTask.adaptToAcceptTraceContext(propagator));
        this._asyncTask = task;
        this._predecessorShallowTraceBuilder = null;
    }

    private <R> FusionTask(String desc, FusionTask<S, R> predecessor, PromisePropagator<R, T> propagator) {
        super(desc);
        this._asyncTask = predecessor._asyncTask;
        this._predecessorShallowTraceBuilder = predecessor.getShallowTraceBuilder();
        this._propagator = this.completing(this.compose(predecessor._propagator, FusionTask.adaptToAcceptTraceContext(propagator)));
    }

    private static <A, B> Consumer3<FusionTraceContext, Promise<A>, Settable<B>> adaptToAcceptTraceContext(PromisePropagator<A, B> propagator) {
        return (traceContext, src, dest) -> propagator.accept(src, dest);
    }

    private void trnasitionToDone(FusionTraceContext traceContext) {
        this.addRelationships(traceContext);
        this.transitionPending();
        this.transitionDone();
    }

    private boolean isPropagationInitiator(FusionTraceContext traceContext) {
        return traceContext.getPropagationInitiator().getId().equals(this.getId());
    }

    private ShallowTraceBuilder getEffectiveShallowTraceBuilder(FusionTraceContext traceContext) {
        if (this.isPropagationInitiator(traceContext)) {
            return traceContext.getSurrogate();
        }
        return this._shallowTraceBuilder;
    }

    private void addRelationships(FusionTraceContext traceContext) {
        ShallowTraceBuilder effectoveShallowTraceBuilder = this.getEffectiveShallowTraceBuilder(traceContext);
        TraceBuilder builder = this.getTraceBuilder();
        builder.addRelationship(Relationship.PARENT_OF, traceContext.getParent().getShallowTraceBuilder(), effectoveShallowTraceBuilder);
        if (this._predecessorShallowTraceBuilder != null) {
            builder.addRelationship(Relationship.SUCCESSOR_OF, effectoveShallowTraceBuilder, this._predecessorShallowTraceBuilder);
        }
    }

    private void addPotentialRelationships(FusionTraceContext traceContext, TraceBuilder builder) {
        ShallowTraceBuilder effectoveShallowTraceBuilder = this.getEffectiveShallowTraceBuilder(traceContext);
        builder.addRelationship(Relationship.POTENTIAL_CHILD_OF, effectoveShallowTraceBuilder, traceContext.getParent().getShallowTraceBuilder());
        if (this._predecessorShallowTraceBuilder != null) {
            builder.addRelationship(Relationship.POSSIBLE_SUCCESSOR_OF, effectoveShallowTraceBuilder, this._predecessorShallowTraceBuilder);
        }
    }

    private <R> Consumer3<FusionTraceContext, Promise<S>, Settable<T>> compose(Consumer3<FusionTraceContext, Promise<S>, Settable<R>> predecessor, Consumer3<FusionTraceContext, Promise<R>, Settable<T>> propagator) {
        return (traceContext, src, dst) -> {
            traceContext.createSurrogate();
            predecessor.accept((FusionTraceContext)traceContext, (Promise<S>)src, new Settable<R>((FusionTraceContext)traceContext, propagator, (Settable)dst){
                final /* synthetic */ FusionTraceContext val$traceContext;
                final /* synthetic */ Consumer3 val$propagator;
                final /* synthetic */ Settable val$dst;
                {
                    this.val$traceContext = fusionTraceContext;
                    this.val$propagator = consumer3;
                    this.val$dst = settable;
                }

                @Override
                public void done(R value) throws PromiseResolvedException {
                    try {
                        FusionTask.this.getEffectiveShallowTraceBuilder(this.val$traceContext).setStartNanos(System.nanoTime());
                        this.val$propagator.accept(this.val$traceContext, Promises.value(value), this.val$dst);
                    }
                    catch (Exception e) {
                        LOGGER.error("ParSeq ingternal error. An exception was thrown by propagator", (Throwable)e);
                    }
                }

                @Override
                public void fail(Throwable error) throws PromiseResolvedException {
                    try {
                        FusionTask.this.getEffectiveShallowTraceBuilder(this.val$traceContext).setStartNanos(System.nanoTime());
                        this.val$propagator.accept(this.val$traceContext, Promises.error(error), this.val$dst);
                    }
                    catch (Exception e) {
                        LOGGER.error("ParSeq ingternal error. An exception was thrown by propagator.", (Throwable)e);
                    }
                }
            });
        };
    }

    private Consumer3<FusionTraceContext, Promise<S>, Settable<T>> completing(Consumer3<FusionTraceContext, Promise<S>, Settable<T>> propagator) {
        return (traceContext, src, dest) -> {
            SettablePromise settable = this.getSettableDelegate();
            if (this.isPropagationInitiator((FusionTraceContext)traceContext)) {
                propagator.accept((FusionTraceContext)traceContext, (Promise<S>)src, new Settable<T>((FusionTraceContext)traceContext, (Settable)dest){
                    final /* synthetic */ FusionTraceContext val$traceContext;
                    final /* synthetic */ Settable val$dest;
                    {
                        this.val$traceContext = fusionTraceContext;
                        this.val$dest = settable;
                    }

                    @Override
                    public void done(T value) throws PromiseResolvedException {
                        ShallowTraceBuilder shallowTraceBuilder = this.val$traceContext.getSurrogate();
                        if (shallowTraceBuilder != null) {
                            FusionTask.this.addRelationships(this.val$traceContext);
                            long endNanos = System.nanoTime();
                            shallowTraceBuilder.setPendingNanos(endNanos);
                            shallowTraceBuilder.setEndNanos(endNanos);
                            Function traceValueProvider = FusionTask.this._traceValueProvider;
                            shallowTraceBuilder.setResultType(ResultType.SUCCESS);
                            if (traceValueProvider != null) {
                                try {
                                    shallowTraceBuilder.setValue((String)traceValueProvider.apply(value));
                                }
                                catch (Exception e) {
                                    shallowTraceBuilder.setValue(Exceptions.failureToString(e));
                                }
                            }
                        }
                        this.val$dest.done(value);
                    }

                    @Override
                    public void fail(Throwable error) throws PromiseResolvedException {
                        ShallowTraceBuilder shallowTraceBuilder = this.val$traceContext.getSurrogate();
                        if (shallowTraceBuilder != null) {
                            FusionTask.this.addRelationships(this.val$traceContext);
                            long endNanos = System.nanoTime();
                            shallowTraceBuilder.setPendingNanos(endNanos);
                            shallowTraceBuilder.setEndNanos(endNanos);
                            if (Exceptions.isEarlyFinish(error)) {
                                shallowTraceBuilder.setResultType(ResultType.EARLY_FINISH);
                            } else {
                                shallowTraceBuilder.setResultType(ResultType.ERROR);
                                shallowTraceBuilder.setValue(Exceptions.failureToString(error));
                            }
                        }
                        this.val$dest.fail(error);
                    }
                });
            } else if (this.transitionRun(traceContext.getParent().getTraceBuilder())) {
                this.markTaskStarted();
                traceContext.getParent().getTaskLogger().logTaskStart(this);
                CONTINUATIONS.submit(() -> {
                    try {
                        propagator.accept((FusionTraceContext)traceContext, (Promise<S>)src, new Settable<T>((FusionTraceContext)traceContext, settable, (Settable)dest){
                            final /* synthetic */ FusionTraceContext val$traceContext;
                            final /* synthetic */ SettablePromise val$settable;
                            final /* synthetic */ Settable val$dest;
                            {
                                this.val$traceContext = fusionTraceContext;
                                this.val$settable = settablePromise;
                                this.val$dest = settable;
                            }

                            @Override
                            public void done(T value) throws PromiseResolvedException {
                                try {
                                    FusionTask.this.trnasitionToDone(this.val$traceContext);
                                    Function traceValueProvider = FusionTask.this._traceValueProvider;
                                    FusionTask.this._shallowTraceBuilder.setResultType(ResultType.SUCCESS);
                                    if (traceValueProvider != null) {
                                        try {
                                            FusionTask.this._shallowTraceBuilder.setValue((String)traceValueProvider.apply(value));
                                        }
                                        catch (Exception e) {
                                            FusionTask.this._shallowTraceBuilder.setValue(Exceptions.failureToString(e));
                                        }
                                    }
                                    this.val$settable.done(value);
                                    this.val$traceContext.getParent().getTaskLogger().logTaskEnd(FusionTask.this, FusionTask.this._traceValueProvider);
                                    CONTINUATIONS.submit(() -> this.val$dest.done(value));
                                }
                                catch (Exception e) {
                                    CONTINUATIONS.submit(() -> this.val$dest.fail(e));
                                }
                            }

                            @Override
                            public void fail(Throwable error) throws PromiseResolvedException {
                                try {
                                    FusionTask.this.trnasitionToDone(this.val$traceContext);
                                    FusionTask.this.traceFailure(error);
                                    this.val$settable.fail(error);
                                    this.val$traceContext.getParent().getTaskLogger().logTaskEnd(FusionTask.this, FusionTask.this._traceValueProvider);
                                    CONTINUATIONS.submit(() -> this.val$dest.fail(error));
                                }
                                catch (Exception e) {
                                    CONTINUATIONS.submit(() -> this.val$dest.fail(e));
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.error("ParSeq ingternal error. An exception was thrown by propagator.", (Throwable)e);
                    }
                });
            } else {
                this.addPotentialRelationships((FusionTraceContext)traceContext, traceContext.getParent().getTraceBuilder());
                Promises.propagateResult(settable, dest);
            }
        };
    }

    public static <S, T> FusionTask<?, T> create(String name, PromisePropagator<S, T> propagator) {
        return new FusionTask<S, T>(name, (Task)null, propagator);
    }

    public static <S, T> FusionTask<?, T> create(String name, Task<S> task, PromisePropagator<S, T> propagator) {
        return new FusionTask<S, T>(name, task, propagator);
    }

    @Override
    public <R> Task<R> apply(String desc, PromisePropagator<T, R> propagator) {
        return new FusionTask<S, R>(desc, this, propagator);
    }

    @Override
    public Task<T> recoverWith(String desc, Function1<Throwable, Task<T>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        FusionTask that = this;
        return Task.async(desc, (Context context) -> {
            SettablePromise result = Promises.settable();
            context.after(that).run(() -> {
                if (that.isFailed()) {
                    if (!Exceptions.isCancellation(that.getError())) {
                        try {
                            Task r = (Task)func.apply(that.getError());
                            Promises.propagateResult(r, result);
                            return r;
                        }
                        catch (Throwable t) {
                            result.fail(t);
                            return null;
                        }
                    }
                    result.fail(that.getError());
                    return null;
                }
                result.done(that.get());
                return null;
            });
            context.run(that);
            return result;
        });
    }

    private void propagate(FusionTraceContext traceContext, SettablePromise<T> result) {
        try {
            this._propagator.accept(traceContext, this._asyncTask, result);
        }
        catch (Throwable t) {
            result.fail(t);
        }
    }

    @Override
    protected Promise<? extends T> run(Context context) throws Throwable {
        SettablePromise result = Promises.settable();
        String baseName = this.getName();
        if (this._asyncTask == null) {
            FusionTraceContext traceContext = new FusionTraceContext(context, this.getShallowTraceBuilder(), baseName);
            this.propagate(traceContext, result);
        } else {
            Task propagationTask = Task.async(baseName, (Context ctx) -> {
                SettablePromise fusionResult = Promises.settable();
                FusionTraceContext traceContext = new FusionTraceContext((Context)ctx, this.getShallowTraceBuilder(), baseName);
                this.propagate(traceContext, fusionResult);
                return fusionResult;
            });
            propagationTask.getShallowTraceBuilder().setHidden(this._shallowTraceBuilder.getHidden());
            propagationTask.getShallowTraceBuilder().setSystemHidden(this._shallowTraceBuilder.getSystemHidden());
            this._shallowTraceBuilder.setName("async fused");
            this._shallowTraceBuilder.setSystemHidden(true);
            context.after(this._asyncTask).run(propagationTask);
            context.run(this._asyncTask);
            Promises.propagateResult(propagationTask, result);
        }
        return result;
    }
}

