/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public enum WorkUnitRetryPolicy {
    ALWAYS("always"),
    ON_COMMIT_ON_PARTIAL_SUCCESS("onpartial"),
    ON_COMMIT_ON_FULL_SUCCESS("onfull"),
    NEVER("never");

    private final String name;

    private WorkUnitRetryPolicy(String name) {
        this.name = name;
    }

    public static WorkUnitRetryPolicy forName(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        if (WorkUnitRetryPolicy.ALWAYS.name.equalsIgnoreCase(name)) {
            return ALWAYS;
        }
        if (WorkUnitRetryPolicy.ON_COMMIT_ON_PARTIAL_SUCCESS.name.equalsIgnoreCase(name)) {
            return ON_COMMIT_ON_PARTIAL_SUCCESS;
        }
        if (WorkUnitRetryPolicy.ON_COMMIT_ON_FULL_SUCCESS.name.equalsIgnoreCase(name)) {
            return ON_COMMIT_ON_FULL_SUCCESS;
        }
        if (WorkUnitRetryPolicy.NEVER.name.equalsIgnoreCase(name)) {
            return NEVER;
        }
        throw new IllegalArgumentException(String.format("Work unit retry policy with name %s is not supported", name));
    }
}

