/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.filter;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.AvroToAvroConverterBase;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.converter.filter.AvroSchemaFieldRemover;
import org.apache.gobblin.util.AvroUtils;

public class AvroProjectionConverter
extends AvroToAvroConverterBase {
    public static final String REMOVE_FIELDS = ".remove.fields";
    private Optional<AvroSchemaFieldRemover> fieldRemover;

    public AvroProjectionConverter init(WorkUnitState workUnit) {
        if (workUnit.contains("extract.table.name")) {
            String removeFieldsPropName = workUnit.getProp("extract.table.name") + REMOVE_FIELDS;
            this.fieldRemover = workUnit.contains(removeFieldsPropName) ? Optional.of((Object)new AvroSchemaFieldRemover(workUnit.getProp(removeFieldsPropName))) : Optional.absent();
        }
        return this;
    }

    @Override
    public Schema convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        if (this.fieldRemover.isPresent()) {
            return ((AvroSchemaFieldRemover)this.fieldRemover.get()).removeFields(inputSchema);
        }
        return inputSchema;
    }

    @Override
    public Iterable<GenericRecord> convertRecord(Schema outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            return new SingleRecordIterable<GenericRecord>(AvroUtils.convertRecordSchema((GenericRecord)inputRecord, (Schema)outputSchema));
        }
        catch (IOException e) {
            throw new DataConversionException((Throwable)e);
        }
    }
}

