/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.conditions;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.compaction.conditions.RecompactionCondition;
import org.apache.gobblin.compaction.conditions.RecompactionConditionFactory;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.compaction.dataset.DatasetHelper;
import org.apache.gobblin.util.DatasetFilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="RecompactionConditionBasedOnRatio")
public class RecompactionConditionBasedOnRatio
implements RecompactionCondition {
    public static final char DATASETS_WITH_DIFFERENT_RECOMPACT_THRESHOLDS_SEPARATOR = ';';
    public static final char DATASETS_WITH_SAME_RECOMPACT_THRESHOLDS_SEPARATOR = ',';
    public static final char DATASETS_AND_RECOMPACT_THRESHOLD_SEPARATOR = ':';
    private static final Logger logger = LoggerFactory.getLogger(RecompactionConditionBasedOnRatio.class);
    private final double ratio;

    private RecompactionConditionBasedOnRatio(Dataset dataset) {
        Map<String, Double> datasetRegexAndRecompactThreshold = RecompactionConditionBasedOnRatio.getDatasetRegexAndRecompactThreshold(dataset.jobProps().getProp("compaction.latedata.threshold.for.recompact.per.topic", ""));
        this.ratio = this.getOwnRatioThreshold(dataset, datasetRegexAndRecompactThreshold);
    }

    public static Map<String, Double> getDatasetRegexAndRecompactThreshold(String datasetsAndRecompactThresholds) {
        HashMap topicRegexAndRecompactThreshold = Maps.newHashMap();
        for (String entry : Splitter.on((char)';').trimResults().omitEmptyStrings().splitToList((CharSequence)datasetsAndRecompactThresholds)) {
            List topicsAndRecompactThreshold = Splitter.on((char)':').trimResults().omitEmptyStrings().splitToList((CharSequence)entry);
            if (topicsAndRecompactThreshold.size() != 2) {
                logger.error("Invalid form (DATASET_NAME:THRESHOLD) in compaction.latedata.threshold.for.recompact.per.topic.");
                continue;
            }
            topicRegexAndRecompactThreshold.put(topicsAndRecompactThreshold.get(0), Double.parseDouble((String)topicsAndRecompactThreshold.get(1)));
        }
        return topicRegexAndRecompactThreshold;
    }

    private double getOwnRatioThreshold(Dataset dataset, Map<String, Double> datasetRegexAndRecompactThreshold) {
        return RecompactionConditionBasedOnRatio.getRatioThresholdByDatasetName(dataset.getDatasetName(), datasetRegexAndRecompactThreshold);
    }

    public static double getRatioThresholdByDatasetName(String datasetName, Map<String, Double> datasetRegexAndRecompactThreshold) {
        for (Map.Entry<String, Double> topicRegexEntry : datasetRegexAndRecompactThreshold.entrySet()) {
            if (!DatasetFilterUtils.stringInPatterns((String)datasetName, (List)DatasetFilterUtils.getPatternsFromStrings((List)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)topicRegexEntry.getKey())))) continue;
            return topicRegexEntry.getValue();
        }
        return 1.0;
    }

    @Override
    public boolean isRecompactionNeeded(DatasetHelper datasetHelper) {
        long lateDataCount = datasetHelper.getLateOutputRecordCount();
        long nonLateDataCount = datasetHelper.getOutputRecordCount();
        double lateDataPercent = (double)lateDataCount * 1.0 / (double)(lateDataCount + nonLateDataCount);
        logger.info("Late data ratio is " + lateDataPercent + " and threshold is " + this.ratio);
        return lateDataPercent > this.ratio;
    }

    @Alias(value="RecompactBasedOnRatio")
    public static class Factory
    implements RecompactionConditionFactory {
        @Override
        public RecompactionCondition createRecompactionCondition(Dataset dataset) {
            return new RecompactionConditionBasedOnRatio(dataset);
        }
    }
}

