/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.helix.task.beans.TaskBean;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class TaskConfig {
    private static final Logger LOG = Logger.getLogger(TaskConfig.class);
    private final Map<String, String> _configMap;

    @Deprecated
    public TaskConfig(String command, Map<String, String> configMap, boolean successOptional, String id, String target) {
        this(command, configMap, id, target);
    }

    @Deprecated
    public TaskConfig(String command, Map<String, String> configMap, boolean successOptional) {
        this(command, configMap, null, null);
    }

    public TaskConfig(String command, Map<String, String> configMap, String id, String target) {
        if (configMap == null) {
            configMap = Maps.newHashMap();
        }
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        if (command != null) {
            configMap.put(TaskConfigProperty.TASK_COMMAND.name(), command);
        }
        configMap.put(TaskConfigProperty.TASK_ID.name(), id);
        if (target != null) {
            configMap.put(TaskConfigProperty.TASK_TARGET_PARTITION.name(), target);
        }
        this._configMap = configMap;
    }

    public TaskConfig(String command, Map<String, String> configMap) {
        this(command, configMap, null, null);
    }

    public String getId() {
        return this._configMap.get(TaskConfigProperty.TASK_ID.name());
    }

    public String getCommand() {
        return this._configMap.get(TaskConfigProperty.TASK_COMMAND.name());
    }

    public String getTargetPartition() {
        return this._configMap.get(TaskConfigProperty.TASK_TARGET_PARTITION.name());
    }

    @Deprecated
    public boolean isSuccessOptional() {
        return true;
    }

    public Map<String, String> getConfigMap() {
        return this._configMap;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            LOG.error((Object)"Could not serialize TaskConfig", (Throwable)e);
            return super.toString();
        }
    }

    public static class Builder {
        private String _taskId;
        private String _command;
        private String _targetPartition;
        private boolean _successOptional = false;
        private Map<String, String> _configMap;

        public TaskConfig build() {
            return new TaskConfig(this._command, this._configMap, this._taskId, this._targetPartition);
        }

        public String getTaskId() {
            return this._taskId;
        }

        public Builder setTaskId(String taskId) {
            this._taskId = taskId;
            return this;
        }

        public String getCommand() {
            return this._command;
        }

        public Builder setCommand(String command) {
            this._command = command;
            return this;
        }

        public String getTargetPartition() {
            return this._targetPartition;
        }

        public Builder setTargetPartition(String targetPartition) {
            this._targetPartition = targetPartition;
            return this;
        }

        @Deprecated
        public boolean isSuccessOptional() {
            return this._successOptional;
        }

        @Deprecated
        public Builder setSuccessOptional(boolean successOptional) {
            this._successOptional = successOptional;
            return this;
        }

        public Builder addConfig(String key, String value) {
            if (this._configMap == null) {
                this._configMap = Maps.newHashMap();
            }
            this._configMap.put(key, value);
            return this;
        }

        public static TaskConfig from(String target) {
            return new TaskConfig(null, null, null, target);
        }

        public static TaskConfig from(TaskBean bean) {
            return new TaskConfig(bean.command, bean.taskConfigMap);
        }

        @Deprecated
        public static TaskConfig from(Map<String, String> rawConfigMap) {
            String taskId = rawConfigMap.get(TaskConfigProperty.TASK_ID.name());
            String command = rawConfigMap.get(TaskConfigProperty.TASK_COMMAND.name());
            String targetPartition = rawConfigMap.get(TaskConfigProperty.TASK_TARGET_PARTITION.name());
            return new TaskConfig(command, rawConfigMap, taskId, targetPartition);
        }
    }

    private static enum TaskConfigProperty {
        TASK_ID,
        TASK_COMMAND,
        TASK_SUCCESS_OPTIONAL,
        TASK_TARGET_PARTITION;

    }
}

