/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.Collections;
import java.util.Map;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.helix.api.config.RebalanceConfig;
import org.apache.helix.api.config.StateTransitionTimeoutConfig;
import org.apache.log4j.Logger;

public class ResourceConfig
extends HelixProperty {
    private static final Logger _logger = Logger.getLogger((String)ResourceConfig.class.getName());

    public ResourceConfig(String resourceId) {
        super(resourceId);
    }

    public ResourceConfig(ZNRecord record) {
        super(record);
    }

    public ResourceConfig(ZNRecord record, String id) {
        super(record, id);
    }

    public ResourceConfig(String resourceId, Boolean monitorDisabled, int numPartitions, String stateModelDefRef, String stateModelFactoryName, String numReplica, int minActiveReplica, int maxPartitionsPerInstance, String instanceGroupTag, Boolean helixEnabled, String resourceGroupName, String resourceType, Boolean groupRoutingEnabled, Boolean externalViewDisabled, RebalanceConfig rebalanceConfig) {
        super(resourceId);
        if (monitorDisabled != null) {
            this._record.setBooleanField(ResourceConfigProperty.MONITORING_DISABLED.name(), monitorDisabled);
        }
        this._record.setIntField(ResourceConfigProperty.NUM_PARTITIONS.name(), numPartitions);
        this._record.setSimpleField(ResourceConfigProperty.STATE_MODEL_DEF_REF.name(), stateModelDefRef);
        if (stateModelFactoryName != null) {
            this._record.setSimpleField(ResourceConfigProperty.STATE_MODEL_FACTORY_NAME.name(), stateModelFactoryName);
        }
        this._record.setSimpleField(ResourceConfigProperty.REPLICAS.name(), numReplica);
        if (minActiveReplica >= 0) {
            this._record.setIntField(ResourceConfigProperty.MIN_ACTIVE_REPLICAS.name(), minActiveReplica);
        }
        if (maxPartitionsPerInstance >= 0) {
            this._record.setIntField(ResourceConfigProperty.MAX_PARTITIONS_PER_INSTANCE.name(), maxPartitionsPerInstance);
        }
        if (instanceGroupTag != null) {
            this._record.setSimpleField(ResourceConfigProperty.INSTANCE_GROUP_TAG.name(), instanceGroupTag);
        }
        if (helixEnabled != null) {
            this._record.setBooleanField(ResourceConfigProperty.HELIX_ENABLED.name(), helixEnabled);
        }
        if (resourceGroupName != null) {
            this._record.setSimpleField(ResourceConfigProperty.RESOURCE_GROUP_NAME.name(), resourceGroupName);
        }
        if (resourceType != null) {
            this._record.setSimpleField(ResourceConfigProperty.RESOURCE_TYPE.name(), resourceType);
        }
        if (groupRoutingEnabled != null) {
            this._record.setBooleanField(ResourceConfigProperty.GROUP_ROUTING_ENABLED.name(), groupRoutingEnabled);
        }
        if (externalViewDisabled != null) {
            this._record.setBooleanField(ResourceConfigProperty.EXTERNAL_VIEW_DISABLED.name(), externalViewDisabled);
        }
        if (rebalanceConfig != null) {
            this.putSimpleConfigs(rebalanceConfig.getConfigsMap());
        }
    }

    public Boolean isMonitoringDisabled() {
        return this._record.getBooleanField(ResourceConfigProperty.MONITORING_DISABLED.toString(), false);
    }

    public String getResourceName() {
        return this._record.getId();
    }

    public int getNumPartitions() {
        return this._record.getIntField(ResourceConfigProperty.NUM_PARTITIONS.name(), 0);
    }

    public String getStateModelDefRef() {
        return this._record.getSimpleField(ResourceConfigProperty.STATE_MODEL_DEF_REF.name());
    }

    public String getStateModelFactoryName() {
        return this._record.getSimpleField(ResourceConfigProperty.STATE_MODEL_FACTORY_NAME.name());
    }

    public String getNumReplica() {
        return this._record.getSimpleField(ResourceConfigProperty.REPLICAS.name());
    }

    public int getMinActiveReplica() {
        return this._record.getIntField(ResourceConfigProperty.MIN_ACTIVE_REPLICAS.name(), -1);
    }

    public int getMaxPartitionsPerInstance() {
        return this._record.getIntField(ResourceConfigProperty.MAX_PARTITIONS_PER_INSTANCE.toString(), Integer.MAX_VALUE);
    }

    public String getInstanceGroupTag() {
        return this._record.getSimpleField(ResourceConfigProperty.INSTANCE_GROUP_TAG.toString());
    }

    public Boolean isEnabled() {
        return this._record.getBooleanField(ResourceConfigProperty.HELIX_ENABLED.name(), true);
    }

    public String getResourceType() {
        return this._record.getSimpleField(ResourceConfigProperty.RESOURCE_TYPE.name());
    }

    public String getResourceGroupName() {
        return this._record.getSimpleField(ResourceConfigProperty.RESOURCE_GROUP_NAME.name());
    }

    public Boolean isGroupRoutingEnabled() {
        return this._record.getBooleanField(ResourceConfigProperty.GROUP_ROUTING_ENABLED.name(), false);
    }

    public Boolean isExternalViewDisabled() {
        return this._record.getBooleanField(ResourceConfigProperty.EXTERNAL_VIEW_DISABLED.name(), false);
    }

    public RebalanceConfig getRebalanceConfig() {
        RebalanceConfig rebalanceConfig = new RebalanceConfig(this._record);
        return rebalanceConfig;
    }

    public void setStateTransitionTimeoutConfig(StateTransitionTimeoutConfig stateTransitionTimeoutConfig) {
        this.putMapConfig(StateTransitionTimeoutConfig.StateTransitionTimeoutProperty.TIMEOUT.name(), stateTransitionTimeoutConfig.getTimeoutMap());
    }

    public StateTransitionTimeoutConfig getStateTransitionTimeoutConfig() {
        return StateTransitionTimeoutConfig.fromRecord(this._record);
    }

    public void putSimpleConfigs(Map<String, String> configsMap) {
        this.getRecord().getSimpleFields().putAll(configsMap);
    }

    public Map<String, String> getSimpleConfigs() {
        return Collections.unmodifiableMap(this.getRecord().getSimpleFields());
    }

    public void putSimpleConfig(String configKey, String configVal) {
        this.getRecord().getSimpleFields().put(configKey, configVal);
    }

    public String getSimpleConfig(String configKey) {
        return this.getRecord().getSimpleFields().get(configKey);
    }

    public void putMapConfig(String configKey, Map<String, String> configValMap) {
        this.getRecord().setMapField(configKey, configValMap);
    }

    public Map<String, String> getMapConfig(String configKey) {
        return this.getRecord().getMapField(configKey);
    }

    public boolean simpleConfigContains(String configKey) {
        return this.getRecord().getSimpleFields().containsKey(configKey);
    }

    public boolean mapConfigContains(String configKey) {
        return this.getRecord().getMapFields().containsKey(configKey);
    }

    public Map<String, Map<String, String>> getMapConfigs() {
        return this.getRecord().getMapFields();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ResourceConfig) {
            ResourceConfig that = (ResourceConfig)obj;
            if (this.getId().equals(that.getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public class Builder {
        private String _resourceId;
        private Boolean _monitorDisabled;
        private int _numPartitions;
        private String _stateModelDefRef;
        private String _stateModelFactoryName;
        private String _numReplica;
        private int _minActiveReplica = -1;
        private int _maxPartitionsPerInstance = -1;
        private String _instanceGroupTag;
        private Boolean _helixEnabled;
        private String _resourceGroupName;
        private String _resourceType;
        private Boolean _groupRoutingEnabled;
        private Boolean _externalViewDisabled;
        private RebalanceConfig _rebalanceConfig;

        public Builder(String resourceId) {
            this._resourceId = resourceId;
        }

        public Builder setMonitorDisabled(boolean monitorDisabled) {
            this._monitorDisabled = monitorDisabled;
            return this;
        }

        public Boolean isMonitorDisabled() {
            return this._monitorDisabled;
        }

        public String getResourceId() {
            return this._resourceId;
        }

        public int getNumPartitions() {
            return this._numPartitions;
        }

        public Builder setNumPartitions(int numPartitions) {
            this._numPartitions = numPartitions;
            return this;
        }

        public String getStateModelDefRef() {
            return this._stateModelDefRef;
        }

        public Builder setStateModelDefRef(String stateModelDefRef) {
            this._stateModelDefRef = stateModelDefRef;
            return this;
        }

        public String getStateModelFactoryName() {
            return this._stateModelFactoryName;
        }

        public Builder setStateModelFactoryName(String stateModelFactoryName) {
            this._stateModelFactoryName = stateModelFactoryName;
            return this;
        }

        public String getNumReplica() {
            return this._numReplica;
        }

        public Builder setNumReplica(String numReplica) {
            this._numReplica = numReplica;
            return this;
        }

        public Builder setNumReplica(int numReplica) {
            return this.setNumReplica(String.valueOf(numReplica));
        }

        public int getMinActiveReplica() {
            return this._minActiveReplica;
        }

        public Builder setMinActiveReplica(int minActiveReplica) {
            this._minActiveReplica = minActiveReplica;
            return this;
        }

        public int getMaxPartitionsPerInstance() {
            return this._maxPartitionsPerInstance;
        }

        public Builder setMaxPartitionsPerInstance(int maxPartitionsPerInstance) {
            this._maxPartitionsPerInstance = maxPartitionsPerInstance;
            return this;
        }

        public String getInstanceGroupTag() {
            return this._instanceGroupTag;
        }

        public Builder setInstanceGroupTag(String instanceGroupTag) {
            this._instanceGroupTag = instanceGroupTag;
            return this;
        }

        public Boolean isHelixEnabled() {
            return this._helixEnabled;
        }

        public Builder setHelixEnabled(boolean helixEnabled) {
            this._helixEnabled = helixEnabled;
            return this;
        }

        public String getResourceType() {
            return this._resourceType;
        }

        public Builder setResourceType(String resourceType) {
            this._resourceType = resourceType;
            return this;
        }

        public String getResourceGroupName() {
            return this._resourceGroupName;
        }

        public Builder setResourceGroupName(String resourceGroupName) {
            this._resourceGroupName = resourceGroupName;
            return this;
        }

        public Boolean isGroupRoutingEnabled() {
            return this._groupRoutingEnabled;
        }

        public Builder setGroupRoutingEnabled(boolean groupRoutingEnabled) {
            this._groupRoutingEnabled = groupRoutingEnabled;
            return this;
        }

        public Boolean isExternalViewDisabled() {
            return this._externalViewDisabled;
        }

        public Builder setExternalViewDisabled(boolean externalViewDisabled) {
            this._externalViewDisabled = externalViewDisabled;
            return this;
        }

        public Builder setRebalanceConfig(RebalanceConfig rebalanceConfig) {
            this._rebalanceConfig = rebalanceConfig;
            return this;
        }

        public RebalanceConfig getRebalanceConfig() {
            return this._rebalanceConfig;
        }

        private void validate() {
            if (this._rebalanceConfig == null) {
                throw new IllegalArgumentException("RebalanceConfig not set!");
            }
            if (!this._rebalanceConfig.isValid()) {
                throw new IllegalArgumentException("Invalid RebalanceConfig!");
            }
            if (this._numPartitions <= 0) {
                throw new IllegalArgumentException("Invalid number of partitions!");
            }
            if (this._stateModelDefRef == null) {
                throw new IllegalArgumentException("State Model Definition Reference is not set!");
            }
            if (this._numReplica == null) {
                throw new IllegalArgumentException("Number of replica is not set!");
            }
            if (!this._numReplica.equals(ResourceConfigConstants.ANY_LIVEINSTANCE.name())) {
                try {
                    Integer.parseInt(this._numReplica);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid number of replica!");
                }
            }
        }

        public ResourceConfig build() {
            return new ResourceConfig(this._resourceId, this._monitorDisabled, this._numPartitions, this._stateModelDefRef, this._stateModelFactoryName, this._numReplica, this._minActiveReplica, this._maxPartitionsPerInstance, this._instanceGroupTag, this._helixEnabled, this._resourceGroupName, this._resourceType, this._groupRoutingEnabled, this._externalViewDisabled, this._rebalanceConfig);
        }
    }

    public static enum ResourceConfigConstants {
        ANY_LIVEINSTANCE;

    }

    public static enum ResourceConfigProperty {
        MONITORING_DISABLED,
        NUM_PARTITIONS,
        STATE_MODEL_DEF_REF,
        STATE_MODEL_FACTORY_NAME,
        REPLICAS,
        MIN_ACTIVE_REPLICAS,
        MAX_PARTITIONS_PER_INSTANCE,
        INSTANCE_GROUP_TAG,
        HELIX_ENABLED,
        RESOURCE_GROUP_NAME,
        RESOURCE_TYPE,
        GROUP_ROUTING_ENABLED,
        EXTERNAL_VIEW_DISABLED;

    }
}

