/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class AutoRebalancer
extends AbstractRebalancer {
    private static final Logger LOG = Logger.getLogger(AutoRebalancer.class);

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        ArrayList<String> partitions = new ArrayList<String>(currentIdealState.getPartitionSet());
        String stateModelName = currentIdealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = clusterData.getStateModelDef(stateModelName);
        Map<String, LiveInstance> liveInstance = clusterData.getLiveInstances();
        String replicas = currentIdealState.getReplicas();
        LinkedHashMap<String, Integer> stateCountMap = StateModelDefinition.getStateCountMap(stateModelDef, liveInstance.size(), Integer.parseInt(replicas));
        ArrayList<String> liveNodes = new ArrayList<String>(liveInstance.keySet());
        ArrayList<String> allNodes = new ArrayList<String>(clusterData.getInstanceConfigMap().keySet());
        allNodes.removeAll(clusterData.getDisabledInstances());
        liveNodes.retainAll(allNodes);
        Map<String, Map<String, String>> currentMapping = this.currentMapping(currentStateOutput, resourceName, partitions, stateCountMap);
        HashSet<String> taggedNodes = new HashSet<String>();
        HashSet<String> taggedLiveNodes = new HashSet<String>();
        if (currentIdealState.getInstanceGroupTag() != null) {
            for (String instanceName : allNodes) {
                if (!clusterData.getInstanceConfigMap().get(instanceName).containsTag(currentIdealState.getInstanceGroupTag())) continue;
                taggedNodes.add(instanceName);
                if (!liveInstance.containsKey(instanceName)) continue;
                taggedLiveNodes.add(instanceName);
            }
            if (!taggedLiveNodes.isEmpty()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("found the following participants with tag " + currentIdealState.getInstanceGroupTag() + " for " + resourceName + ": " + taggedLiveNodes));
                }
            } else if (taggedNodes.isEmpty()) {
                LOG.warn((Object)("Resource " + resourceName + " has tag " + currentIdealState.getInstanceGroupTag() + " but no configured participants have this tag"));
            } else {
                LOG.warn((Object)("Resource " + resourceName + " has tag " + currentIdealState.getInstanceGroupTag() + " but no live participants have this tag"));
            }
            allNodes = new ArrayList(taggedNodes);
            liveNodes = new ArrayList(taggedLiveNodes);
        }
        Collections.sort(allNodes);
        Collections.sort(liveNodes);
        int maxPartition = currentIdealState.getMaxPartitionsPerInstance();
        this._rebalanceStrategy = this.getRebalanceStrategy(currentIdealState.getRebalanceStrategy(), partitions, resourceName, stateCountMap, maxPartition);
        ZNRecord newMapping = this._rebalanceStrategy.computePartitionAssignment(allNodes, liveNodes, currentMapping, clusterData);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("currentMapping: " + currentMapping));
            LOG.debug((Object)("stateCountMap: " + stateCountMap));
            LOG.debug((Object)("liveNodes: " + liveNodes));
            LOG.debug((Object)("allNodes: " + allNodes));
            LOG.debug((Object)("maxPartition: " + maxPartition));
            LOG.debug((Object)("newMapping: " + newMapping));
        }
        IdealState newIdealState = new IdealState(resourceName);
        newIdealState.getRecord().setSimpleFields(currentIdealState.getRecord().getSimpleFields());
        newIdealState.setRebalanceMode(IdealState.RebalanceMode.FULL_AUTO);
        newIdealState.getRecord().setListFields(newMapping.getListFields());
        return newIdealState;
    }
}

