/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.transport.common.Client;
import com.typesafe.config.Config;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.async.AsyncRequestBuilder;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.converter.AvroHttpJoinConverter;
import org.apache.gobblin.http.HttpClient;
import org.apache.gobblin.http.HttpRequestResponseRecord;
import org.apache.gobblin.http.ResponseHandler;
import org.apache.gobblin.http.ResponseStatus;
import org.apache.gobblin.r2.R2Client;
import org.apache.gobblin.r2.R2ClientFactory;
import org.apache.gobblin.r2.R2ResponseStatus;
import org.apache.gobblin.r2.R2RestRequestBuilder;
import org.apache.gobblin.r2.R2RestResponseHandler;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroR2JoinConverter
extends AvroHttpJoinConverter<RestRequest, RestResponse> {
    private static final Logger log = LoggerFactory.getLogger(AvroR2JoinConverter.class);
    public static final String DEFAULT_PROTOCOL_VERSION = "1.0.0";

    @Override
    protected void fillHttpOutputData(Schema schema, GenericRecord outputRecord, RestRequest restRequest, ResponseStatus status) throws IOException {
        R2ResponseStatus r2ResponseStatus = (R2ResponseStatus)status;
        HttpRequestResponseRecord record = new HttpRequestResponseRecord();
        record.setRequestUrl(restRequest.getURI().toASCIIString());
        record.setMethod(restRequest.getMethod());
        record.setStatusCode(r2ResponseStatus.getStatusCode());
        record.setContentType(r2ResponseStatus.getContentType());
        record.setBody(r2ResponseStatus.getContent() == null ? null : r2ResponseStatus.getContent().asByteBuffer());
        outputRecord.put("HttpRequestResponse", (Object)record);
    }

    @Override
    protected HttpClient<RestRequest, RestResponse> createHttpClient(Config config, SharedResourcesBroker<GobblinScopeTypes> broker) {
        String urlTemplate = config.getString("urlTemplate");
        R2ClientFactory.Schema schema = R2ClientFactory.Schema.HTTP;
        if (urlTemplate.startsWith("d2://")) {
            schema = R2ClientFactory.Schema.D2;
        }
        R2ClientFactory factory = new R2ClientFactory(schema);
        Client client = factory.createInstance(config);
        return new R2Client(client, config, broker);
    }

    @Override
    protected ResponseHandler<RestRequest, RestResponse> createResponseHandler(Config config) {
        return new R2RestResponseHandler();
    }

    @Override
    protected AsyncRequestBuilder<GenericRecord, RestRequest> createRequestBuilder(Config config) {
        String urlTemplate = config.getString("urlTemplate");
        String verb = config.getString("verb");
        String protocolVersion = ConfigUtils.getString((Config)config, (String)"protocolVersion", (String)DEFAULT_PROTOCOL_VERSION);
        return new R2RestRequestBuilder(urlTemplate, verb, protocolVersion);
    }
}

