/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.reloperators;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.ql.optimizer.optiq.HiveOptiqUtil;
import org.apache.hadoop.hive.ql.optimizer.optiq.OptiqSemanticException;
import org.apache.hadoop.hive.ql.optimizer.optiq.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.optiq.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveRel;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.Mapping;

public class HiveProjectRel
extends ProjectRelBase
implements HiveRel {
    public static final RelFactories.ProjectFactory DEFAULT_PROJECT_FACTORY = new HiveProjectFactoryImpl();
    private final List<Integer> virtualCols;

    public HiveProjectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<? extends RexNode> exps, RelDataType rowType, int flags) {
        super(cluster, traitSet, child, exps, rowType, flags);
        this.virtualCols = ImmutableList.copyOf(HiveOptiqUtil.getVirtualCols(exps));
    }

    public static HiveProjectRel create(RelNode child, List<? extends RexNode> exps, List<String> fieldNames) throws OptiqSemanticException {
        RelOptCluster cluster = child.getCluster();
        if (fieldNames != null && !Util.isDistinct(fieldNames)) {
            String msg = "Select list contains multiple expressions with the same name." + fieldNames;
            throw new OptiqSemanticException(msg);
        }
        RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)cluster.getTypeFactory(), exps, fieldNames);
        return HiveProjectRel.create(cluster, child, exps, rowType, Collections.<RelCollation>emptyList());
    }

    public static HiveProjectRel create(RelOptCluster cluster, RelNode child, List<? extends RexNode> exps, RelDataType rowType, List<RelCollation> collationList) {
        RelTraitSet traitSet = TraitsUtil.getDefaultTraitSet(cluster);
        return new HiveProjectRel(cluster, traitSet, child, exps, rowType, 1);
    }

    public static HiveProjectRel create(RelOptCluster cluster, RelNode child, List<? extends RexNode> exps, RelDataType rowType, RelTraitSet traitSet, List<RelCollation> collationList) {
        return new HiveProjectRel(cluster, traitSet, child, exps, rowType, 1);
    }

    public static RelNode projectMapping(RelNode rel, Mapping mapping, List<String> fieldNames) throws OptiqSemanticException {
        assert (mapping.getMappingType().isSingleSource());
        assert (mapping.getMappingType().isMandatorySource());
        if (mapping.isIdentity()) {
            return rel;
        }
        ArrayList<String> outputNameList = new ArrayList<String>();
        ArrayList<RexInputRef> outputProjList = new ArrayList<RexInputRef>();
        List fields = rel.getRowType().getFieldList();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        for (int i = 0; i < mapping.getTargetCount(); ++i) {
            int source = mapping.getSource(i);
            RelDataTypeField sourceField = (RelDataTypeField)fields.get(source);
            outputNameList.add(fieldNames == null || fieldNames.size() <= i || fieldNames.get(i) == null ? sourceField.getName() : fieldNames.get(i));
            outputProjList.add(rexBuilder.makeInputRef(rel, source));
        }
        return HiveProjectRel.create(rel, outputProjList, outputNameList);
    }

    public ProjectRelBase copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
        assert (traitSet.containsIfApplicable((RelTrait)HiveRel.CONVENTION));
        return new HiveProjectRel(this.getCluster(), traitSet, input, exps, rowType, this.getFlags());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return HiveCost.FACTORY.makeZeroCost();
    }

    @Override
    public void implement(HiveRel.Implementor implementor) {
    }

    public List<Integer> getVirtualCols() {
        return this.virtualCols;
    }

    private static class HiveProjectFactoryImpl
    implements RelFactories.ProjectFactory {
        private HiveProjectFactoryImpl() {
        }

        public RelNode createProject(RelNode child, List<? extends RexNode> childExprs, List<String> fieldNames) {
            RelOptCluster cluster = child.getCluster();
            RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)cluster.getTypeFactory(), childExprs, fieldNames);
            HiveProjectRel project = HiveProjectRel.create(cluster, child, childExprs, rowType, child.getTraitSet(), Collections.<RelCollation>emptyList());
            return project;
        }
    }
}

