/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.convert.DataWritableRecordConverter;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.util.StringUtils;
import parquet.column.ColumnDescriptor;
import parquet.hadoop.api.ReadSupport;
import parquet.io.api.RecordMaterializer;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class DataWritableReadSupport
extends ReadSupport<ArrayWritable> {
    private static final String TABLE_SCHEMA = "table_schema";
    public static final String HIVE_SCHEMA_KEY = "HIVE_TABLE_SCHEMA";
    public static final String PARQUET_COLUMN_INDEX_ACCESS = "parquet.column.index.access";

    private static List<String> getColumns(String columns) {
        return (List)VirtualColumn.removeVirtualColumns(StringUtils.getStringCollection((String)columns));
    }

    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String columns = configuration.get("columns");
        HashMap<String, String> contextMetadata = new HashMap<String, String>();
        boolean indexAccess = configuration.getBoolean(PARQUET_COLUMN_INDEX_ACCESS, false);
        if (columns != null) {
            List<String> listColumns = DataWritableReadSupport.getColumns(columns);
            HashMap<String, String> lowerCaseFileSchemaColumns = new HashMap<String, String>();
            for (ColumnDescriptor c : fileSchema.getColumns()) {
                lowerCaseFileSchemaColumns.put(c.getPath()[0].toLowerCase(), c.getPath()[0]);
            }
            ArrayList<Object> typeListTable = new ArrayList<Object>();
            if (indexAccess) {
                for (int index = 0; index < listColumns.size(); ++index) {
                    if (index < fileSchema.getFieldCount()) {
                        typeListTable.add(fileSchema.getType(index));
                        continue;
                    }
                    typeListTable.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "_mask_" + listColumns.get(index)));
                }
            } else {
                for (String col : listColumns) {
                    if (lowerCaseFileSchemaColumns.containsKey(col = col.toLowerCase())) {
                        typeListTable.add(fileSchema.getType((String)lowerCaseFileSchemaColumns.get(col)));
                        continue;
                    }
                    typeListTable.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, col));
                }
            }
            MessageType tableSchema = new MessageType(TABLE_SCHEMA, typeListTable);
            contextMetadata.put(HIVE_SCHEMA_KEY, tableSchema.toString());
            List indexColumnsWanted = ColumnProjectionUtils.getReadColumnIDs((Configuration)configuration);
            ArrayList typeListWanted = new ArrayList();
            for (Integer idx : indexColumnsWanted) {
                if (idx >= listColumns.size()) continue;
                String col = listColumns.get(idx);
                if (indexAccess) {
                    typeListWanted.add(fileSchema.getFields().get(idx));
                    continue;
                }
                if (!lowerCaseFileSchemaColumns.containsKey(col = col.toLowerCase())) continue;
                typeListWanted.add(tableSchema.getType((String)lowerCaseFileSchemaColumns.get(col)));
            }
            MessageType requestedSchemaByUser = new MessageType(fileSchema.getName(), typeListWanted);
            return new ReadSupport.ReadContext(requestedSchemaByUser, contextMetadata);
        }
        contextMetadata.put(HIVE_SCHEMA_KEY, fileSchema.toString());
        return new ReadSupport.ReadContext(fileSchema, contextMetadata);
    }

    public RecordMaterializer<ArrayWritable> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        Map metadata = readContext.getReadSupportMetadata();
        if (metadata == null) {
            throw new IllegalStateException("ReadContext not initialized properly. Don't know the Hive Schema.");
        }
        MessageType tableSchema = MessageTypeParser.parseMessageType((String)((String)metadata.get(HIVE_SCHEMA_KEY)));
        return new DataWritableRecordConverter((GroupType)readContext.getRequestedSchema(), (GroupType)tableSchema);
    }
}

