/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

public class OrcRawRecordMerger
implements AcidInputFormat.RawReader<OrcStruct> {
    private static final Log LOG = LogFactory.getLog(OrcRawRecordMerger.class);
    private final Configuration conf;
    private final boolean collapse;
    private final RecordReader baseReader;
    private final long offset;
    private final long length;
    private final ValidTxnList validTxnList;
    private final int columns;
    private ReaderKey prevKey = new ReaderKey();
    private RecordIdentifier minKey;
    private RecordIdentifier maxKey;
    private OrcStruct extraValue;
    private final TreeMap<ReaderKey, ReaderPair> readers = new TreeMap();
    private ReaderPair primary;
    private ReaderKey secondaryKey = null;

    private void discoverOriginalKeyBounds(Reader reader, int bucket, Reader.Options options) throws IOException {
        long rowLength = 0L;
        long rowOffset = 0L;
        long offset = options.getOffset();
        long maxOffset = options.getMaxOffset();
        boolean isTail = true;
        for (StripeInformation stripe : reader.getStripes()) {
            if (offset > stripe.getOffset()) {
                rowOffset += stripe.getNumberOfRows();
                continue;
            }
            if (maxOffset > stripe.getOffset()) {
                rowLength += stripe.getNumberOfRows();
                continue;
            }
            isTail = false;
            break;
        }
        if (rowOffset > 0L) {
            this.minKey = new RecordIdentifier(0L, bucket, rowOffset - 1L);
        }
        if (!isTail) {
            this.maxKey = new RecordIdentifier(0L, bucket, rowOffset + rowLength - 1L);
        }
    }

    private void discoverKeyBounds(Reader reader, Reader.Options options) throws IOException {
        RecordIdentifier[] keyIndex = OrcRecordUpdater.parseKeyIndex(reader);
        long offset = options.getOffset();
        long maxOffset = options.getMaxOffset();
        int firstStripe = 0;
        int stripeCount = 0;
        boolean isTail = true;
        List<StripeInformation> stripes = reader.getStripes();
        for (StripeInformation stripe : stripes) {
            if (offset > stripe.getOffset()) {
                ++firstStripe;
                continue;
            }
            if (maxOffset > stripe.getOffset()) {
                ++stripeCount;
                continue;
            }
            isTail = false;
            break;
        }
        if (firstStripe != 0) {
            this.minKey = keyIndex[firstStripe - 1];
        }
        if (!isTail) {
            this.maxKey = keyIndex[firstStripe + stripeCount - 1];
        }
    }

    static Reader.Options createEventOptions(Reader.Options options) {
        int i;
        Object[] orig;
        Reader.Options result = options.clone();
        result.range(options.getOffset(), Long.MAX_VALUE);
        if (options.getInclude() != null) {
            orig = options.getInclude();
            orig[0] = true;
            boolean[] include = new boolean[orig.length + 6];
            Arrays.fill(include, 0, 6, true);
            for (i = 0; i < orig.length; ++i) {
                include[i + 6] = orig[i];
            }
            result.include(include);
        }
        if (options.getColumnNames() != null) {
            orig = options.getColumnNames();
            String[] cols = new String[orig.length + 6];
            for (i = 0; i < orig.length; ++i) {
                cols[i + 6] = (String)orig[i];
            }
            result.searchArgument(options.getSearchArgument(), cols);
        }
        return result;
    }

    OrcRawRecordMerger(Configuration conf, boolean collapseEvents, Reader reader, boolean isOriginal, int bucket, ValidTxnList validTxnList, Reader.Options options, Path[] deltaDirectory) throws IOException {
        Map.Entry<ReaderKey, ReaderPair> entry;
        this.conf = conf;
        this.collapse = collapseEvents;
        this.offset = options.getOffset();
        this.length = options.getLength();
        this.validTxnList = validTxnList;
        Reader.Options eventOptions = OrcRawRecordMerger.createEventOptions(options);
        if (reader == null) {
            this.baseReader = null;
        } else {
            ReaderPair pair;
            if (isOriginal) {
                this.discoverOriginalKeyBounds(reader, bucket, options);
            } else {
                this.discoverKeyBounds(reader, options);
            }
            LOG.info((Object)("min key = " + this.minKey + ", max key = " + this.maxKey));
            ReaderKey key = new ReaderKey();
            if (isOriginal) {
                options = options.clone();
                options.range(options.getOffset(), Long.MAX_VALUE);
                pair = new OriginalReaderPair(key, reader, bucket, this.minKey, this.maxKey, options);
            } else {
                pair = new ReaderPair(key, reader, bucket, this.minKey, this.maxKey, eventOptions);
            }
            if (pair.nextRecord != null) {
                this.readers.put(key, pair);
            }
            this.baseReader = pair.recordReader;
        }
        eventOptions.range(0L, Long.MAX_VALUE);
        eventOptions.searchArgument(null, null);
        if (deltaDirectory != null) {
            for (Path delta : deltaDirectory) {
                ReaderKey key = new ReaderKey();
                Path deltaFile = AcidUtils.createBucketFile(delta, bucket);
                FileSystem fs = deltaFile.getFileSystem(conf);
                long length = OrcRawRecordMerger.getLastFlushLength(fs, deltaFile);
                if (!fs.exists(deltaFile) || length == -1L) continue;
                Reader deltaReader = OrcFile.createReader(deltaFile, OrcFile.readerOptions(conf).maxLength(length));
                ReaderPair deltaPair = new ReaderPair(key, deltaReader, bucket, this.minKey, this.maxKey, eventOptions);
                if (deltaPair.nextRecord == null) continue;
                this.readers.put(key, deltaPair);
            }
        }
        if ((entry = this.readers.pollFirstEntry()) == null) {
            this.columns = 0;
            this.primary = null;
        } else {
            this.primary = entry.getValue();
            this.secondaryKey = this.readers.isEmpty() ? null : this.readers.firstKey();
            this.columns = this.primary.getColumns();
        }
    }

    private static long getLastFlushLength(FileSystem fs, Path deltaFile) throws IOException {
        Path lengths = OrcRecordUpdater.getSideFile(deltaFile);
        long result = Long.MAX_VALUE;
        try {
            FSDataInputStream stream = fs.open(lengths);
            result = -1L;
            while (stream.available() > 0) {
                result = stream.readLong();
            }
            stream.close();
            return result;
        }
        catch (IOException ioe) {
            return result;
        }
    }

    @VisibleForTesting
    RecordIdentifier getMinKey() {
        return this.minKey;
    }

    @VisibleForTesting
    RecordIdentifier getMaxKey() {
        return this.maxKey;
    }

    @VisibleForTesting
    ReaderPair getCurrentReader() {
        return this.primary;
    }

    @VisibleForTesting
    Map<ReaderKey, ReaderPair> getOtherReaders() {
        return this.readers;
    }

    public boolean next(RecordIdentifier recordIdentifier, OrcStruct prev) throws IOException {
        boolean keysSame = true;
        while (keysSame && this.primary != null) {
            OrcStruct current = this.primary.nextRecord;
            recordIdentifier.set(this.primary.key);
            this.primary.next(this.extraValue);
            this.extraValue = current;
            if (this.primary.nextRecord == null || this.primary.key.compareTo(this.secondaryKey) > 0) {
                Map.Entry<ReaderKey, ReaderPair> entry;
                if (this.primary.nextRecord != null) {
                    this.readers.put(this.primary.key, this.primary);
                }
                if ((entry = this.readers.pollFirstEntry()) != null) {
                    this.primary = entry.getValue();
                    this.secondaryKey = this.readers.isEmpty() ? null : this.readers.firstKey();
                } else {
                    this.primary = null;
                }
            }
            if (!this.validTxnList.isTxnValid(((ReaderKey)recordIdentifier).getCurrentTransactionId())) continue;
            if (this.collapse) {
                boolean bl = keysSame = this.prevKey.compareRow(recordIdentifier) == 0;
                if (!keysSame) {
                    this.prevKey.set(recordIdentifier);
                }
            } else {
                keysSame = false;
            }
            prev.linkFields(current);
        }
        return !keysSame;
    }

    public RecordIdentifier createKey() {
        return new ReaderKey();
    }

    public OrcStruct createValue() {
        return new OrcStruct(6);
    }

    public long getPos() throws IOException {
        return this.offset + (long)(this.getProgress() * (float)this.length);
    }

    public void close() throws IOException {
        for (ReaderPair pair : this.readers.values()) {
            pair.recordReader.close();
        }
    }

    public float getProgress() throws IOException {
        return this.baseReader == null ? 1.0f : this.baseReader.getProgress();
    }

    @Override
    public ObjectInspector getObjectInspector() {
        int i;
        String columnNameProperty = this.conf.get("columns");
        String columnTypeProperty = this.conf.get("columns.types");
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayDeque<Integer> virtualColumns = new ArrayDeque<Integer>();
        if (columnNameProperty != null && columnNameProperty.length() > 0) {
            String[] colNames = columnNameProperty.split(",");
            for (i = 0; i < colNames.length; ++i) {
                if (VirtualColumn.VIRTUAL_COLUMN_NAMES.contains((Object)colNames[i])) {
                    virtualColumns.addLast(i);
                    continue;
                }
                columnNames.add(colNames[i]);
            }
        }
        if (columnTypeProperty == null) {
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < columnNames.size(); ++i) {
                if (i > 0) {
                    sb.append(":");
                }
                sb.append("string");
            }
            columnTypeProperty = sb.toString();
        }
        ArrayList fieldTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        while (virtualColumns.size() > 0) {
            fieldTypes.remove(virtualColumns.removeLast());
        }
        StructTypeInfo rowType = new StructTypeInfo();
        rowType.setAllStructFieldNames(columnNames);
        rowType.setAllStructFieldTypeInfos(fieldTypes);
        return OrcRecordUpdater.createEventSchema(OrcStruct.createObjectInspector((TypeInfo)rowType));
    }

    @Override
    public boolean isDelete(OrcStruct value) {
        return OrcRecordUpdater.getOperation(value) == 2;
    }

    public int getColumns() {
        return this.columns;
    }

    static final class OriginalReaderPair
    extends ReaderPair {
        OriginalReaderPair(ReaderKey key, Reader reader, int bucket, RecordIdentifier minKey, RecordIdentifier maxKey, Reader.Options options) throws IOException {
            super(key, reader, bucket, minKey, maxKey, options);
        }

        @Override
        void next(OrcStruct next) throws IOException {
            if (this.recordReader.hasNext()) {
                long nextRowId = this.recordReader.getRowNumber();
                if (next == null) {
                    this.nextRecord = new OrcStruct(6);
                    IntWritable operation = new IntWritable(0);
                    this.nextRecord.setFieldValue(0, operation);
                    this.nextRecord.setFieldValue(4, new LongWritable(0L));
                    this.nextRecord.setFieldValue(1, new LongWritable(0L));
                    this.nextRecord.setFieldValue(2, new IntWritable(this.bucket));
                    this.nextRecord.setFieldValue(3, new LongWritable(nextRowId));
                    this.nextRecord.setFieldValue(5, this.recordReader.next(null));
                } else {
                    this.nextRecord = next;
                    ((IntWritable)next.getFieldValue(0)).set(0);
                    ((LongWritable)next.getFieldValue(1)).set(0L);
                    ((IntWritable)next.getFieldValue(2)).set(this.bucket);
                    ((LongWritable)next.getFieldValue(4)).set(0L);
                    ((LongWritable)next.getFieldValue(3)).set(0L);
                    this.nextRecord.setFieldValue(5, this.recordReader.next(OrcRecordUpdater.getRow(next)));
                }
                this.key.setValues(0L, this.bucket, nextRowId, 0L);
                if (this.maxKey != null && this.key.compareRow(this.maxKey) > 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("key " + this.key + " > maxkey " + this.maxKey));
                    }
                    this.nextRecord = null;
                    this.recordReader.close();
                }
            } else {
                this.nextRecord = null;
                this.recordReader.close();
            }
        }

        @Override
        int getColumns() {
            return this.reader.getTypes().get(0).getSubtypesCount();
        }
    }

    static class ReaderPair {
        OrcStruct nextRecord;
        final Reader reader;
        final RecordReader recordReader;
        final ReaderKey key;
        final RecordIdentifier maxKey;
        final int bucket;

        ReaderPair(ReaderKey key, Reader reader, int bucket, RecordIdentifier minKey, RecordIdentifier maxKey, Reader.Options options) throws IOException {
            this.reader = reader;
            this.key = key;
            this.maxKey = maxKey;
            this.bucket = bucket;
            this.recordReader = reader.rowsOptions(options);
            do {
                this.next(this.nextRecord);
            } while (this.nextRecord != null && minKey != null && key.compareRow(minKey) <= 0);
        }

        void next(OrcStruct next) throws IOException {
            if (this.recordReader.hasNext()) {
                this.nextRecord = (OrcStruct)this.recordReader.next(next);
                this.key.setValues(OrcRecordUpdater.getOriginalTransaction(this.nextRecord), OrcRecordUpdater.getBucket(this.nextRecord), OrcRecordUpdater.getRowId(this.nextRecord), OrcRecordUpdater.getCurrentTransaction(this.nextRecord));
                if (this.maxKey != null && this.key.compareRow(this.maxKey) > 0) {
                    LOG.debug((Object)("key " + this.key + " > maxkey " + this.maxKey));
                    this.nextRecord = null;
                    this.recordReader.close();
                }
            } else {
                this.nextRecord = null;
                this.recordReader.close();
            }
        }

        int getColumns() {
            return this.reader.getTypes().get(6).getSubtypesCount();
        }
    }

    static final class ReaderKey
    extends RecordIdentifier {
        private long currentTransactionId;

        public ReaderKey() {
            this(-1L, -1, -1L, -1L);
        }

        public ReaderKey(long originalTransaction, int bucket, long rowId, long currentTransactionId) {
            super(originalTransaction, bucket, rowId);
            this.currentTransactionId = currentTransactionId;
        }

        @Override
        public void set(RecordIdentifier other) {
            super.set(other);
            this.currentTransactionId = ((ReaderKey)other).currentTransactionId;
        }

        public void setValues(long originalTransactionId, int bucket, long rowId, long currentTransactionId) {
            this.setValues(originalTransactionId, bucket, rowId);
            this.currentTransactionId = currentTransactionId;
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && this.currentTransactionId == ((ReaderKey)other).currentTransactionId;
        }

        @Override
        public int compareTo(RecordIdentifier other) {
            int sup = this.compareToInternal(other);
            if (sup == 0) {
                if (other.getClass() == ReaderKey.class) {
                    ReaderKey oth = (ReaderKey)other;
                    if (this.currentTransactionId != oth.currentTransactionId) {
                        return this.currentTransactionId < oth.currentTransactionId ? 1 : -1;
                    }
                } else {
                    return -1;
                }
            }
            return sup;
        }

        public long getCurrentTransactionId() {
            return this.currentTransactionId;
        }

        public int compareRow(RecordIdentifier other) {
            return this.compareToInternal(other);
        }

        @Override
        public String toString() {
            return "{originalTxn: " + this.getTransactionId() + ", bucket: " + this.getBucketId() + ", row: " + this.getRowId() + ", currentTxn: " + this.currentTransactionId + "}";
        }
    }
}

