/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.client;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.config.common.impl.SingleLinkedListConfigKeyPath;
import org.apache.gobblin.config.store.api.ConfigKeyPath;
import org.apache.gobblin.config.store.api.ConfigStore;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.Path;

public class ConfigClientUtils {
    public static ConfigKeyPath buildConfigKeyPath(URI configKeyURI, ConfigStore cs) {
        ConfigClientUtils.checkMatchingSchemeAndAuthority(configKeyURI, cs);
        URI relative = cs.getStoreURI().relativize(configKeyURI);
        return ConfigClientUtils.getConfigKeyPath(relative.getPath());
    }

    public static URI buildUriInClientFormat(ConfigKeyPath configKeyPath, ConfigStore cs, boolean returnURIWithAuthority) {
        try {
            if (!returnURIWithAuthority) {
                return new URI(cs.getStoreURI().getScheme(), null, configKeyPath.getAbsolutePathString(), null, null);
            }
            URI storeRoot = cs.getStoreURI();
            if (configKeyPath.isRootPath()) {
                return storeRoot;
            }
            Path absPath = new Path(storeRoot.getPath(), configKeyPath.getAbsolutePathString().substring(1));
            return new URI(storeRoot.getScheme(), storeRoot.getAuthority(), absPath.toString(), null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can not build URI based on " + configKeyPath);
        }
    }

    public static Collection<URI> buildUriInClientFormat(Collection<ConfigKeyPath> configKeyPaths, ConfigStore cs, boolean returnURIWithAuthority) {
        ArrayList<URI> result = new ArrayList<URI>();
        if (configKeyPaths == null) {
            return result;
        }
        for (ConfigKeyPath p : configKeyPaths) {
            result.add(ConfigClientUtils.buildUriInClientFormat(p, cs, returnURIWithAuthority));
        }
        return result;
    }

    public static ConfigKeyPath getConfigKeyPath(String input) {
        String[] paths;
        SingleLinkedListConfigKeyPath result = SingleLinkedListConfigKeyPath.ROOT;
        for (String p : paths = input.split("/")) {
            if (p.equals("")) continue;
            result = result.createChild(p);
        }
        return result;
    }

    public static List<ConfigKeyPath> getConfigKeyPath(List<String> input) {
        ArrayList<ConfigKeyPath> result = new ArrayList<ConfigKeyPath>();
        for (String s : input) {
            result.add(ConfigClientUtils.getConfigKeyPath(s));
        }
        return result;
    }

    private static void checkMatchingSchemeAndAuthority(URI configKeyURI, ConfigStore cs) {
        Preconditions.checkNotNull((Object)configKeyURI, (Object)"input can not be null");
        Preconditions.checkNotNull((Object)cs, (Object)"input can not be null");
        Preconditions.checkArgument((boolean)configKeyURI.getScheme().equals(cs.getStoreURI().getScheme()), (Object)"Scheme name not match");
        boolean authorityCheck = configKeyURI.getAuthority() == null || configKeyURI.getAuthority().equals(cs.getStoreURI().getAuthority());
        Preconditions.checkArgument((boolean)authorityCheck, (Object)"Authority not match");
    }

    public static boolean isAncestorOrSame(URI descendant, URI ancestor) {
        Preconditions.checkNotNull((Object)descendant, (Object)"input can not be null");
        Preconditions.checkNotNull((Object)ancestor, (Object)"input can not be null");
        if (!ConfigClientUtils.stringSame(descendant.getScheme(), ancestor.getScheme())) {
            return false;
        }
        if (!ConfigClientUtils.stringSame(descendant.getAuthority(), ancestor.getAuthority())) {
            return false;
        }
        return ConfigClientUtils.isAncestorOrSame(ConfigClientUtils.getConfigKeyPath(descendant.getPath()), ConfigClientUtils.getConfigKeyPath(ancestor.getPath()));
    }

    public static boolean stringSame(String l, String r) {
        if (l == null && r == null) {
            return true;
        }
        if (l == null || r == null) {
            return false;
        }
        return l.equals(r);
    }

    public static boolean isAncestorOrSame(ConfigKeyPath descendant, ConfigKeyPath ancestor) {
        Preconditions.checkNotNull((Object)descendant, (Object)"input can not be null");
        Preconditions.checkNotNull((Object)ancestor, (Object)"input can not be null");
        if (descendant.equals(ancestor)) {
            return true;
        }
        if (descendant.isRootPath()) {
            return false;
        }
        return ConfigClientUtils.isAncestorOrSame(descendant.getParent(), ancestor);
    }

    public static Optional<Config> getOptionalRuntimeConfig(Properties properties) {
        Properties runtimeConfigProps = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!entry.getKey().toString().startsWith("gobblin.config.runtime.")) continue;
            runtimeConfigProps.put(entry.getKey().toString().replace("gobblin.config.runtime.", ""), entry.getValue().toString());
        }
        if (runtimeConfigProps.size() == 0) {
            return Optional.absent();
        }
        Config config = ConfigUtils.propertiesToConfig((Properties)runtimeConfigProps);
        return Optional.fromNullable((Object)config);
    }
}

