/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class CanonicalIdHolder {
    private static final Logger logger = LogService.getLogger();
    private Int2ObjectOpenHashMap idToObject = new Int2ObjectOpenHashMap();
    private Object2IntOpenHashMap objectToID = new Object2IntOpenHashMap();
    private int highestID = 0;

    public void addMapping(int id, Object object) {
        this.idToObject.put(id, object);
        this.objectToID.put(object, id);
        this.highestID = this.highestID < id ? id : this.highestID;
    }

    public int getId(Object object) {
        return this.objectToID.getInt(object);
    }

    public Object getObject(int id) {
        return this.idToObject.get(id);
    }

    public int createId(Object object) {
        assert (!this.objectToID.containsKey(object));
        int id = ++this.highestID;
        this.objectToID.put(object, id);
        this.idToObject.put(id, object);
        return id;
    }

    public Int2ObjectOpenHashMap getAllMappings() {
        return this.idToObject;
    }
}

