/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.eviction.EvictionStats;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class MemoryLRUStatistics
implements EvictionStats {
    @Immutable
    private static final StatisticsType statType;
    private static final int limitId;
    private static final int counterId;
    private static final int evictionsId;
    private static final int destroysId;
    private static final int evaluationsId;
    private static final int greedyReturnsId;
    private final Statistics stats;

    public MemoryLRUStatistics(StatisticsFactory factory, String name) {
        this.stats = factory.createAtomicStatistics(statType, "MemLRUStatistics-" + name);
    }

    @Override
    public Statistics getStatistics() {
        return this.stats;
    }

    @Override
    public void close() {
        this.stats.close();
    }

    @Override
    public void incEvictions() {
        this.stats.incLong(evictionsId, 1L);
    }

    @Override
    public void updateCounter(long delta) {
        this.stats.incLong(counterId, delta);
    }

    @Override
    public void incDestroys() {
        this.stats.incLong(destroysId, 1L);
    }

    @Override
    public void setLimit(long newValue) {
        this.stats.setLong(limitId, newValue);
    }

    @Override
    public void setCounter(long newValue) {
        this.stats.setLong(counterId, newValue);
    }

    @Override
    public void incEvaluations(long delta) {
        this.stats.incLong(evaluationsId, delta);
    }

    @Override
    public void incGreedyReturns(long delta) {
        this.stats.incLong(greedyReturnsId, delta);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        String bytesAllowedDesc = "Number of total bytes allowed in this region.";
        String byteCountDesc = "Number of bytes in region.";
        String lruEvictionsDesc = "Number of total entry evictions triggered by LRU.";
        String lruDestroysDesc = "Number of entries destroyed in the region through both destroy cache operations and eviction.";
        String lruEvaluationsDesc = "Number of entries evaluated during LRU operations.";
        String lruGreedyReturnsDesc = "Number of non-LRU entries evicted during LRU operations";
        statType = f.createType("MemLRUStatistics", "Statistics relates to memory based eviction", new StatisticDescriptor[]{f.createLongGauge("bytesAllowed", "Number of total bytes allowed in this region.", "bytes"), f.createLongGauge("byteCount", "Number of bytes in region.", "bytes"), f.createLongCounter("lruEvictions", "Number of total entry evictions triggered by LRU.", "entries"), f.createLongCounter("lruDestroys", "Number of entries destroyed in the region through both destroy cache operations and eviction.", "entries"), f.createLongCounter("lruEvaluations", "Number of entries evaluated during LRU operations.", "entries"), f.createLongCounter("lruGreedyReturns", "Number of non-LRU entries evicted during LRU operations", "entries")});
        limitId = statType.nameToId("bytesAllowed");
        counterId = statType.nameToId("byteCount");
        evictionsId = statType.nameToId("lruEvictions");
        destroysId = statType.nameToId("lruDestroys");
        evaluationsId = statType.nameToId("lruEvaluations");
        greedyReturnsId = statType.nameToId("lruGreedyReturns");
    }
}

