/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.IOException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.tcp.ConnectExceptions;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.MsgStreamer;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class DirectReplySender
implements ReplySender {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final DMStats DUMMY_STATS = new LonerDistributionManager.DummyDMStats();
    @NotNull
    private final Connection connection;
    private boolean sentReply = false;

    public DirectReplySender(@NotNull Connection connection) {
        this.connection = connection;
    }

    @Override
    @NotNull
    public Set<InternalDistributedMember> putOutgoing(@NotNull DistributionMessage msg) {
        Assert.assertTrue(!this.sentReply, "Trying to reply twice to a message");
        this.connection.getConduit().getDM().getCancelCriterion().checkCancelInProgress(null);
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "Sending a direct reply {} to {}", (Object)msg, (Object)this.connection.getRemoteAddress());
        }
        MsgStreamer ms = (MsgStreamer)MsgStreamer.create(this.getConnections(), msg, false, DUMMY_STATS, this.connection.getBufferPool());
        try {
            ms.writeMessage();
            ConnectExceptions ce = ms.getConnectExceptions();
            if (ce != null && !ce.getMembers().isEmpty()) {
                Assert.assertTrue(ce.getMembers().size() == 1);
                InternalDistributedMember member = ce.getMembers().get(0);
                logger.warn("Failed sending a direct reply to {}", (Object)member);
                Set<InternalDistributedMember> set = Collections.singleton(member);
                return set;
            }
            this.sentReply = true;
            Set<InternalDistributedMember> set = Collections.emptySet();
            return set;
        }
        catch (NotSerializableException e) {
            throw new InternalGemFireException(e);
        }
        catch (IOException ex) {
            throw new InternalGemFireException("Unknown error serializing message", ex);
        }
        finally {
            try {
                ms.close();
            }
            catch (IOException e) {
                throw new InternalGemFireException("Unknown error serializing message", e);
            }
        }
    }

    @NotNull
    List<Connection> getConnections() {
        ArrayList<Connection> connections = new ArrayList<Connection>(1);
        connections.add(this.connection);
        return connections;
    }
}

