/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.serial;

import java.util.Set;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.asyncqueue.AsyncEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderEventProcessor;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class SerialSecondaryGatewayListener
extends CacheListenerAdapter<Long, AsyncEvent<?, ?>> {
    private static final Logger logger = LogService.getLogger();
    private final SerialGatewaySenderEventProcessor processor;
    private final AbstractGatewaySender sender;

    protected SerialSecondaryGatewayListener(SerialGatewaySenderEventProcessor eventProcessor) {
        this.processor = eventProcessor;
        this.sender = eventProcessor.getSender();
    }

    @Override
    public void afterCreate(EntryEvent<Long, AsyncEvent<?, ?>> event) {
        if (this.sender.isPrimary()) {
            return;
        }
        Set<RegionQueue> queues = this.sender.getQueues();
        if (queues != null && !queues.isEmpty()) {
            this.sender.getStatistics().incQueueSize();
        }
        GatewaySenderEventImpl senderEvent = (GatewaySenderEventImpl)event.getNewValue();
        this.processor.handlePrimaryEvent(senderEvent);
    }

    @Override
    public void afterDestroy(EntryEvent<Long, AsyncEvent<?, ?>> event) {
        AsyncEvent<?, ?> oldValue;
        if (this.sender.isPrimary()) {
            return;
        }
        Set<RegionQueue> queues = this.sender.getQueues();
        if (queues != null && !queues.isEmpty()) {
            this.sender.getStatistics().decQueueSize();
        }
        if ((oldValue = event.getOldValue()) instanceof GatewaySenderEventImpl) {
            GatewaySenderEventImpl senderEvent = (GatewaySenderEventImpl)oldValue;
            if (logger.isDebugEnabled()) {
                logger.debug("Received after Destroy for Secondary event {} the key was {}", (Object)senderEvent, (Object)event.getKey());
            }
            this.processor.handlePrimaryDestroy(senderEvent);
        }
    }
}

