/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.logging.log4j.Logger;

public class PdxRegistryRecoveryListener
extends EndpointManager.EndpointListenerAdapter {
    private static final Logger logger = LogService.getLogger();
    private final AtomicInteger endpointCount = new AtomicInteger();
    private final InternalPool pool;

    public PdxRegistryRecoveryListener(InternalPool pool) {
        this.pool = pool;
    }

    @Override
    public void endpointCrashed(Endpoint endpoint) {
        int count = this.endpointCount.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("PdxRegistryRecoveryListener - EndpointCrashed. Now have {} endpoints", (Object)count);
        }
    }

    @Override
    public void endpointNoLongerInUse(Endpoint endpoint) {
        int count = this.endpointCount.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("PdxRegistryRecoveryListener - EndpointNoLongerInUse. Now have {} endpoints", (Object)count);
        }
    }

    @Override
    public void endpointNowInUse(Endpoint endpoint) {
        int count = this.endpointCount.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("PdxRegistryRecoveryListener - EndpointNowInUse. Now have {} endpoints", (Object)count);
        }
        if (count == 1) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache == null) {
                return;
            }
            TypeRegistry registry = cache.getPdxRegistry();
            if (registry == null) {
                return;
            }
            registry.clear();
        }
    }
}

