/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.commands.CreateGatewaySenderCommand;
import org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunction;
import org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunctionArgs;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyGatewaySenderCommand
extends SingleGfshCommand {
    private static final Logger logger = LogService.getLogger();
    private static final int MBEAN_DELETION_WAIT_TIME = 10000;

    @CliCommand(value={"destroy gateway-sender"}, help="Destroy the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel destroyGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="geode.converter.gateway.senderid:disable-string-converter", help="Id of the GatewaySender.") String id, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to destroy the Gateway Sender.") String[] onGroups, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which to destroy the Gateway Sender.") String[] onMember, @CliOption(key={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifExist) {
        GatewaySenderDestroyFunctionArgs gatewaySenderDestroyFunctionArgs = new GatewaySenderDestroyFunctionArgs(id, ifExist);
        Set<DistributedMember> members = this.getMembers(onGroups, onMember);
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult((Function<?>)GatewaySenderDestroyFunction.INSTANCE, gatewaySenderDestroyFunctionArgs, members);
        ResultModel resultModel = ResultModel.createMemberStatusResult(functionResults);
        resultModel.setConfigObject(id);
        if (!this.waitForGatewaySenderMBeanDeletion(id, members)) {
            resultModel.addInfo().addLine("Did not complete waiting for GatewaySenderMBean proxy deletion");
        }
        return resultModel;
    }

    @VisibleForTesting
    boolean waitForGatewaySenderMBeanDeletion(String id, Set<DistributedMember> members) {
        DistributedSystemMXBean dsMXBean = this.getManagementService().getDistributedSystemMXBean();
        return this.poll(10000L, TimeUnit.MILLISECONDS, () -> members.stream().noneMatch(m -> CreateGatewaySenderCommand.gatewaySenderBeanExists(dsMXBean, m.getName(), id)));
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object id) {
        config.getGatewaySenders().removeIf(sender -> sender.getId().equals(id));
        return true;
    }
}

