/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.TransactionWriter;

public class CacheTransactionManagerCreation
implements CacheTransactionManager {
    private final ArrayList txListeners = new ArrayList();
    private TransactionWriter writer = null;

    @Override
    public TransactionListener setListener(TransactionListener newListener) {
        TransactionListener result = this.getListener();
        this.txListeners.clear();
        if (newListener != null) {
            this.txListeners.add(newListener);
        }
        return result;
    }

    @Override
    public void initListeners(TransactionListener[] newListeners) {
        this.txListeners.clear();
        if (newListeners != null && newListeners.length > 0) {
            this.txListeners.addAll(Arrays.asList(newListeners));
        }
    }

    @Override
    public void addListener(TransactionListener newListener) {
        if (!this.txListeners.contains(newListener)) {
            this.txListeners.add(newListener);
        }
    }

    @Override
    public void removeListener(TransactionListener newListener) {
        this.txListeners.remove(newListener);
    }

    @Override
    public TransactionListener[] getListeners() {
        TransactionListener[] result = new TransactionListener[this.txListeners.size()];
        this.txListeners.toArray(result);
        return result;
    }

    @Override
    public TransactionListener getListener() {
        if (this.txListeners.isEmpty()) {
            return null;
        }
        if (this.txListeners.size() == 1) {
            return (TransactionListener)this.txListeners.get(0);
        }
        throw new IllegalStateException("more than one transaction listener exists");
    }

    @Override
    public TransactionId getTransactionId() {
        throw new UnsupportedOperationException("Getting a TransactionId not supported");
    }

    @Override
    public void begin() {
        throw new UnsupportedOperationException("Transactions not supported");
    }

    @Override
    public void commit() throws CommitConflictException {
        throw new UnsupportedOperationException("Transactions not supported");
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException("Transactions not supported");
    }

    @Override
    public boolean exists() {
        throw new UnsupportedOperationException("Transactions not supported");
    }

    @Override
    public void setWriter(TransactionWriter writer) {
        this.writer = writer;
    }

    @Override
    public TransactionWriter getWriter() {
        return this.writer;
    }

    @Override
    public TransactionId suspend() {
        throw new UnsupportedOperationException("Transactions not supported");
    }

    @Override
    public void resume(TransactionId transactionId) {
        throw new UnsupportedOperationException("Transactions not supported");
    }

    @Override
    public boolean isSuspended(TransactionId transactionId) {
        throw new UnsupportedOperationException("Transactions not supported");
    }

    @Override
    public boolean tryResume(TransactionId transactionId) {
        throw new UnsupportedOperationException("Transactions not supported");
    }

    @Override
    public boolean tryResume(TransactionId transactionId, long time, TimeUnit unit) {
        throw new UnsupportedOperationException("Transactions not supported");
    }

    @Override
    public boolean exists(TransactionId transactionId) {
        throw new UnsupportedOperationException("Transactions not supported");
    }

    @Override
    public void setDistributed(boolean distributed) {
        throw new UnsupportedOperationException("Transactions not supported");
    }

    @Override
    public boolean isDistributed() {
        throw new UnsupportedOperationException("Transactions not supported");
    }
}

