/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.set.RedisSetCommands;
import org.apache.geode.redis.internal.executor.set.SetExecutor;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public abstract class SetOpExecutor
extends SetExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        int setsStartIndex = 1;
        if (this.isStorage()) {
            ++setsStartIndex;
        }
        List<RedisKey> commandElements = command.getProcessedCommandWrapperKeys();
        ArrayList<RedisKey> setKeys = new ArrayList<RedisKey>(commandElements.subList(setsStartIndex, commandElements.size()));
        if (this.isStorage()) {
            int storeCount;
            RedisKey destination = command.getKey();
            RedisSetCommands redisSetCommands = this.createRedisSetCommands(context);
            switch (command.getCommandType()) {
                case SUNIONSTORE: {
                    storeCount = redisSetCommands.sunionstore(destination, setKeys);
                    break;
                }
                case SINTERSTORE: {
                    storeCount = redisSetCommands.sinterstore(destination, setKeys);
                    break;
                }
                case SDIFFSTORE: {
                    storeCount = redisSetCommands.sdiffstore(destination, setKeys);
                    break;
                }
                default: {
                    throw new IllegalStateException("expected a set store command but found: " + (Object)((Object)command.getCommandType()));
                }
            }
            return RedisResponse.integer(storeCount);
        }
        return this.doActualSetOperation(context, setKeys);
    }

    private RedisResponse doActualSetOperation(ExecutionHandlerContext context, ArrayList<RedisKey> setKeys) {
        RedisKey key;
        Set<ByteArrayWrapper> nextSet;
        RedisSetCommands redisSetCommands = this.createRedisSetCommands(context);
        RedisKey firstSetKey = setKeys.remove(0);
        Set<ByteArrayWrapper> resultSet = redisSetCommands.smembers(firstSetKey);
        Iterator<RedisKey> iterator = setKeys.iterator();
        while (iterator.hasNext() && !this.doSetOp(resultSet, nextSet = redisSetCommands.smembers(key = iterator.next()))) {
        }
        if (resultSet.isEmpty()) {
            return RedisResponse.emptyArray();
        }
        return this.respondBulkStrings(resultSet);
    }

    protected abstract boolean doSetOp(Set<ByteArrayWrapper> var1, Set<ByteArrayWrapper> var2);

    protected abstract boolean isStorage();
}

