/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.key;

import java.util.concurrent.TimeUnit;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.key.RedisKeyCommands;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class TTLExecutor
extends AbstractExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        RedisKey key = command.getKey();
        RedisKeyCommands redisKeyCommands = this.getRedisKeyCommands(context);
        long result = redisKeyCommands.pttl(key);
        if (result > 0L && !this.timeUnitMillis()) {
            result = TimeUnit.MILLISECONDS.toSeconds(result + 500L);
        }
        return RedisResponse.integer(result);
    }

    protected boolean timeUnitMillis() {
        return false;
    }
}

