/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.ParameterRequirements;

import org.apache.geode.redis.internal.ParameterRequirements.ParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.RedisParametersMismatchException;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class MaximumParameterRequirements
implements ParameterRequirements {
    private final int maximum;
    private final String errorMessage;

    public MaximumParameterRequirements(int maximum) {
        this(maximum, null);
    }

    public MaximumParameterRequirements(int maximum, String errorMessage) {
        this.maximum = maximum;
        this.errorMessage = errorMessage;
    }

    @Override
    public void checkParameters(Command command, ExecutionHandlerContext executionHandlerContext) {
        if (command.getProcessedCommand().size() > this.maximum) {
            throw new RedisParametersMismatchException(this.getErrorMessage(command));
        }
    }

    private String getErrorMessage(Command command) {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        return command.wrongNumberOfArgumentsErrorMessage();
    }
}

