/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;

public class CreateRegion
extends BaseCommand {
    @Immutable
    private static final CreateRegion singleton = new CreateRegion();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        Region<Object, Object> region;
        Part regionNamePart = null;
        String regionName = null;
        serverConnection.setAsTrue(2);
        Part parentRegionNamePart = clientMessage.getPart(0);
        String parentRegionName = parentRegionNamePart.getCachedString();
        regionNamePart = clientMessage.getPart(1);
        regionName = regionNamePart.getCachedString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received create region request ({} bytes) from {} for parent region {} region {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)parentRegionName, (Object)regionName);
        }
        if (parentRegionName == null || regionName == null) {
            String errMessage = "";
            if (parentRegionName == null) {
                logger.warn("{}: The input parent region name for the create region request is null", (Object)serverConnection.getName());
                errMessage = "The input parent region name for the create region request is null";
            }
            if (regionName == null) {
                logger.warn("{}: The input region name for the create region request is null", (Object)serverConnection.getName());
                errMessage = "The input region name for the create region request is null";
            }
            CreateRegion.writeErrorResponse(clientMessage, 30, errMessage, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Region parentRegion = serverConnection.getCache().getRegion(parentRegionName);
        if (parentRegion == null) {
            String reason = " was not found during subregion creation request";
            CreateRegion.writeRegionDestroyedEx(clientMessage, parentRegionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.MANAGE);
        }
        catch (NotAuthorizedException ex) {
            CreateRegion.writeException(clientMessage, ex, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
        if (authzRequest != null) {
            try {
                authzRequest.createRegionAuthorize(parentRegionName + "/" + regionName);
            }
            catch (NotAuthorizedException ex) {
                CreateRegion.writeException(clientMessage, ex, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        if ((region = parentRegion.getSubregion(regionName)) == null) {
            AttributesFactory factory = new AttributesFactory(parentRegion.getAttributes());
            region = parentRegion.createSubregion(regionName, factory.create());
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Created region {}", (Object)serverConnection.getName(), region);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("{}: Retrieved region {}", (Object)serverConnection.getName(), region);
        }
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent create region response for parent region {} region {}", (Object)serverConnection.getName(), (Object)parentRegionName, (Object)regionName);
        }
    }
}

