/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.Oplog;
import org.apache.geode.internal.cache.backup.BackupDefinition;
import org.apache.geode.internal.cache.backup.TemporaryBackupFiles;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class BackupFileCopier {
    private static final Logger logger = LogService.getLogger();
    private static final String CONFIG_DIRECTORY = "config";
    private static final String USER_FILES = "user";
    private final InternalCache cache;
    private final TemporaryBackupFiles temporaryFiles;
    private final BackupDefinition backupDefinition = new BackupDefinition();
    private final Path userDirectory;
    private final Path configDirectory;

    BackupFileCopier(InternalCache cache, TemporaryBackupFiles temporaryFiles) {
        this.cache = cache;
        this.temporaryFiles = temporaryFiles;
        this.userDirectory = temporaryFiles.getDirectory().resolve(USER_FILES);
        this.configDirectory = temporaryFiles.getDirectory().resolve(CONFIG_DIRECTORY);
    }

    BackupDefinition getBackupDefinition() {
        return this.backupDefinition;
    }

    void copyConfigFiles() throws IOException {
        this.ensureExistence(this.configDirectory);
        this.addConfigFileToBackup(this.cache.getCacheXmlURL());
        this.addConfigFileToBackup(DistributedSystem.getPropertiesFileURL());
    }

    private void ensureExistence(Path directory) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
    }

    private void addConfigFileToBackup(URL fileUrl) throws IOException {
        if (fileUrl == null) {
            return;
        }
        try {
            Path source = this.getSource(fileUrl);
            if (Files.notExists(source, new LinkOption[0])) {
                return;
            }
            Path destination = this.configDirectory.resolve(source.getFileName());
            Files.copy(source, destination, StandardCopyOption.COPY_ATTRIBUTES);
            this.backupDefinition.addConfigFileToBackup(destination);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    Set<File> copyUserFiles() throws IOException {
        this.ensureExistence(this.userDirectory);
        List<File> backupFiles = this.cache.getBackupFiles();
        HashSet<File> userFilesBackedUp = new HashSet<File>();
        for (File original : backupFiles) {
            if (!original.exists()) continue;
            original = original.getAbsoluteFile();
            Path destination = this.userDirectory.resolve(original.getName());
            if (original.isDirectory()) {
                FileUtils.copyDirectory(original, destination.toFile());
            } else {
                Files.copy(original.toPath(), destination, StandardCopyOption.COPY_ATTRIBUTES);
            }
            this.backupDefinition.addUserFilesToBackup(destination, original.toPath());
            userFilesBackedUp.add(original);
        }
        return userFilesBackedUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<File> copyDeployedJars() throws IOException {
        this.ensureExistence(this.userDirectory);
        HashSet<File> userJars = new HashSet<File>();
        JarDeployer deployer = null;
        try {
            deployer = this.getJarDeployer();
            deployer.suspendAll();
            List<DeployedJar> jarList = deployer.findDeployedJars();
            for (DeployedJar jar : jarList) {
                File source = new File(jar.getFileCanonicalPath());
                String sourceFileName = source.getName();
                Path destination = this.userDirectory.resolve(sourceFileName);
                Files.copy(source.toPath(), destination, StandardCopyOption.COPY_ATTRIBUTES);
                this.backupDefinition.addDeployedJarToBackup(destination, source.toPath());
                userJars.add(source);
            }
        }
        finally {
            if (deployer != null) {
                deployer.resumeAll();
            }
        }
        return userJars;
    }

    void copyDiskInitFile(DiskStoreImpl diskStore) throws IOException {
        File diskInitFile = diskStore.getDiskInitFile().getIFFile();
        String subDirName = Integer.toString(diskStore.getInforFileDirIndex());
        Path subDir = this.temporaryFiles.getDirectory().resolve(subDirName);
        Files.createDirectories(subDir, new FileAttribute[0]);
        Files.copy(diskInitFile.toPath(), subDir.resolve(diskInitFile.getName()), StandardCopyOption.COPY_ATTRIBUTES);
        this.backupDefinition.addDiskInitFile(diskStore, subDir.resolve(diskInitFile.getName()));
    }

    void copyOplog(DiskStore diskStore, Oplog oplog) throws IOException {
        DirectoryHolder dirHolder = oplog.getDirectoryHolder();
        this.copyOplogFile(diskStore, dirHolder, oplog.getCrfFile());
        this.copyOplogFile(diskStore, dirHolder, oplog.getDrfFile());
        this.copyOplogFile(diskStore, dirHolder, oplog.getKrfFile());
    }

    private void copyOplogFile(DiskStore diskStore, DirectoryHolder dirHolder, File file) throws IOException {
        if (file == null || !file.exists()) {
            return;
        }
        Path tempDiskDir = this.temporaryFiles.getDiskStoreDirectory(diskStore, dirHolder);
        if (!SystemUtils.isWindows()) {
            try {
                this.createLink(tempDiskDir.resolve(file.getName()), file.toPath());
            }
            catch (IOException e) {
                logger.warn("Unable to create hard link for {}. Reverting to file copy", (Object)tempDiskDir.toString());
                FileUtils.copyFileToDirectory(file, tempDiskDir.toFile());
            }
        } else {
            FileUtils.copyFileToDirectory(file, tempDiskDir.toFile());
        }
        this.backupDefinition.addOplogFileToBackup(diskStore, tempDiskDir.resolve(file.getName()));
    }

    JarDeployer getJarDeployer() {
        return ClassPathLoader.getLatest().getJarDeployer();
    }

    void createLink(Path link, Path existing) throws IOException {
        Files.createLink(link, existing);
    }

    Path getSource(URL fileUrl) throws URISyntaxException {
        return Paths.get(fileUrl.toURI());
    }
}

