/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.apache.geode.CancelException;
import org.apache.geode.CopyHelper;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.DeltaSerializationException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.partition.PartitionListener;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.AtomicLongWithTerminalState;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.AbstractBucketRegionQueue;
import org.apache.geode.internal.cache.AbstractRegionMap;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.CreateRegionProcessor;
import org.apache.geode.internal.cache.DestroyOperation;
import org.apache.geode.internal.cache.DestroyRegionOperation;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.ExpiryTask;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.InvalidateOperation;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.SenderIdMonitor;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.UpdateEntryVersionOperation;
import org.apache.geode.internal.cache.UpdateOperation;
import org.apache.geode.internal.cache.control.MemoryEvent;
import org.apache.geode.internal.cache.event.EventSequenceNumberHolder;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.partitioned.DestroyMessage;
import org.apache.geode.internal.cache.partitioned.InvalidateMessage;
import org.apache.geode.internal.cache.partitioned.LockObject;
import org.apache.geode.internal.cache.partitioned.PRTombstoneMessage;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PutAllPRMessage;
import org.apache.geode.internal.cache.partitioned.PutMessage;
import org.apache.geode.internal.cache.partitioned.RemoveAllPRMessage;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientTombstoneMessage;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.concurrent.AtomicLong5;
import org.apache.geode.internal.concurrent.Atomics;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class BucketRegion
extends DistributedRegion
implements Bucket {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final RawValue NULLVALUE = new RawValue(null);
    @Immutable
    public static final RawValue REQUIRES_ENTRY_LOCK = new RawValue(null);
    private static final long BUCKET_DESTROYED = Long.MIN_VALUE;
    private AtomicLong counter = new AtomicLong();
    private AtomicLong limit;
    private final AtomicLong numOverflowOnDisk = new AtomicLong();
    private final AtomicLong numOverflowBytesOnDisk = new AtomicLong();
    private final AtomicLong numEntriesInVM = new AtomicLong();
    private final AtomicLong evictions = new AtomicLong();
    private CreateRegionProcessor.CreateRegionReplyProcessor createRegionReplyProcessor;
    private final AtomicLongWithTerminalState bytesInMemory = new AtomicLongWithTerminalState();
    private final int redundancy;
    private final PartitionedRegion partitionedRegion;
    private final Map<Object, ExpiryTask> pendingSecondaryExpires = new HashMap<Object, ExpiryTask>();
    private final HashMap<Object, LockObject> allKeysMap = new HashMap();
    static final boolean FORCE_LOCAL_LISTENERS_INVOCATION = Boolean.getBoolean("gemfire.BucketRegion.alwaysFireLocalListeners");
    private volatile AtomicLong5 eventSeqNum = null;
    boolean isDestroyingDiskRegion;

    AtomicLong5 getEventSeqNum() {
        return this.eventSeqNum;
    }

    public BucketRegion(String regionName, RegionAttributes attrs, LocalRegion parentRegion, InternalCache cache, InternalRegionArguments internalRegionArgs, StatisticsClock statisticsClock) {
        super(regionName, attrs, parentRegion, cache, internalRegionArgs, statisticsClock);
        if (PartitionedRegion.DISABLE_SECONDARY_BUCKET_ACK) {
            Assert.assertTrue(attrs.getScope().isDistributedNoAck());
        } else {
            Assert.assertTrue(attrs.getScope().isDistributedAck());
        }
        Assert.assertTrue(attrs.getDataPolicy().withReplication());
        Assert.assertTrue(!attrs.getEarlyAck());
        Assert.assertTrue(this.isUsedForPartitionedRegionBucket());
        Assert.assertTrue(!this.isUsedForPartitionedRegionAdmin());
        Assert.assertTrue(internalRegionArgs.getBucketAdvisor() != null);
        Assert.assertTrue(internalRegionArgs.getPartitionedRegion() != null);
        this.redundancy = internalRegionArgs.getPartitionedRegionBucketRedundancy();
        this.partitionedRegion = internalRegionArgs.getPartitionedRegion();
        this.setEventSeqNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(InputStream snapshotInputStream, InternalDistributedMember imageTarget, InternalRegionArguments internalRegionArgs) throws TimeoutException, IOException, ClassNotFoundException {
        this.getBucketAdvisor().getProxyBucketRegion().setBucketRegion(this);
        boolean success = false;
        try {
            InternalDistributedMember primaryHolder = this.getBucketAdvisor().basicGetPrimaryMember();
            if (primaryHolder != null && !primaryHolder.equals(this.getMyId())) {
                super.initialize(snapshotInputStream, primaryHolder, internalRegionArgs);
            } else {
                super.initialize(snapshotInputStream, imageTarget, internalRegionArgs);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.removeFromPeersAdvisors(false);
                this.getBucketAdvisor().getProxyBucketRegion().clearBucketRegion(this);
            }
        }
    }

    private void setEventSeqNum() {
        BucketRegion parentBucket;
        PartitionedRegion parentPR;
        if (this.partitionedRegion.isShadowPR() && this.partitionedRegion.getColocatedWith() != null) {
            parentPR = ColocationHelper.getLeaderRegion(this.partitionedRegion);
            parentBucket = parentPR.getDataStore().getLocalBucketById(this.getId());
            if (parentBucket.eventSeqNum == null) {
                parentBucket.eventSeqNum = new AtomicLong5(this.getId());
            }
        }
        if (this.partitionedRegion.getColocatedWith() == null) {
            this.eventSeqNum = new AtomicLong5(this.getId());
        } else {
            parentPR = ColocationHelper.getLeaderRegion(this.partitionedRegion);
            parentBucket = parentPR.getDataStore().getLocalBucketById(this.getId());
            if (parentBucket == null && logger.isDebugEnabled()) {
                logger.debug("The parentBucket of region {} bucketId {} is NULL", (Object)this.partitionedRegion.getFullPath(), (Object)this.getId());
            }
            Assert.assertTrue(parentBucket != null);
            this.eventSeqNum = parentBucket.eventSeqNum;
        }
    }

    @Override
    void initialized() {
    }

    @Override
    DiskStoreImpl findDiskStore(RegionAttributes regionAttributes, InternalRegionArguments internalRegionArgs) {
        return internalRegionArgs.getPartitionedRegion().getDiskStore();
    }

    @Override
    public void registerCreateRegionReplyProcessor(CreateRegionProcessor.CreateRegionReplyProcessor processor) {
        this.createRegionReplyProcessor = processor;
    }

    @Override
    protected void recordEventStateFromImageProvider(InternalDistributedMember provider) {
        if (this.createRegionReplyProcessor != null) {
            Map<ThreadIdentifier, EventSequenceNumberHolder> providerEventStates = this.createRegionReplyProcessor.getEventState(provider);
            if (providerEventStates != null) {
                this.recordEventState(provider, providerEventStates);
            } else {
                logger.info("Could not initiate event tracker from GII provider {}", (Object)provider);
            }
            this.createRegionReplyProcessor = null;
        }
    }

    @Override
    protected CacheDistributionAdvisor createDistributionAdvisor(InternalRegionArguments internalRegionArgs) {
        return internalRegionArgs.getBucketAdvisor();
    }

    @Override
    public BucketAdvisor getBucketAdvisor() {
        return (BucketAdvisor)this.getDistributionAdvisor();
    }

    @Override
    public boolean isHosting() {
        return this.getBucketAdvisor().isHosting();
    }

    @Override
    protected EventID distributeTombstoneGC(Set<Object> keysRemoved) {
        EventID eventId = super.distributeTombstoneGC(keysRemoved);
        if (keysRemoved != null && keysRemoved.size() > 0 && this.getFilterProfile() != null) {
            PRTombstoneMessage.send(this, keysRemoved, eventId);
        }
        return eventId;
    }

    @Override
    boolean needsTombstoneGCKeysForClients(EventID eventID, FilterRoutingInfo.FilterInfo clientRouting) {
        if (eventID == null) {
            return false;
        }
        if (CacheClientNotifier.getInstance() == null) {
            return false;
        }
        if (clientRouting != null) {
            return true;
        }
        return this.getFilterProfile() != null;
    }

    @Override
    void notifyClientsOfTombstoneGC(Map<VersionSource, Long> regionGCVersions, Set<Object> removedKeys, EventID eventID, FilterRoutingInfo.FilterInfo routing) {
        if (CacheClientNotifier.singletonHasClientProxies()) {
            FilterProfile fp = this.getFilterProfile();
            if (removedKeys != null && !removedKeys.isEmpty() && (routing != null || fp != null && fp.hasInterest())) {
                RegionEventImpl regionEvent = new RegionEventImpl(this.getPartitionedRegion(), Operation.REGION_DESTROY, null, true, this.getMyId());
                FilterRoutingInfo.FilterInfo clientRouting = routing;
                if (clientRouting == null) {
                    clientRouting = fp.getLocalFilterRouting(regionEvent);
                }
                regionEvent.setLocalFilterInfo(clientRouting);
                ClientTombstoneMessage clientMessage = ClientTombstoneMessage.gc((LocalRegion)this.getPartitionedRegion(), removedKeys, eventID);
                CacheClientNotifier.notifyClients(regionEvent, clientMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LockObject searchAndLock(Object[] keys) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        LockObject foundLock = null;
        HashMap<Object, LockObject> hashMap = this.allKeysMap;
        synchronized (hashMap) {
            for (Object key : keys) {
                if (!this.allKeysMap.containsKey(key)) continue;
                foundLock = this.allKeysMap.get(key);
                if (isDebugEnabled) {
                    logger.debug("LockKeys: found key: {}:{}", key, (Object)foundLock.lockedTimeStamp);
                }
                foundLock.waiting();
                break;
            }
            if (foundLock == null) {
                for (Object key : keys) {
                    LockObject lockValue = new LockObject(key, isDebugEnabled ? System.currentTimeMillis() : 0L);
                    this.allKeysMap.put(key, lockValue);
                    if (!isDebugEnabled) continue;
                    logger.debug("LockKeys: add key: {}:{}", key, (Object)lockValue.lockedTimeStamp);
                }
            }
        }
        return foundLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndNotifyKeys(Object[] keys) {
        boolean isTraceEnabled = logger.isTraceEnabled();
        HashMap<Object, LockObject> hashMap = this.allKeysMap;
        synchronized (hashMap) {
            for (Object key : keys) {
                LockObject lockValue = this.allKeysMap.remove(key);
                if (lockValue == null) continue;
                LockObject lockObject = lockValue;
                synchronized (lockObject) {
                    lockValue.setRemoved();
                    if (isTraceEnabled) {
                        long waitTime = System.currentTimeMillis() - lockValue.lockedTimeStamp;
                        logger.trace("LockKeys: remove key {}, notifyAll for {}. It waited {}", key, (Object)lockValue, (Object)waitTime);
                    }
                    if (lockValue.isSomeoneWaiting()) {
                        lockValue.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilLocked(Object[] keys) {
        LockObject foundLock;
        boolean isDebugEnabled = logger.isDebugEnabled();
        String title = "BucketRegion.waitUntilLocked:";
        while ((foundLock = this.searchAndLock(keys)) != null) {
            LockObject lockObject = foundLock;
            synchronized (lockObject) {
                block8: {
                    try {
                        while (!foundLock.isRemoved()) {
                            this.partitionedRegion.checkReadiness();
                            foundLock.wait(1000L);
                            this.checkForPrimary();
                        }
                    }
                    catch (InterruptedException e) {
                        if (!isDebugEnabled) break block8;
                        logger.debug("{} interrupted while waiting for {}", (Object)"BucketRegion.waitUntilLocked:", (Object)foundLock);
                    }
                }
                if (isDebugEnabled) {
                    long waitTime = System.currentTimeMillis() - foundLock.lockedTimeStamp;
                    logger.debug("{} waited {} ms to lock {}", (Object)"BucketRegion.waitUntilLocked:", (Object)waitTime, (Object)foundLock);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed, boolean invokeCallbacks, boolean throwConcurrentModification) throws TimeoutException, CacheWriterException {
        boolean isLocked = this.lockKeysAndPrimary(event);
        try {
            if (this.partitionedRegion.isParallelWanEnabled()) {
                this.handleWANEvent(event);
            }
            if (!this.hasSeenEvent(event)) {
                this.forceSerialized(event);
                RegionEntry oldEntry = this.entries.basicPut(event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue, overwriteDestroyed);
                boolean bl = oldEntry != null;
                return bl;
            }
            if (event.getDeltaBytes() != null && event.getRawNewValue() == null) {
                throw new InvalidDeltaException("Cache encountered replay of event containing delta bytes for key " + event.getKey());
            }
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "BR.virtualPut: this cache has already seen this event {}", (Object)event);
            }
            if (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag()) {
                this.distributeUpdateOperation(event, lastModified);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (isLocked) {
                this.releaseLockForKeysAndPrimary(event);
            }
        }
    }

    long generateTailKey() {
        long key = this.eventSeqNum.addAndGet(this.partitionedRegion.getTotalNumberOfBuckets());
        if (key < 0L || key % (long)this.getPartitionedRegion().getTotalNumberOfBuckets() != (long)this.getId()) {
            logger.error("ERROR! The sequence number {} generated for the bucket {} is incorrect.", new Object[]{key, this.getId()});
        }
        if (logger.isDebugEnabled()) {
            logger.debug("WAN: On primary bucket {}, setting the seq number as {}", (Object)this.getId(), (Object)this.eventSeqNum.get());
        }
        return this.eventSeqNum.get();
    }

    @Override
    public void handleWANEvent(EntryEventImpl event) {
        if (this.eventSeqNum == null && logger.isDebugEnabled()) {
            logger.debug("The bucket corresponding to this user bucket is not created yet. This event will not go to remote wan site. Event: {}", (Object)event);
        }
        if (!(this instanceof AbstractBucketRegionQueue)) {
            if (this.getBucketAdvisor().isPrimary()) {
                long key = this.eventSeqNum.addAndGet(this.partitionedRegion.getTotalNumberOfBuckets());
                if (key < 0L || key % (long)this.getPartitionedRegion().getTotalNumberOfBuckets() != (long)this.getId()) {
                    logger.error("ERROR! The sequence number {} generated for the bucket {} is incorrect.", new Object[]{key, this.getId()});
                }
                event.setTailKey(key);
                if (logger.isDebugEnabled()) {
                    logger.debug("WAN: On primary bucket {}, setting the seq number as {}", (Object)this.getId(), (Object)this.eventSeqNum.get());
                }
            } else {
                Atomics.setIfGreater(this.eventSeqNum, event.getTailKey());
                if (logger.isDebugEnabled()) {
                    logger.debug("WAN: On secondary bucket {}, setting the seq number as {}", (Object)this.getId(), (Object)event.getTailKey());
                }
            }
        }
    }

    void updateEventSeqNum(long l) {
        Atomics.setIfGreater(this.eventSeqNum, l);
        if (logger.isDebugEnabled()) {
            logger.debug("WAN: On bucket {}, setting the seq number as {} before GII", (Object)this.getId(), (Object)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void distributeUpdateOperation(EntryEventImpl event, long lastModified) {
        long token = -1L;
        DistributedCacheOperation op = null;
        try {
            if (!event.isOriginRemote() && !event.isNetSearch() && this.getBucketAdvisor().isPrimary()) {
                if (event.isBulkOpInProgress()) {
                    event.getPutAllOperation().addEntry(event, this.getId());
                } else {
                    op = new UpdateOperation(event, lastModified);
                    token = op.startOperation();
                    if (logger.isDebugEnabled()) {
                        logger.debug("sent update operation : for region  : {}: with event: {}", (Object)this.getName(), (Object)event);
                    }
                }
            }
            if (!event.getOperation().isPutAll()) {
                event.invokeCallbacks(this, true, true);
            }
        }
        finally {
            if (op != null) {
                op.endOperation(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long basicPutPart2(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean clearConflict) {
        long modifiedTime = event.getEventTime(lastModified);
        long token = -1L;
        DistributedCacheOperation op = null;
        try {
            if (this.partitionedRegion.getDataStore().hasClientInterest(event)) {
                this.updateStatsForGet(entry, true);
            }
            if (!event.isOriginRemote()) {
                boolean eventHasDelta;
                VersionTag v;
                if ((event.getVersionTag() == null || event.getVersionTag().isGatewayTag()) && (v = entry.generateVersionTag(null, eventHasDelta = event.getDeltaBytes() != null, this, event)) != null && logger.isDebugEnabled()) {
                    logger.debug("generated version tag {} in region {}", (Object)v, (Object)this.getName());
                }
                if (!event.isBulkOpInProgress()) {
                    long start = this.partitionedRegion.getPrStats().startSendReplication();
                    try {
                        op = new UpdateOperation(event, modifiedTime);
                        token = op.startOperation();
                    }
                    finally {
                        this.partitionedRegion.getPrStats().endSendReplication(start);
                    }
                }
            }
            long l = super.basicPutPart2(event, entry, isInitialized, lastModified, clearConflict);
            return l;
        }
        finally {
            if (op != null) {
                op.endOperation(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyGatewaySender(EnumListenerEvent operation, EntryEventImpl event) {
        InternalRegion bucketRegion = event.getRegion();
        try {
            event.setRegion(this.partitionedRegion);
            this.partitionedRegion.notifyGatewaySender(operation, event);
        }
        finally {
            event.setRegion(bucketRegion);
        }
    }

    public void checkForPrimary() {
        boolean isp = this.getBucketAdvisor().isPrimary();
        if (!isp) {
            this.partitionedRegion.checkReadiness();
            this.checkReadiness();
            InternalDistributedMember primaryHolder = this.getBucketAdvisor().basicGetPrimaryMember();
            throw new PrimaryBucketException("Bucket " + this.getName() + " is not primary. Current primary holder is " + primaryHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean lockKeysAndPrimary(EntryEventImpl event) {
        if (!this.needWriteLock(event)) {
            return false;
        }
        if (this.cache.isCacheAtShutdownAll()) {
            throw this.cache.getCacheClosedException("Cache is shutting down");
        }
        Object[] keys = this.getKeysToBeLocked(event);
        this.waitUntilLocked(keys);
        if (this.wasPrimaryLockedPreviously(event)) {
            return true;
        }
        boolean lockedForPrimary = false;
        try {
            lockedForPrimary = this.doLockForPrimary(false);
            assert (lockedForPrimary) : "expected doLockForPrimary returns true";
            boolean bl = lockedForPrimary;
            return bl;
        }
        finally {
            if (!lockedForPrimary) {
                this.removeAndNotifyKeys(keys);
            }
        }
    }

    Object[] getKeysToBeLocked(EntryEventImpl event) {
        Object[] keys = new Object[]{event.getKey()};
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doLockForPrimary(boolean tryLock) {
        boolean locked = this.lockPrimaryStateReadLock(tryLock);
        if (!locked) {
            return false;
        }
        boolean isPrimary = false;
        try {
            this.checkForPrimary();
            if (this.cache.isCacheAtShutdownAll()) {
                throw this.cache.getCacheClosedException("Cache is shutting down");
            }
            isPrimary = true;
        }
        finally {
            if (!isPrimary) {
                this.doUnlockForPrimary();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockPrimaryStateReadLock(boolean tryLock) {
        Lock primaryMoveReadLock = this.getBucketAdvisor().getPrimaryMoveReadLock();
        Lock parentLock = this.getBucketAdvisor().getParentPrimaryMoveReadLock();
        while (true) {
            boolean interrupted = Thread.interrupted();
            try {
                if (parentLock != null) {
                    boolean locked;
                    if (tryLock) {
                        locked = parentLock.tryLock();
                        if (!locked) {
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        parentLock.lockInterruptibly();
                    }
                    if (tryLock) {
                        locked = primaryMoveReadLock.tryLock();
                        if (!locked) {
                            parentLock.unlock();
                            boolean bl = false;
                            return bl;
                        }
                        break;
                    }
                    primaryMoveReadLock.lockInterruptibly();
                    break;
                }
                if (tryLock) {
                    boolean locked = primaryMoveReadLock.tryLock();
                    if (!locked) {
                        boolean bl = false;
                        return bl;
                    }
                    break;
                }
                primaryMoveReadLock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        return true;
    }

    public void doUnlockForPrimary() {
        Lock primaryMoveReadLock = this.getBucketAdvisor().getPrimaryMoveReadLock();
        primaryMoveReadLock.unlock();
        Lock parentLock = this.getBucketAdvisor().getParentPrimaryMoveReadLock();
        if (parentLock != null) {
            parentLock.unlock();
        }
    }

    void releaseLockForKeysAndPrimary(EntryEventImpl event) {
        if (!this.wasPrimaryLockedPreviously(event)) {
            this.doUnlockForPrimary();
        }
        Object[] keys = this.getKeysToBeLocked(event);
        this.removeAndNotifyKeys(keys);
    }

    protected boolean needWriteLock(EntryEventImpl event) {
        return !event.isOriginRemote() && !event.isNetSearch() && !event.getOperation().isLocal() && !event.getOperation().isPutAll() && !event.getOperation().isRemoveAll() && (!event.isExpiration() || !this.isEntryEvictDestroyEnabled()) && !event.isPendingSecondaryExpireDestroy();
    }

    @Override
    protected void distributeUpdate(EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
    }

    @Override
    public void basicInvalidate(EntryEventImpl event) throws EntryNotFoundException {
        this.basicInvalidate(event, this.isInitialized(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void basicInvalidate(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws EntryNotFoundException {
        block11: {
            Assert.assertTrue(!event.isLocalInvalid());
            Assert.assertTrue(!this.isTX());
            Assert.assertTrue(event.getOperation().isDistributed());
            boolean locked = this.lockKeysAndPrimary(event);
            try {
                if (!this.hasSeenEvent(event)) {
                    if (event.getOperation().isExpiration()) {
                        DistributedSystem sys = this.cache.getDistributedSystem();
                        EventID newID = new EventID(sys);
                        event.setEventId(newID);
                        event.setInvokePRCallbacks(this.getBucketAdvisor().isPrimary());
                    }
                    boolean forceCallbacks = this.isEntryEvictDestroyEnabled();
                    boolean done = this.entries.invalidate(event, invokeCallbacks, forceNewEntry, forceCallbacks);
                    ExpirationAction expirationAction = this.getEntryExpirationAction();
                    if (!done || this.getBucketAdvisor().isPrimary() || expirationAction == null || !expirationAction.isInvalidate()) break block11;
                    Map<Object, ExpiryTask> map = this.pendingSecondaryExpires;
                    synchronized (map) {
                        this.pendingSecondaryExpires.remove(event.getKey());
                        break block11;
                    }
                }
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "LR.basicInvalidate: this cache has already seen this event {}", (Object)event);
                }
                if (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag()) {
                    this.distributeInvalidateOperation(event);
                }
            }
            finally {
                if (locked) {
                    this.releaseLockForKeysAndPrimary(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void distributeInvalidateOperation(EntryEventImpl event) {
        DistributedCacheOperation op = null;
        long token = -1L;
        try {
            if (!event.isOriginRemote() && this.getBucketAdvisor().isPrimary()) {
                op = new InvalidateOperation(event);
                token = op.startOperation();
            }
            event.invokeCallbacks(this, true, false);
        }
        finally {
            if (op != null) {
                op.endOperation(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void basicInvalidatePart2(RegionEntry regionEntry, EntryEventImpl event, boolean conflictWithClear, boolean invokeCallbacks) {
        long token = -1L;
        DistributedCacheOperation op = null;
        try {
            if (!event.isOriginRemote()) {
                if (event.getVersionTag() == null || event.getVersionTag().isGatewayTag()) {
                    VersionTag v = regionEntry.generateVersionTag(null, false, this, event);
                    if (logger.isDebugEnabled() && v != null) {
                        logger.debug("generated version tag {} in region {}", (Object)v, (Object)this.getName());
                    }
                    event.setVersionTag(v);
                }
                op = new InvalidateOperation(event);
                token = op.startOperation();
            }
            super.basicInvalidatePart2(regionEntry, event, conflictWithClear, invokeCallbacks);
        }
        finally {
            if (op != null) {
                op.endOperation(token);
            }
        }
    }

    @Override
    void distributeInvalidate(EntryEventImpl event) {
    }

    @Override
    protected void distributeInvalidateRegion(RegionEventImpl event) {
        event.region = this;
        super.distributeInvalidateRegion(event);
        event.region = this.partitionedRegion;
    }

    @Override
    protected boolean shouldDistributeInvalidateRegion(RegionEventImpl event) {
        return this.getBucketAdvisor().isPrimary();
    }

    @Override
    boolean shouldGenerateVersionTag(RegionEntry entry, EntryEventImpl event) {
        if (event.getOperation().isLocal()) {
            return false;
        }
        return this.getConcurrencyChecksEnabled() && (event.getVersionTag() == null || event.getVersionTag().isGatewayTag());
    }

    @Override
    void expireDestroy(EntryEventImpl event, boolean cacheWrite) {
        if (this.needWriteLock(event) && !this.getBucketAdvisor().isPrimary()) {
            return;
        }
        try {
            super.expireDestroy(event, cacheWrite);
        }
        catch (PrimaryBucketException primaryBucketException) {
            // empty catch block
        }
    }

    @Override
    void expireInvalidate(EntryEventImpl event) {
        if (!this.getBucketAdvisor().isPrimary()) {
            return;
        }
        try {
            super.expireInvalidate(event);
        }
        catch (PrimaryBucketException primaryBucketException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void performExpiryTimeout(ExpiryTask expiryTask) throws CacheException {
        block8: {
            boolean isEvictDestroy = this.isEntryEvictDestroyEnabled();
            this.lockPrimaryStateReadLock(false);
            try {
                if (!this.getBucketAdvisor().isPrimary() && !isEvictDestroy) {
                    Map<Object, ExpiryTask> map = this.pendingSecondaryExpires;
                    synchronized (map) {
                        Object key;
                        if (expiryTask.isPending() && (key = expiryTask.getKey()) != null) {
                            this.pendingSecondaryExpires.put(key, expiryTask);
                        }
                        break block8;
                    }
                }
                super.performExpiryTimeout(expiryTask);
            }
            finally {
                this.doUnlockForPrimary();
            }
        }
    }

    private boolean isEntryEvictDestroyEnabled() {
        return this.getEvictionAttributes() != null && EvictionAction.LOCAL_DESTROY.equals(this.getEvictionAttributes().getAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPendingSecondaryExpires() {
        block10: while (true) {
            ExpiryTask[] tasks;
            Map<Object, ExpiryTask> map = this.pendingSecondaryExpires;
            synchronized (map) {
                if (this.pendingSecondaryExpires.isEmpty()) {
                    return;
                }
                tasks = new ExpiryTask[this.pendingSecondaryExpires.size()];
                tasks = this.pendingSecondaryExpires.values().toArray(tasks);
                this.pendingSecondaryExpires.clear();
            }
            try {
                if (this.isCacheClosing() || this.isClosed() || this.isDestroyed) {
                    return;
                }
                boolean isDebugEnabled = logger.isDebugEnabled();
                ExpiryTask[] expiryTaskArray = tasks;
                int n = expiryTaskArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block10;
                    ExpiryTask task = expiryTaskArray[n2];
                    try {
                        if (isDebugEnabled) {
                            logger.debug("{} fired at {}", (Object)task, (Object)System.currentTimeMillis());
                        }
                        task.basicPerformTimeout(true);
                        if (this.isCacheClosing() || this.isClosed() || this.isDestroyed()) {
                            return;
                        }
                    }
                    catch (EntryNotFoundException entryNotFoundException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            catch (RegionDestroyedException isDebugEnabled) {
                continue;
            }
            catch (CancelException isDebugEnabled) {
                continue;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                logger.fatal("Exception in expiration task", ex);
                continue;
            }
            break;
        }
    }

    @Override
    EntryEventImpl generateEvictDestroyEvent(Object key) {
        EntryEventImpl event = super.generateEvictDestroyEvent(key);
        event.setInvokePRCallbacks(true);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        block12: {
            Assert.assertTrue(!this.isTX());
            Assert.assertTrue(event.getOperation().isDistributed());
            boolean locked = this.lockKeysAndPrimary(event);
            try {
                if (this.partitionedRegion.isParallelWanEnabled()) {
                    this.handleWANEvent(event);
                }
                if (!this.hasSeenEvent(event)) {
                    boolean done;
                    if (event.getOperation().isExpiration()) {
                        DistributedSystem sys = this.cache.getDistributedSystem();
                        if (event.getEventId() == null) {
                            EventID newID = new EventID(sys);
                            event.setEventId(newID);
                        }
                        event.setInvokePRCallbacks(this.getBucketAdvisor().isPrimary());
                    }
                    if (!(done = this.mapDestroy(event, cacheWrite, false, expectedOldValue)) || this.getBucketAdvisor().isPrimary() || !this.isEntryExpiryPossible()) break block12;
                    Map<Object, ExpiryTask> map = this.pendingSecondaryExpires;
                    synchronized (map) {
                        this.pendingSecondaryExpires.remove(event.getKey());
                        break block12;
                    }
                }
                if (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag()) {
                    this.distributeDestroyOperation(event);
                }
            }
            finally {
                if (locked) {
                    this.releaseLockForKeysAndPrimary(event);
                }
            }
        }
    }

    private boolean wasPrimaryLockedPreviously(EntryEventImpl event) {
        return event.getCallbackArgument() instanceof PrimaryMoveReadLockAcquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void distributeDestroyOperation(EntryEventImpl event) {
        long token = -1L;
        DistributedCacheOperation op = null;
        try {
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "BR.basicDestroy: this cache has already seen this event {}", (Object)event);
            }
            if (!event.isOriginRemote() && this.getBucketAdvisor().isPrimary()) {
                if (event.isBulkOpInProgress()) {
                    event.getRemoveAllOperation().addEntry(event, this.getId());
                } else {
                    event.setOldValueFromRegion();
                    op = new DestroyOperation(event);
                    token = op.startOperation();
                }
            }
            if (!event.getOperation().isRemoveAll()) {
                event.invokeCallbacks(this, true, false);
            }
        }
        finally {
            if (op != null) {
                op.endOperation(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicDestroyBeforeRemoval(RegionEntry entry, EntryEventImpl event) {
        long token = -1L;
        DistributedCacheOperation op = null;
        try {
            if (!(event.isOriginRemote() || event.isBulkOpInProgress() || event.getOperation().isLocal() || Operation.EVICT_DESTROY.equals(event.getOperation()) || event.isExpiration() && this.isEntryEvictDestroyEnabled())) {
                if (event.getVersionTag() == null || event.getVersionTag().isGatewayTag()) {
                    VersionTag v = entry.generateVersionTag(null, false, this, event);
                    if (logger.isDebugEnabled() && v != null) {
                        logger.debug("generated version tag {} in region {}", (Object)v, (Object)this.getName());
                    }
                }
                op = new DestroyOperation(event);
                token = op.startOperation();
            }
            super.basicDestroyBeforeRemoval(entry, event);
        }
        finally {
            if (op != null) {
                op.endOperation(token);
            }
        }
    }

    @Override
    void distributeDestroy(EntryEventImpl event, Object expectedOldValue) {
    }

    @Override
    void validateArguments(Object key, Object value, Object aCallbackArgument) {
        Assert.assertTrue(!this.isTX());
        super.validateArguments(key, value, aCallbackArgument);
    }

    public void forceSerialized(EntryEventImpl event) {
        event.makeSerializedNewValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    RegionEntry basicPutEntry(EntryEventImpl event, long lastModified) throws TimeoutException, CacheWriterException {
        boolean locked = this.lockKeysAndPrimary(event);
        try {
            if (this.getPartitionedRegion().isParallelWanEnabled()) {
                this.handleWANEvent(event);
            }
            event.setInvokePRCallbacks(true);
            this.forceSerialized(event);
            RegionEntry regionEntry = super.basicPutEntry(event, lastModified);
            return regionEntry;
        }
        finally {
            if (locked) {
                this.releaseLockForKeysAndPrimary(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void basicUpdateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        Assert.assertTrue(!this.isTX());
        Assert.assertTrue(event.getOperation().isDistributed());
        InternalRegion internalRegion = event.getRegion();
        AbstractRegionMap arm = (AbstractRegionMap)internalRegion.getRegionMap();
        arm.lockForCacheModification(internalRegion, event);
        boolean locked = internalRegion.lockWhenRegionIsInitializing();
        try {
            boolean keysAndPrimaryLocked = this.lockKeysAndPrimary(event);
            try {
                if (!this.hasSeenEvent(event)) {
                    this.entries.updateEntryVersion(event);
                } else if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "BR.basicUpdateEntryVersion: this cache has already seen this event {}", (Object)event);
                }
                if (!event.isOriginRemote() && this.getBucketAdvisor().isPrimary() && (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag())) {
                    this.distributeUpdateEntryVersionOperation(event);
                }
            }
            finally {
                if (keysAndPrimaryLocked) {
                    this.releaseLockForKeysAndPrimary(event);
                }
            }
        }
        finally {
            if (locked) {
                internalRegion.unlockWhenRegionIsInitializing();
            }
            arm.releaseCacheModificationLock(event.getRegion(), event);
        }
    }

    protected void distributeUpdateEntryVersionOperation(EntryEventImpl event) {
        new UpdateEntryVersionOperation(event).distribute();
    }

    public int getRedundancyLevel() {
        return this.redundancy;
    }

    @Override
    public boolean isPrimary() {
        throw new UnsupportedOperationException(String.format("This should never be called on %s", this.getClass()));
    }

    @Override
    public boolean isDestroyed() {
        return this.isBucketDestroyed() || this.partitionedRegion != null && this.partitionedRegion.isLocallyDestroyed && !this.isInDestroyingThread();
    }

    public boolean isBucketDestroyed() {
        return super.isDestroyed();
    }

    @Override
    int sizeEstimate() {
        return this.size();
    }

    @Override
    public void checkReadiness() {
        super.checkReadiness();
        if (this.isDestroyed()) {
            throw new RegionDestroyedException(this.toString(), this.getFullPath());
        }
    }

    @Override
    public PartitionedRegion getPartitionedRegion() {
        return this.partitionedRegion;
    }

    private boolean isInDestroyingThread() {
        return this.partitionedRegion.locallyDestroyingThread == Thread.currentThread();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        super.fillInProfile(profile);
        BucketAdvisor.BucketProfile bp = (BucketAdvisor.BucketProfile)profile;
        bp.isInitializing = this.getInitializationLatchAfterGetInitialImage().getCount() > 0L;
    }

    boolean isPartitionedRegionOpen() {
        return !this.partitionedRegion.isLocallyDestroyed && !this.partitionedRegion.isClosed && !this.partitionedRegion.isDestroyed();
    }

    private RawValue getSerialized(Object key, boolean updateStats, boolean doNotLockEntry, EntryEventImpl clientEvent, boolean returnTombstones) throws EntryNotFoundException {
        Object v;
        RegionEntry re = this.entries.getEntry(key);
        if (re == null) {
            return NULLVALUE;
        }
        if (re.isTombstone() && !returnTombstones) {
            return NULLVALUE;
        }
        try {
            VersionStamp stamp;
            v = re.getValue(this);
            if (doNotLockEntry && (v == Token.NOT_AVAILABLE || v == null)) {
                return REQUIRES_ENTRY_LOCK;
            }
            if (clientEvent != null && (stamp = re.getVersionStamp()) != null) {
                clientEvent.setVersionTag(stamp.asVersionTag());
            }
        }
        catch (DiskAccessException dae) {
            this.handleDiskAccessException(dae);
            throw dae;
        }
        if (v == null) {
            return NULLVALUE;
        }
        if (updateStats) {
            this.updateStatsForGet(re, true);
        }
        return new RawValue(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawValue getSerialized(KeyInfo keyInfo, boolean generateCallbacks, boolean doNotLockEntry, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws IOException {
        this.checkReadiness();
        this.checkForNoAccess();
        CachePerfStats stats = this.getCachePerfStats();
        long start = stats.startGet();
        boolean miss = true;
        try {
            RawValue result = this.getSerialized(keyInfo.getKey(), true, doNotLockEntry, clientEvent, returnTombstones);
            boolean isCreate = result == NULLVALUE || result.getRawValue() == Token.TOMBSTONE && !returnTombstones;
            boolean bl = miss = result == NULLVALUE || Token.isInvalid(result.getRawValue());
            if (miss) {
                if (this.hasServerProxy() || this.basicGetLoader() != null) {
                    if (doNotLockEntry) {
                        RawValue rawValue = REQUIRES_ENTRY_LOCK;
                        return rawValue;
                    }
                    Object value = this.nonTxnFindObject(keyInfo, isCreate, generateCallbacks, result.getRawValue(), true, true, requestingClient, clientEvent, false);
                    if (value != null) {
                        result = new RawValue(value);
                    }
                } else if (isCreate) {
                    this.recordMiss(null, keyInfo.getKey());
                }
            }
            RawValue rawValue = result;
            return rawValue;
        }
        finally {
            stats.endGet(start, miss);
        }
    }

    @Override
    public String toString() {
        return "BucketRegion[path='" + this.getFullPath() + ";serial=" + this.getSerialNumber() + ";primary=" + this.getBucketAdvisor().getProxyBucketRegion().isPrimary() + "]";
    }

    @Override
    protected void distributedRegionCleanup(RegionEventImpl event) {
        this.distAdvisor.removeMembershipListener(this.advisorListener);
    }

    void removeFromPeersAdvisors(boolean rebalance) {
        if (this.getPersistenceAdvisor() != null) {
            this.getPersistenceAdvisor().releaseTieLock();
        }
        DiskRegion diskRegion = this.getDiskRegion();
        boolean shouldDestroy = rebalance || diskRegion == null || !diskRegion.isRecreated();
        Operation op = shouldDestroy ? Operation.REGION_LOCAL_DESTROY : Operation.REGION_CLOSE;
        RegionEventImpl event = new RegionEventImpl((Region)this, op, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
        if (this.isPartitionedRegionOpen()) {
            if (diskRegion != null && shouldDestroy) {
                diskRegion.beginDestroyDataStorage();
            }
            new DestroyRegionOperation(event, true).distribute();
        }
    }

    @Override
    void distributeDestroyRegion(RegionEventImpl event, boolean notifyOfRegionDeparture) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntryEventImpl createEventForPR(EntryEventImpl sourceEvent) {
        EntryEventImpl e2 = new EntryEventImpl(sourceEvent);
        boolean returned = false;
        try {
            e2.setRegion(this.partitionedRegion);
            if (FORCE_LOCAL_LISTENERS_INVOCATION) {
                e2.setInvokePRCallbacks(true);
            } else {
                e2.setInvokePRCallbacks(sourceEvent.getInvokePRCallbacks());
            }
            InternalDistributedMember dm = this.getDistributionManager().getDistributionManagerId();
            e2.setOriginRemote(!e2.getDistributedMember().equals(dm));
            returned = true;
            EntryEventImpl entryEventImpl = e2;
            return entryEventImpl;
        }
        finally {
            if (!returned) {
                e2.release();
            }
        }
    }

    private boolean skipPrEvent(EntryEventImpl event, boolean callDispatchListenerEvent) {
        boolean needsPrEvent;
        if (!event.isGenerateCallbacks()) {
            return true;
        }
        boolean bl = needsPrEvent = this.partitionedRegion.isInitialized() && callDispatchListenerEvent && this.partitionedRegion.shouldDispatchListenerEvent() || CacheClientNotifier.singletonHasClientProxies();
        return !needsPrEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeTXCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent) {
        if (logger.isDebugEnabled()) {
            logger.debug("BR.invokeTXCallbacks for event {}", (Object)event);
        }
        if (this.isInitialized()) {
            boolean callThem = callDispatchListenerEvent;
            if (event.isPossibleDuplicate() && this.getEventTracker().isInitialImageProvider(event.getDistributedMember())) {
                callThem = false;
            }
            super.invokeTXCallbacks(eventType, event, callThem);
        }
        if (this.skipPrEvent(event, callDispatchListenerEvent)) {
            return;
        }
        EntryEventImpl prEvent = this.createEventForPR(event);
        try {
            this.partitionedRegion.invokeTXCallbacks(eventType, prEvent, this.partitionedRegion.isInitialized() && callDispatchListenerEvent);
        }
        finally {
            prEvent.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeDestroyCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent, boolean notifyGateways) {
        if (this.isInitialized()) {
            boolean callThem = callDispatchListenerEvent;
            if (event.isPossibleDuplicate() && this.getEventTracker().isInitialImageProvider(event.getDistributedMember())) {
                callThem = false;
            }
            super.invokeDestroyCallbacks(eventType, event, callThem, notifyGateways);
        }
        if (this.skipPrEvent(event, callDispatchListenerEvent)) {
            return;
        }
        EntryEventImpl prEvent = this.createEventForPR(event);
        try {
            this.partitionedRegion.invokeDestroyCallbacks(eventType, prEvent, this.partitionedRegion.isInitialized() && callDispatchListenerEvent, false);
        }
        finally {
            prEvent.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeInvalidateCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent) {
        if (this.isInitialized()) {
            boolean callThem = callDispatchListenerEvent;
            if (event.isPossibleDuplicate() && this.getEventTracker().isInitialImageProvider(event.getDistributedMember())) {
                callThem = false;
            }
            super.invokeInvalidateCallbacks(eventType, event, callThem);
        }
        if (this.skipPrEvent(event, callDispatchListenerEvent)) {
            return;
        }
        EntryEventImpl prEvent = this.createEventForPR(event);
        try {
            this.partitionedRegion.invokeInvalidateCallbacks(eventType, prEvent, this.partitionedRegion.isInitialized() && callDispatchListenerEvent);
        }
        finally {
            prEvent.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokePutCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent, boolean notifyGateways) {
        if (logger.isTraceEnabled()) {
            logger.trace("invoking put callbacks on bucket for event {}", (Object)event);
        }
        if (this.isInitialized()) {
            boolean callThem = callDispatchListenerEvent;
            if (callThem && event.isPossibleDuplicate() && this.getEventTracker().isInitialImageProvider(event.getDistributedMember())) {
                callThem = false;
            }
            super.invokePutCallbacks(eventType, event, callThem, notifyGateways);
        }
        if (this.skipPrEvent(event, callDispatchListenerEvent)) {
            return;
        }
        EntryEventImpl prEvent = this.createEventForPR(event);
        try {
            this.partitionedRegion.invokePutCallbacks(eventType, prEvent, this.partitionedRegion.isInitialized() && callDispatchListenerEvent, false);
        }
        finally {
            prEvent.release();
        }
    }

    void performAdjunctMessaging(EntryEventImpl event, Set cacheOpRecipients, Set adjunctRecipients, FilterRoutingInfo filterRoutingInfo, DirectReplyProcessor processor, boolean calculateDelta, boolean sendDeltaWithFullValue) {
        PartitionMessage msg = event.getPartitionMessage();
        if (calculateDelta) {
            this.setDeltaIfNeeded(event);
        }
        if (msg != null) {
            msg = msg.getMessageForRelayToListeners(event, adjunctRecipients);
            msg.setSender(this.partitionedRegion.getDistributionManager().getDistributionManagerId());
            msg.setSendDeltaWithFullValue(sendDeltaWithFullValue);
            msg.relayToListeners(cacheOpRecipients, adjunctRecipients, filterRoutingInfo, event, this.partitionedRegion, processor);
        } else {
            Operation op = event.getOperation();
            if (op.isCreate() || op.isUpdate()) {
                PutMessage.notifyListeners(cacheOpRecipients, adjunctRecipients, filterRoutingInfo, this.partitionedRegion, event, op.isCreate(), !op.isCreate(), processor, sendDeltaWithFullValue);
            } else if (op.isDestroy()) {
                DestroyMessage.notifyListeners(cacheOpRecipients, adjunctRecipients, filterRoutingInfo, this.partitionedRegion, event, processor);
            } else if (op.isInvalidate()) {
                InvalidateMessage.notifyListeners(cacheOpRecipients, adjunctRecipients, filterRoutingInfo, this.partitionedRegion, event, processor);
            }
        }
    }

    private void setDeltaIfNeeded(EntryEventImpl event) {
        if (this.partitionedRegion.getSystem().getConfig().getDeltaPropagation() && event.getOperation().isUpdate() && event.getDeltaBytes() == null) {
            Object rawNewValue = event.getRawNewValue();
            if (!(rawNewValue instanceof CachedDeserializable)) {
                return;
            }
            CachedDeserializable cd = (CachedDeserializable)rawNewValue;
            if (!cd.isSerialized()) {
                return;
            }
            Object instance = cd.getValue();
            if (instance instanceof Delta && ((Delta)instance).hasDelta()) {
                try (HeapDataOutputStream hdos = new HeapDataOutputStream(KnownVersion.CURRENT);){
                    long start = DistributionStats.getStatTime();
                    ((Delta)instance).toDelta(hdos);
                    event.setDeltaBytes(hdos.toByteArray());
                    this.partitionedRegion.getCachePerfStats().endDeltaPrepared(start);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new DeltaSerializationException("Caught exception while sending delta. ", e);
                }
            }
        }
    }

    void performPutAllAdjunctMessaging(DistributedPutAllOperation dpao, Set cacheOpRecipients, Set<InternalDistributedMember> adjunctRecipients, FilterRoutingInfo filterRoutingInfo, DirectReplyProcessor processor) {
        PutAllPRMessage prMsg = dpao.createPRMessagesNotifyOnly(this.getId());
        prMsg.initMessage(this.partitionedRegion, adjunctRecipients, true, processor);
        prMsg.setSender(this.partitionedRegion.getDistributionManager().getDistributionManagerId());
        this.partitionedRegion.getDistributionManager().putOutgoing(prMsg);
    }

    void performRemoveAllAdjunctMessaging(DistributedRemoveAllOperation op, Set cacheOpRecipients, Set<InternalDistributedMember> adjunctRecipients, FilterRoutingInfo filterRoutingInfo, DirectReplyProcessor processor) {
        RemoveAllPRMessage prMsg = op.createPRMessagesNotifyOnly(this.getId());
        prMsg.initMessage(this.partitionedRegion, adjunctRecipients, true, processor);
        prMsg.setSender(this.partitionedRegion.getDistributionManager().getDistributionManagerId());
        this.partitionedRegion.getDistributionManager().putOutgoing(prMsg);
    }

    protected Set<InternalDistributedMember> getAdjunctReceivers(EntryEventImpl event, Set<InternalDistributedMember> cacheOpReceivers, Set<InternalDistributedMember> twoMessages, FilterRoutingInfo routing) {
        Operation op = event.getOperation();
        if (op == null) {
            return Collections.emptySet();
        }
        if (op.isUpdate() || op.isCreate() || op.isDestroy() || op.isInvalidate()) {
            Set<InternalDistributedMember> r = this.partitionedRegion.getRegionAdvisor().adviseRequiresNotification();
            r.removeAll(cacheOpReceivers);
            if (twoMessages.size() > 0) {
                if (r.size() == 0) {
                    r = twoMessages;
                } else {
                    r.addAll(twoMessages);
                }
            }
            if (routing != null) {
                for (InternalDistributedMember id : routing.getMembers()) {
                    if (cacheOpReceivers.contains(id)) continue;
                    if (r.isEmpty()) {
                        r = new HashSet<InternalDistributedMember>();
                    }
                    r.add(id);
                }
            }
            return r;
        }
        return Collections.emptySet();
    }

    @Override
    public int getId() {
        return this.getBucketAdvisor().getProxyBucketRegion().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheWriteBeforePut(EntryEventImpl event, Set netWriteRecipients, CacheWriter localWriter, boolean requireOldValue, Object expectedOldValue) throws CacheWriterException, TimeoutException {
        boolean origRemoteState = false;
        try {
            if (event.getPartitionMessage() != null || event.hasClientOrigin()) {
                origRemoteState = event.isOriginRemote();
                event.setOriginRemote(true);
            }
            event.setRegion(this.partitionedRegion);
            this.partitionedRegion.cacheWriteBeforePut(event, netWriteRecipients, localWriter, requireOldValue, expectedOldValue);
        }
        finally {
            if (event.getPartitionMessage() != null || event.hasClientOrigin()) {
                event.setOriginRemote(origRemoteState);
            }
            event.setRegion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cacheWriteBeforeDestroy(EntryEventImpl event, Object expectedOldValue) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        boolean origRemoteState = false;
        try {
            if (event.getPartitionMessage() != null || event.hasClientOrigin()) {
                origRemoteState = event.isOriginRemote();
                event.setOriginRemote(true);
            }
            event.setRegion(this.partitionedRegion);
            boolean bl = this.partitionedRegion.cacheWriteBeforeDestroy(event, expectedOldValue);
            return bl;
        }
        finally {
            if (event.getPartitionMessage() != null || event.hasClientOrigin()) {
                event.setOriginRemote(origRemoteState);
            }
            event.setRegion(this);
        }
    }

    @Override
    public CacheWriter basicGetWriter() {
        return this.partitionedRegion.basicGetWriter();
    }

    @Override
    public Set<InternalDistributedMember> getBucketOwners() {
        return this.getBucketAdvisor().getProxyBucketRegion().getBucketOwners();
    }

    public long getCounter() {
        return this.counter.get();
    }

    public void setCounter(AtomicLong counter) {
        this.counter = counter;
    }

    void updateCounter(long delta) {
        if (delta != 0L) {
            this.counter.getAndAdd(delta);
        }
    }

    public void resetCounter() {
        if (this.counter.get() != 0L) {
            this.counter.set(0L);
        }
    }

    public long getLimit() {
        if (this.limit == null) {
            return 0L;
        }
        return this.limit.get();
    }

    public void setLimit(long limit) {
        if (this.limit == null) {
            this.limit = new AtomicLong();
        }
        this.limit.set(limit);
    }

    private static int calcMemSize(Object value) {
        if (value == null || value instanceof Token) {
            return 0;
        }
        if (!(value instanceof byte[] || value instanceof CachedDeserializable || value instanceof Delta || value instanceof GatewaySenderEventImpl)) {
            throw new InternalGemFireError("DEBUG: calcMemSize: weird value (class " + value.getClass() + "): " + value);
        }
        try {
            return CachedDeserializableFactory.calcMemSize(value);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    @Override
    void updateSizeOnClearRegion(int sizeBeforeClear) {
        long oldMemValue;
        PartitionedRegionDataStore prDs = this.partitionedRegion.getDataStore();
        if (this.isDestroyed || this.isDestroyingDiskRegion) {
            oldMemValue = this.bytesInMemory.getAndSet(Long.MIN_VALUE);
        } else if (!this.isInitialized()) {
            oldMemValue = this.bytesInMemory.getAndSet(0L);
        } else {
            throw new InternalGemFireError("Trying to clear a bucket region that was not destroyed or in initialization.");
        }
        if (oldMemValue != Long.MIN_VALUE) {
            this.partitionedRegion.getPrStats().incDataStoreEntryCount(-sizeBeforeClear);
            prDs.updateMemoryStats(-oldMemValue);
        }
    }

    @Override
    public int calculateValueSize(Object value) {
        return BucketRegion.calcMemSize(value);
    }

    @Override
    public int calculateRegionEntryValueSize(RegionEntry regionEntry) {
        return BucketRegion.calcMemSize(regionEntry.getValue());
    }

    @Override
    public void updateSizeOnPut(Object key, int oldSize, int newSize) {
        this.updateBucket2Size(oldSize, newSize, SizeOp.UPDATE);
    }

    @Override
    public void updateSizeOnCreate(Object key, int newSize) {
        this.partitionedRegion.getPrStats().incDataStoreEntryCount(1);
        this.updateBucket2Size(0, newSize, SizeOp.CREATE);
    }

    @Override
    public void updateSizeOnRemove(Object key, int oldSize) {
        this.partitionedRegion.getPrStats().incDataStoreEntryCount(-1);
        this.updateBucket2Size(oldSize, 0, SizeOp.DESTROY);
    }

    @Override
    public int updateSizeOnEvict(Object key, int oldSize) {
        this.updateBucket2Size(oldSize, oldSize, SizeOp.EVICT);
        return oldSize;
    }

    @Override
    public void updateSizeOnFaultIn(Object key, int newMemSize, int oldDiskSize) {
        this.updateBucket2Size(oldDiskSize, newMemSize, SizeOp.FAULT_IN);
    }

    @Override
    public void initializeStats(long numEntriesInVM, long numOverflowOnDisk, long numOverflowBytesOnDisk) {
        super.initializeStats(numEntriesInVM, numOverflowOnDisk, numOverflowBytesOnDisk);
        this.incNumEntriesInVM(numEntriesInVM);
        this.incNumOverflowOnDisk(numOverflowOnDisk);
        this.incNumOverflowBytesOnDisk(numOverflowBytesOnDisk);
    }

    @Override
    void setMemoryThresholdFlag(MemoryEvent event) {
        Assert.assertTrue(false);
    }

    @Override
    void initialCriticalMembers(boolean localHeapIsCritical, Set<InternalDistributedMember> criticalMembers) {
    }

    @Override
    void closeCallbacksExceptListener() {
        this.closeCacheCallback(this.getCacheWriter());
        EvictionController evictionController = this.getEvictionController();
        if (evictionController != null) {
            evictionController.closeBucket(this);
        }
    }

    public long getTotalBytes() {
        long result = this.bytesInMemory.get();
        if (result == Long.MIN_VALUE) {
            return 0L;
        }
        return result += this.getNumOverflowBytesOnDisk();
    }

    public long getBytesInMemory() {
        long result = this.bytesInMemory.get();
        if (result == Long.MIN_VALUE) {
            return 0L;
        }
        return result;
    }

    void preDestroyBucket(int bucketId) {
    }

    @Override
    public void cleanupFailedInitialization() {
        this.preDestroyBucket(this.getId());
        super.cleanupFailedInitialization();
    }

    void invokePartitionListenerAfterBucketRemoved() {
        PartitionListener[] partitionListeners = this.getPartitionedRegion().getPartitionListeners();
        if (partitionListeners == null || partitionListeners.length == 0) {
            return;
        }
        for (PartitionListener listener : partitionListeners) {
            if (listener == null) continue;
            listener.afterBucketRemoved(this.getId(), this.keySet());
        }
    }

    void invokePartitionListenerAfterBucketCreated() {
        PartitionListener[] partitionListeners = this.getPartitionedRegion().getPartitionListeners();
        if (partitionListeners == null || partitionListeners.length == 0) {
            return;
        }
        for (PartitionListener listener : partitionListeners) {
            if (listener == null) continue;
            listener.afterBucketCreated(this.getId(), this.keySet());
        }
    }

    private void updateBucket2Size(int oldSize, int newSize, SizeOp op) {
        int memoryDelta = op.computeMemoryDelta(oldSize, newSize);
        if (memoryDelta == 0) {
            return;
        }
        this.updateBucketMemoryStats(memoryDelta);
    }

    private void updateBucketMemoryStats(int memoryDelta) {
        if (memoryDelta != 0) {
            long bSize = this.bytesInMemory.compareAddAndGet(Long.MIN_VALUE, memoryDelta);
            if (bSize == Long.MIN_VALUE) {
                return;
            }
            if (bSize < 0L && !this.getCancelCriterion().isCancelInProgress()) {
                throw new InternalGemFireError("Bucket " + this + " size (" + bSize + ") negative after applying delta of " + memoryDelta);
            }
        }
        PartitionedRegionDataStore prDS = this.partitionedRegion.getDataStore();
        prDS.updateMemoryStats(memoryDelta);
    }

    public long getNumOverflowOnDisk() {
        return this.numOverflowOnDisk.get();
    }

    public long getNumOverflowBytesOnDisk() {
        return this.numOverflowBytesOnDisk.get();
    }

    public long getNumEntriesInVM() {
        return this.numEntriesInVM.get();
    }

    public void incNumOverflowOnDisk(long delta) {
        this.numOverflowOnDisk.addAndGet(delta);
    }

    public void incNumOverflowBytesOnDisk(long delta) {
        if (delta == 0L) {
            return;
        }
        this.numOverflowBytesOnDisk.addAndGet(delta);
    }

    public void incNumEntriesInVM(long delta) {
        this.numEntriesInVM.addAndGet(delta);
    }

    @Override
    void incBucketEvictions() {
        this.evictions.getAndAdd(1L);
    }

    public long getBucketEvictions() {
        return this.evictions.get();
    }

    @Override
    boolean isMemoryThresholdReachedForLoad() {
        return this.getBucketAdvisor().getProxyBucketRegion().isBucketSick();
    }

    public int getSizeForEviction() {
        EvictionAttributes ea = this.getAttributes().getEvictionAttributes();
        if (ea == null) {
            return 0;
        }
        EvictionAlgorithm algo = ea.getAlgorithm();
        if (!algo.isLRUHeap()) {
            return 0;
        }
        EvictionAction action = ea.getAction();
        return action.isLocalDestroy() ? this.getRegionMap().sizeInVM() : (int)this.getNumEntriesInVM();
    }

    @Override
    HashMap getDestroyedSubregionSerialNumbers() {
        return new HashMap(0);
    }

    @Override
    public FilterProfile getFilterProfile() {
        return this.partitionedRegion.getFilterProfile();
    }

    @Override
    public void setCloningEnabled(boolean isCloningEnabled) {
        this.partitionedRegion.setCloningEnabled(isCloningEnabled);
    }

    @Override
    public boolean getCloningEnabled() {
        return this.partitionedRegion.getCloningEnabled();
    }

    @Override
    void generateLocalFilterRouting(InternalCacheEvent event) {
        if (event.getLocalFilterInfo() == null) {
            super.generateLocalFilterRouting(event);
        }
    }

    public void beforeAcquiringPrimaryState() {
    }

    public void afterAcquiringPrimaryState() {
    }

    void beforeReleasingPrimaryLockDuringDemotion() {
    }

    @Override
    public RegionAttributes getAttributes() {
        return this;
    }

    @Override
    public boolean notifiesSerialGatewaySender() {
        return this.getPartitionedRegion().notifiesSerialGatewaySender();
    }

    @Override
    public boolean hasSeenEvent(EntryEventImpl event) {
        this.ensureEventTrackerInitialization();
        return super.hasSeenEvent(event);
    }

    private void ensureEventTrackerInitialization() {
        try {
            this.getEventTracker().waitOnInitialization();
        }
        catch (InterruptedException ie) {
            this.getCancelCriterion().checkCancelInProgress(ie);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected void postDestroyRegion(boolean destroyDiskRegion, RegionEventImpl event) {
        DiskRegion dr = this.getDiskRegion();
        if (dr != null && destroyDiskRegion) {
            dr.statsClear(this);
        }
        super.postDestroyRegion(destroyDiskRegion, event);
    }

    @Override
    public EvictionController getExistingController(InternalRegionArguments internalArgs) {
        return internalArgs.getPartitionedRegion().getEvictionController();
    }

    @Override
    public String getNameForStats() {
        return this.getPartitionedRegion().getFullPath();
    }

    @Override
    public void closeEntries() {
        this.entries.close(this);
    }

    @Override
    public Set<VersionSource> clearEntries(RegionVersionVector rvv) {
        return this.entries.clear(rvv, this);
    }

    @Override
    SenderIdMonitor createSenderIdMonitor() {
        return null;
    }

    @Override
    void updateSenderIdMonitor() {
    }

    @Override
    void checkSameSenderIdsAvailableOnAllNodes() {
    }

    static enum SizeOp {
        UPDATE,
        CREATE,
        DESTROY,
        EVICT,
        FAULT_IN;


        int computeMemoryDelta(int oldSize, int newSize) {
            switch (this) {
                case CREATE: {
                    return newSize;
                }
                case DESTROY: {
                    return -oldSize;
                }
                case UPDATE: {
                    return newSize - oldSize;
                }
                case EVICT: {
                    return -oldSize;
                }
                case FAULT_IN: {
                    return newSize;
                }
            }
            throw new AssertionError((Object)("unhandled sizeOp: " + (Object)((Object)this)));
        }
    }

    public static class PrimaryMoveReadLockAcquired
    implements Serializable {
    }

    public static class RawValue {
        private final Object rawValue;

        public RawValue(Object rawVal) {
            this.rawValue = rawVal;
        }

        public boolean isValueByteArray() {
            return this.rawValue instanceof byte[];
        }

        public Object getRawValue() {
            return this.rawValue;
        }

        public void writeAsByteArray(DataOutput out) throws IOException {
            if (this.isValueByteArray()) {
                DataSerializer.writeByteArray((byte[])this.rawValue, out);
            } else if (this.rawValue instanceof CachedDeserializable) {
                ((CachedDeserializable)this.rawValue).writeValueAsByteArray(out);
            } else if (Token.isInvalid(this.rawValue)) {
                DataSerializer.writeByteArray(null, out);
            } else if (this.rawValue == Token.TOMBSTONE) {
                DataSerializer.writeByteArray(null, out);
            } else {
                DataSerializer.writeObjectAsByteArray(this.rawValue, out);
            }
        }

        public String toString() {
            return "RawValue(" + this.rawValue + ")";
        }

        public Object getDeserialized(boolean copyOnRead) {
            if (this.isValueByteArray()) {
                if (copyOnRead) {
                    byte[] src = (byte[])this.rawValue;
                    byte[] dest = new byte[src.length];
                    System.arraycopy(this.rawValue, 0, dest, 0, dest.length);
                    return dest;
                }
                return this.rawValue;
            }
            if (this.rawValue instanceof CachedDeserializable) {
                if (copyOnRead) {
                    return ((CachedDeserializable)this.rawValue).getDeserializedWritableCopy(null, null);
                }
                return ((CachedDeserializable)this.rawValue).getDeserializedForReading();
            }
            if (Token.isInvalid(this.rawValue)) {
                return null;
            }
            if (copyOnRead) {
                return CopyHelper.copy(this.rawValue);
            }
            return this.rawValue;
        }
    }
}

