/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import org.apache.geode.CancelException;
import org.apache.geode.IncompatibleSystemException;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.OperationCancelledException;
import org.apache.geode.admin.RuntimeAdminException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.admin.Alert;
import org.apache.geode.internal.admin.AlertListener;
import org.apache.geode.internal.admin.ApplicationVM;
import org.apache.geode.internal.admin.CacheCollector;
import org.apache.geode.internal.admin.CacheSnapshot;
import org.apache.geode.internal.admin.GfManagerAgent;
import org.apache.geode.internal.admin.GfManagerAgentConfig;
import org.apache.geode.internal.admin.JoinLeaveListener;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.AdminWaiters;
import org.apache.geode.internal.admin.remote.AlertLevelChangeMessage;
import org.apache.geode.internal.admin.remote.RemoteApplicationVM;
import org.apache.geode.internal.admin.remote.RemoteGemFireVM;
import org.apache.geode.internal.admin.remote.RemoteTransportConfig;
import org.apache.geode.internal.admin.remote.SnapshotResultMessage;
import org.apache.geode.internal.admin.remote.VersionMismatchAlert;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogWriterFactory;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.logging.log4j.Logger;

public class RemoteGfManagerAgent
implements GfManagerAgent {
    private static final Logger logger = LogService.getLogger();
    private volatile InternalDistributedSystem system;
    private final Object systemLock = new Object();
    private volatile boolean connected;
    private volatile boolean listening = true;
    private DSConnectionDaemon daemon;
    private final AlertListener alertListener;
    private int alertLevel;
    private final RemoteTransportConfig transport;
    private final String displayName;
    private volatile Set<JoinLeaveListener> listeners = Collections.emptySet();
    private final Object listenersLock = new Object();
    private CacheCollector collector;
    private volatile Map<InternalDistributedMember, Future<RemoteApplicationVM>> membersMap = Collections.emptyMap();
    private final Object membersLock = new Object();
    private final InternalLogWriter securityLogWriter;
    private final BlockingQueue<SnapshotResultMessage> snapshotResults = new LinkedBlockingQueue<SnapshotResultMessage>();
    private final SnapshotResultDispatcher snapshotDispatcher;
    private final JoinProcessor joinProcessor;
    private volatile List<InternalDistributedMember> pendingJoins = Collections.emptyList();
    private final Object pendingJoinsLock = new Object();
    private volatile InternalDistributedMember currentJoin;
    private volatile boolean abortCurrentJoin;
    private volatile boolean initialized;
    private boolean disconnected;
    private MyMembershipListener myMembershipListener;
    private final Object myMembershipListenerLock = new Object();
    private final InternalDistributedSystem.DisconnectListener disconnectListener;
    private static final Object enumerationSync = new Object();
    @MakeNotStatic
    private static volatile List<RemoteGfManagerAgent> allAgents = new ArrayList<RemoteGfManagerAgent>();
    private static final ThreadLocal<Boolean> sending = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final Function<Properties, InternalDistributedSystem> distributedSystemFactory;
    private final Function<RemoteGfManagerAgent, DSConnectionDaemon> dsConnectionDaemonFactory;
    private final Function<RemoteGfManagerAgent, MyMembershipListener> myMembershipListenerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAgent(RemoteGfManagerAgent toAdd) {
        Object object = enumerationSync;
        synchronized (object) {
            ArrayList<RemoteGfManagerAgent> replace = new ArrayList<RemoteGfManagerAgent>(allAgents);
            replace.add(toAdd);
            allAgents = replace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAgent(RemoteGfManagerAgent toRemove) {
        Object object = enumerationSync;
        synchronized (object) {
            ArrayList<RemoteGfManagerAgent> replace = new ArrayList<RemoteGfManagerAgent>(allAgents);
            replace.remove(toRemove);
            allAgents = replace;
        }
    }

    public static void emergencyClose() {
        List<RemoteGfManagerAgent> members = allAgents;
        Iterator<RemoteGfManagerAgent> iterator = members.iterator();
        while (iterator.hasNext()) {
            RemoteGfManagerAgent member;
            RemoteGfManagerAgent each = member = iterator.next();
            each.system.emergencyClose();
        }
    }

    public RemoteGfManagerAgent(GfManagerAgentConfig cfg) {
        this(cfg, props -> (InternalDistributedSystem)InternalDistributedSystem.connectForAdmin(props), x$0 -> new JoinProcessor((RemoteGfManagerAgent)x$0), x$0 -> new SnapshotResultDispatcher((RemoteGfManagerAgent)x$0), x$0 -> new DSConnectionDaemon((RemoteGfManagerAgent)x$0), x$0 -> new MyMembershipListener((RemoteGfManagerAgent)x$0));
    }

    @VisibleForTesting
    RemoteGfManagerAgent(GfManagerAgentConfig cfg, Function<Properties, InternalDistributedSystem> distributedSystemFactory, Function<RemoteGfManagerAgent, JoinProcessor> joinProcessorFactory, Function<RemoteGfManagerAgent, SnapshotResultDispatcher> snapshotResultDispatcherFactory, Function<RemoteGfManagerAgent, DSConnectionDaemon> dsConnectionDaemonFactory, Function<RemoteGfManagerAgent, MyMembershipListener> myMembershipListenerFactory) {
        if (!(cfg.getTransport() instanceof RemoteTransportConfig)) {
            throw new IllegalArgumentException(String.format("Expected %s to be a RemoteTransportConfig", cfg.getTransport()));
        }
        this.distributedSystemFactory = distributedSystemFactory;
        this.dsConnectionDaemonFactory = dsConnectionDaemonFactory;
        this.myMembershipListenerFactory = myMembershipListenerFactory;
        this.transport = (RemoteTransportConfig)cfg.getTransport();
        this.displayName = cfg.getDisplayName();
        this.alertListener = cfg.getAlertListener();
        if (this.alertListener != null && this.alertListener instanceof JoinLeaveListener) {
            this.addJoinLeaveListener((JoinLeaveListener)((Object)this.alertListener));
        }
        int tmp = cfg.getAlertLevel();
        if (this.alertListener == null) {
            tmp = Integer.MAX_VALUE;
        }
        this.alertLevel = tmp;
        InternalLogWriter logWriter = cfg.getLogWriter();
        if (logWriter == null) {
            throw new NullPointerException("LogWriter must not be null");
        }
        this.securityLogWriter = logWriter.isSecure() ? logWriter : LogWriterFactory.toSecurityLogWriter(logWriter);
        this.disconnectListener = cfg.getDisconnectListener();
        this.joinProcessor = joinProcessorFactory.apply(this);
        this.joinProcessor.start();
        this.join();
        this.snapshotDispatcher = snapshotResultDispatcherFactory.apply(this);
        this.snapshotDispatcher.start();
        RemoteGfManagerAgent.addAgent(this);
    }

    private void join() {
        this.daemon = this.dsConnectionDaemonFactory.apply(this);
        this.daemon.start();
        try {
            long endTime = System.currentTimeMillis() + 2000L;
            while (!this.connected && this.daemon.isAlive() && System.currentTimeMillis() < endTime) {
                this.daemon.join(200L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.system.getCancelCriterion().checkCancelInProgress(e);
        }
    }

    private static void handle(ExecutionException ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof OperationCancelledException) {
            return;
        }
        if (cause instanceof DistributedSystemDisconnectedException) {
            throw new DistributedSystemDisconnectedException("While waiting for Future", ex);
        }
        throw new RuntimeAdminException("An ExecutionException was thrown while waiting for Future.", ex);
    }

    public String toString() {
        return "Distributed System " + this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disconnect() {
        boolean disconnectedTrue;
        RemoteGfManagerAgent remoteGfManagerAgent = this;
        synchronized (remoteGfManagerAgent) {
            if (this.disconnected) {
                return false;
            }
            this.disconnected = true;
            disconnectedTrue = true;
        }
        try {
            boolean removeListener;
            this.listening = false;
            this.joinProcessor.shutDown();
            boolean bl = removeListener = this.alertLevel != Integer.MAX_VALUE;
            if (this.isConnected() || !this.membersMap.isEmpty()) {
                RemoteApplicationVM[] apps;
                for (RemoteApplicationVM app : apps = (RemoteApplicationVM[])this.listApplications(disconnectedTrue)) {
                    try {
                        app.disconnect(removeListener);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                try {
                    DistributionManager illegalArgumentException = this.system.getDistributionManager();
                    Object object = this.myMembershipListenerLock;
                    synchronized (object) {
                        if (this.myMembershipListener != null) {
                            illegalArgumentException.removeMembershipListener(this.myMembershipListener);
                        }
                    }
                    if (illegalArgumentException instanceof ClusterDistributionManager) {
                        ((ClusterDistributionManager)illegalArgumentException).setAgent(null);
                    }
                }
                catch (IllegalArgumentException distributedSystemDisconnectedException) {
                }
                catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                    // empty catch block
                }
                Object object = this.systemLock;
                synchronized (object) {
                    if (this.system != null && ClusterDistributionManager.isDedicatedAdminVM() && this.system.isConnected()) {
                        this.system.disconnect();
                    }
                    this.system = null;
                }
                this.connected = false;
            }
            this.daemon.shutDown();
            if (this.snapshotDispatcher != null) {
                this.snapshotDispatcher.shutDown();
            }
        }
        finally {
            RemoteGfManagerAgent.removeAgent(this);
        }
        return true;
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isConnected() {
        return this.connected && this.system != null && this.system.isConnected();
    }

    @Override
    public ApplicationVM[] listApplications() {
        return this.listApplications(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ApplicationVM[] listApplications(boolean disconnected) {
        if (this.isConnected() || !this.membersMap.isEmpty() && disconnected) {
            ArrayList<RemoteApplicationVM> remoteApplicationVMs = new ArrayList<RemoteApplicationVM>(this.membersMap.size());
            Iterator<Future<RemoteApplicationVM>> iterator = this.membersMap.values().iterator();
            block11: while (true) {
                if (!iterator.hasNext()) {
                    ApplicationVM[] array = new RemoteApplicationVM[remoteApplicationVMs.size()];
                    remoteApplicationVMs.toArray(array);
                    return array;
                }
                Future<RemoteApplicationVM> future = iterator.next();
                while (true) {
                    try {
                        this.system.getCancelCriterion().checkCancelInProgress(null);
                    }
                    catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                        // empty catch block
                    }
                    boolean interrupted = Thread.interrupted();
                    try {
                        RemoteApplicationVM app = future.get();
                        if (app == null) continue block11;
                        remoteApplicationVMs.add(app);
                        continue block11;
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    catch (CancellationException ex) {
                        continue block11;
                    }
                    catch (ExecutionException ex) {
                        RemoteGfManagerAgent.handle(ex);
                        continue block11;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                break;
            }
        }
        return new RemoteApplicationVM[0];
    }

    @Override
    public GfManagerAgent[] listPeers() {
        return new GfManagerAgent[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJoinLeaveListener(JoinLeaveListener observer) {
        Object object = this.listenersLock;
        synchronized (object) {
            Set<JoinLeaveListener> oldListeners = this.listeners;
            if (!oldListeners.contains(observer)) {
                HashSet<JoinLeaveListener> newListeners = new HashSet<JoinLeaveListener>(oldListeners);
                newListeners.add(observer);
                this.listeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJoinLeaveListener(JoinLeaveListener observer) {
        Object object = this.listenersLock;
        synchronized (object) {
            HashSet<JoinLeaveListener> newListeners;
            Set<JoinLeaveListener> oldListeners = this.listeners;
            if (oldListeners.contains(observer) && (newListeners = new HashSet<JoinLeaveListener>(oldListeners)).remove(observer)) {
                this.listeners = newListeners;
            }
        }
    }

    @Override
    public synchronized void setCacheCollector(CacheCollector collector) {
        this.collector = collector;
    }

    public RemoteTransportConfig getTransport() {
        return this.transport;
    }

    AdminResponse sendAndWait(AdminRequest msg) {
        try {
            if (sending.get().booleanValue()) {
                throw new OperationCancelledException(String.format("Recursion detected while sending %s", msg));
            }
            sending.set(Boolean.TRUE);
            ClusterDistributionManager dm = (ClusterDistributionManager)this.system.getDistributionManager();
            if (this.isConnected()) {
                AdminResponse adminResponse = msg.sendAndWait(dm);
                return adminResponse;
            }
            dm.getCancelCriterion().checkCancelInProgress(null);
            throw new RuntimeAdminException(String.format("%s is not currently connected.", this));
        }
        finally {
            sending.set(Boolean.FALSE);
        }
    }

    void sendAsync(DistributionMessage msg) {
        if (this.system != null) {
            this.system.getDistributionManager().putOutgoing(msg);
        }
    }

    RemoteGemFireVM getMemberById(InternalDistributedMember id) {
        return this.getApplicationById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RemoteApplicationVM getApplicationById(InternalDistributedMember id) {
        if (!this.isConnected()) return null;
        Future<RemoteApplicationVM> future = this.membersMap.get(id);
        if (future == null) {
            return null;
        }
        while (true) {
            this.system.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                RemoteApplicationVM remoteApplicationVM = future.get();
                return remoteApplicationVM;
            }
            catch (InterruptedException ex) {
                interrupted = true;
                continue;
            }
            catch (CancellationException ex) {
                RemoteApplicationVM remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            catch (ExecutionException ex) {
                RemoteGfManagerAgent.handle(ex);
                RemoteApplicationVM remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteApplicationVM addMember(InternalDistributedMember id) {
        Future<RemoteApplicationVM> future;
        Object oldMembersMap;
        boolean runFuture = false;
        Object object = this.membersLock;
        synchronized (object) {
            oldMembersMap = this.membersMap;
            future = oldMembersMap.get(id);
            if (future == null) {
                runFuture = true;
                if (this.abortCurrentJoin) {
                    return null;
                }
                future = new FutureTask<RemoteApplicationVM>(() -> {
                    RemoteGfManagerAgent agent = this;
                    RemoteApplicationVM result = new RemoteApplicationVM(agent, id, this.alertLevel);
                    result.startStatDispatcher();
                    if (agent.abortCurrentJoin) {
                        result.stopStatListening();
                        return null;
                    }
                    return result;
                });
                HashMap<InternalDistributedMember, Future<RemoteApplicationVM>> newMembersMap = new HashMap<InternalDistributedMember, Future<RemoteApplicationVM>>((Map<InternalDistributedMember, Future<RemoteApplicationVM>>)oldMembersMap);
                newMembersMap.put(id, future);
                if (this.abortCurrentJoin) {
                    return null;
                }
                this.membersMap = newMembersMap;
            }
        }
        if (runFuture) {
            ((Runnable)((Object)future)).run();
        }
        while (true) {
            RemoteApplicationVM remoteApplicationVM;
            this.system.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                oldMembersMap = future.get();
                return oldMembersMap;
            }
            catch (InterruptedException ex) {
                interrupted = true;
                continue;
            }
            catch (CancellationException ex) {
                remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            catch (ExecutionException ex) {
                RemoteGfManagerAgent.handle(ex);
                remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    RemoteApplicationVM removeMember(InternalDistributedMember id) {
        Object oldMembersMap;
        Future future = null;
        Object object = this.membersLock;
        synchronized (object) {
            HashMap<InternalDistributedMember, Future<RemoteApplicationVM>> newMembersMap;
            oldMembersMap = this.membersMap;
            if (oldMembersMap.containsKey(id) && (future = (Future)(newMembersMap = new HashMap<InternalDistributedMember, Future<RemoteApplicationVM>>((Map<InternalDistributedMember, Future<RemoteApplicationVM>>)oldMembersMap)).remove(id)) != null) {
                this.membersMap = newMembersMap;
            }
        }
        if (future == null) return null;
        future.cancel(true);
        while (true) {
            RemoteApplicationVM remoteApplicationVM;
            Object object2 = this.systemLock;
            synchronized (object2) {
                if (this.system == null) {
                    return null;
                }
                this.system.getCancelCriterion().checkCancelInProgress(null);
            }
            boolean interrupted = Thread.interrupted();
            try {
                oldMembersMap = (RemoteApplicationVM)future.get();
                return oldMembersMap;
            }
            catch (InterruptedException ex) {
                interrupted = true;
                continue;
            }
            catch (CancellationException ex) {
                remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            catch (ExecutionException ex) {
                RemoteGfManagerAgent.handle(ex);
                remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueSnapshotResults(SnapshotResultMessage msg) {
        if (!this.isListening()) {
            return;
        }
        while (true) {
            this.system.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                this.snapshotResults.put(msg);
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    void callAlertListener(Alert alert) {
        if (!this.isListening()) {
            return;
        }
        if (this.alertListener != null && alert.getLevel() >= this.alertLevel) {
            this.alertListener.alert(alert);
        }
    }

    private void callCacheCollector(CacheSnapshot results, InternalDistributedMember sender, int snapshotId) {
        RemoteGemFireVM vm;
        if (!this.isListening()) {
            return;
        }
        if (this.collector != null && (vm = this.getMemberById(sender)) != null) {
            this.collector.resultsReturned(results, vm, snapshotId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalDistributedSystem.DisconnectListener getDisconnectListener() {
        RemoteGfManagerAgent remoteGfManagerAgent = this;
        synchronized (remoteGfManagerAgent) {
            return this.disconnectListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToDS() {
        if (!this.isListening()) {
            return;
        }
        Properties props = this.transport.toDSProperties();
        if (this.displayName != null && !this.displayName.isEmpty()) {
            props.setProperty("name", this.displayName);
        }
        Object object = this.systemLock;
        synchronized (object) {
            if (this.system != null) {
                this.system.disconnect();
                this.system = null;
            }
            this.system = this.distributedSystemFactory.apply(props);
        }
        DistributionManager dm = this.system.getDistributionManager();
        if (dm instanceof ClusterDistributionManager) {
            ((ClusterDistributionManager)dm).setAgent(this);
        }
        Object object2 = this;
        synchronized (object2) {
            this.disconnected = false;
        }
        this.system.addDisconnectListener(new InternalDistributedSystem.DisconnectListener(){

            public String toString() {
                return String.format("Disconnect listener for %s", RemoteGfManagerAgent.this);
            }

            @Override
            public void onDisconnect(InternalDistributedSystem sys) {
                boolean reconnect = sys.isReconnecting();
                if (!reconnect) {
                    InternalDistributedSystem.DisconnectListener listener = RemoteGfManagerAgent.this.getDisconnectListener();
                    if (RemoteGfManagerAgent.this.disconnect() && listener != null) {
                        listener.onDisconnect(sys);
                    }
                }
            }
        });
        InternalDistributedSystem.addReconnectListener(new InternalDistributedSystem.ReconnectListener(){

            @Override
            public void reconnecting(InternalDistributedSystem oldsys) {
            }

            @Override
            public void onReconnect(InternalDistributedSystem oldsys, InternalDistributedSystem newsys) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RemoteGfManagerAgent.onReconnect attempting to join new distributed system");
                }
                RemoteGfManagerAgent.this.join();
            }
        });
        object2 = this.myMembershipListenerLock;
        synchronized (object2) {
            this.myMembershipListener = this.myMembershipListenerFactory.apply(this);
            dm.addMembershipListener(this.myMembershipListener);
            Set<InternalDistributedMember> initialMembers = dm.getDistributionManagerIds();
            this.myMembershipListener.addMembers(new HashSet<InternalDistributedMember>(initialMembers));
            if (logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("[RemoteGfManagerAgent] ");
                sb.append("Connected to DS with ");
                sb.append(initialMembers.size());
                sb.append(" members: ");
                for (InternalDistributedMember member : initialMembers) {
                    sb.append(member);
                    sb.append(" ");
                }
                logger.debug(sb.toString());
            }
            this.connected = true;
            for (InternalDistributedMember member : initialMembers) {
                try {
                    this.handleJoined(member);
                }
                catch (OperationCancelledException ex) {
                    if (!logger.isTraceEnabled(LogMarker.DM_VERBOSE)) continue;
                    logger.trace(LogMarker.DM_VERBOSE, "join cancelled by departure");
                }
            }
            this.initialized = true;
        }
    }

    @Override
    public DistributionManager getDM() {
        InternalDistributedSystem sys = this.system;
        if (sys == null) {
            return null;
        }
        return sys.getDistributionManager();
    }

    @Override
    public void setAlertLevel(int level) {
        this.alertLevel = level;
        AlertLevelChangeMessage m = AlertLevelChangeMessage.create(level);
        this.sendAsync(m);
    }

    @Override
    public InternalDistributedSystem getDSConnection() {
        return this.system;
    }

    @VisibleForTesting
    void setDSConnection(InternalDistributedSystem system) {
        this.system = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJoined(InternalDistributedMember id) {
        if (!this.isListening()) {
            return;
        }
        this.currentJoin = id;
        try {
            RemoteApplicationVM member = null;
            switch (id.getVmKind()) {
                case 10: {
                    member = this.addMember(id);
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown VM Kind: %s", id.getVmKind()));
                }
            }
            if (this.abortCurrentJoin) {
                return;
            }
            if (member != null) {
                if (this.abortCurrentJoin) {
                    return;
                }
                for (JoinLeaveListener listener : this.listeners) {
                    if (this.abortCurrentJoin) {
                        return;
                    }
                    try {
                        listener.nodeJoined(this, member);
                    }
                    catch (VirtualMachineError e) {
                        SystemFailure.initiateFailure(e);
                        throw e;
                    }
                    catch (Throwable e) {
                        SystemFailure.checkFailure();
                        logger.warn("Listener threw an exception.", e);
                    }
                }
            }
        }
        finally {
            this.removePendingJoins(id);
            if (this.abortCurrentJoin) {
                logger.info("aborted  {}", (Object)id);
            }
            this.currentJoin = null;
            this.abortCurrentJoin = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingJoin(InternalDistributedMember id) {
        Object object = this.pendingJoinsLock;
        synchronized (object) {
            List<InternalDistributedMember> oldPendingJoins = this.pendingJoins;
            if (!oldPendingJoins.contains(id)) {
                ArrayList<InternalDistributedMember> newPendingJoins = new ArrayList<InternalDistributedMember>(oldPendingJoins);
                newPendingJoins.add(id);
                this.pendingJoins = newPendingJoins;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingJoins(InternalDistributedMember id) {
        Object object = this.pendingJoinsLock;
        synchronized (object) {
            List<InternalDistributedMember> oldPendingJoins = this.pendingJoins;
            if (oldPendingJoins.contains(id)) {
                ArrayList<InternalDistributedMember> newPendingJoins = new ArrayList<InternalDistributedMember>(oldPendingJoins);
                newPendingJoins.remove(id);
                this.pendingJoins = newPendingJoins;
            }
        }
    }

    private void cancelPendingJoins(InternalDistributedMember id) {
        try {
            this.joinProcessor.pauseHandling();
            this.removePendingJoins(id);
            this.joinProcessor.abort(id);
        }
        finally {
            AdminWaiters.cancelWaiters(id);
            this.joinProcessor.resumeHandling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setMembersMap(Map<InternalDistributedMember, Future<RemoteApplicationVM>> membersMap) {
        Object object = this.membersLock;
        synchronized (object) {
            this.membersMap = membersMap;
        }
    }

    @VisibleForTesting
    static class MyMembershipListener
    implements MembershipListener {
        private final Set<InternalDistributedMember> distributedMembers = new HashSet<InternalDistributedMember>();
        private final RemoteGfManagerAgent agent;

        private MyMembershipListener(RemoteGfManagerAgent agent) {
            this.agent = agent;
        }

        private void addMembers(Set initMembers) {
            this.distributedMembers.addAll(initMembers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
            if (!this.agent.isListening()) {
                return;
            }
            MyMembershipListener myMembershipListener = this;
            synchronized (myMembershipListener) {
                if (!this.distributedMembers.contains(id)) {
                    this.distributedMembers.add(id);
                    this.agent.addPendingJoin(id);
                    this.agent.joinProcessor.resumeHandling();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
            MyMembershipListener myMembershipListener = this;
            synchronized (myMembershipListener) {
                if (!this.distributedMembers.remove(id)) {
                    return;
                }
                this.agent.cancelPendingJoins(id);
                if (!this.agent.isListening()) {
                    return;
                }
            }
            RemoteApplicationVM member = null;
            switch (id.getVmKind()) {
                case 10: {
                    member = this.agent.removeMember(id);
                    break;
                }
                case 12: {
                    break;
                }
                case 11: {
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown VM Kind");
                }
            }
            if (member != null) {
                for (JoinLeaveListener listener : this.agent.listeners) {
                    if (crashed) {
                        listener.nodeCrashed(this.agent, member);
                        continue;
                    }
                    listener.nodeLeft(this.agent, member);
                }
                member.stopStatListening();
            }
        }
    }

    @VisibleForTesting
    static class JoinProcessor
    extends LoggingThread {
        private final RemoteGfManagerAgent agent;
        private final Object lock = new Object();
        private volatile boolean paused;
        private volatile boolean shutDown;
        private volatile InternalDistributedMember id;

        private JoinProcessor(RemoteGfManagerAgent agent) {
            super("JoinProcessor");
            this.agent = agent;
        }

        public void shutDown() {
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "JoinProcessor: shutting down");
            }
            this.shutDown = true;
            this.interrupt();
        }

        private void pauseHandling() {
            this.paused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resumeHandling() {
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "JoinProcessor: resuming.  Is alive? {}", (Object)this.isAlive());
            }
            this.paused = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        public void abort(InternalDistributedMember memberId) {
            if (memberId.equals(this.agent.currentJoin)) {
                this.agent.abortCurrentJoin = true;
                this.interrupt();
            }
            if (memberId.equals(this.id)) {
                this.id = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean noPendingJoins = false;
            block12: while (!this.shutDown) {
                SystemFailure.checkFailure();
                try {
                    if (!this.agent.isListening()) {
                        this.shutDown();
                    }
                    if ((noPendingJoins = this.agent.pendingJoins.isEmpty()) && logger.isDebugEnabled()) {
                        logger.debug("Pausing as there are no pending joins ... ");
                    }
                    if (this.paused || noPendingJoins) {
                        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                            logger.trace(LogMarker.DM_VERBOSE, "JoinProcessor is about to wait...");
                        }
                        Object object = this.lock;
                        synchronized (object) {
                            this.lock.wait();
                        }
                    }
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "JoinProcessor has woken up...");
                    }
                    if (this.paused) continue;
                    if (this.id == null) {
                        List pendingJoinsRef = this.agent.pendingJoins;
                        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                            logger.trace(LogMarker.DM_VERBOSE, "JoinProcessor pendingJoins: {}", (Object)pendingJoinsRef.size());
                        }
                        if (!pendingJoinsRef.isEmpty()) {
                            this.id = (InternalDistributedMember)pendingJoinsRef.get(0);
                            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                                logger.trace(LogMarker.DM_VERBOSE, "JoinProcessor got a membership event for {}", (Object)this.id);
                            }
                        }
                    }
                    if (this.paused || this.id == null) continue;
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "JoinProcessor handling join for {}", (Object)this.id);
                    }
                    try {
                        this.agent.handleJoined(this.id);
                    }
                    finally {
                        this.id = null;
                    }
                }
                catch (CancelException e) {
                    this.shutDown = true;
                    break;
                }
                catch (InterruptedException e) {
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "JoinProcessor has been interrupted...");
                    }
                    if (this.shutDown || !this.paused && !noPendingJoins) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug("JoinProcessor was interrupted when it was paused, now resuming ...", (Throwable)e);
                    }
                    noPendingJoins = false;
                }
                catch (OperationCancelledException ex) {
                    if (!logger.isTraceEnabled(LogMarker.DM_VERBOSE)) continue;
                    logger.trace(LogMarker.DM_VERBOSE, "join cancelled by departure");
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable e) {
                    SystemFailure.checkFailure();
                    for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof InterruptedException)) continue;
                        if (!logger.isTraceEnabled(LogMarker.DM_VERBOSE)) continue block12;
                        logger.trace(LogMarker.DM_VERBOSE, "JoinProcessor has been interrupted...");
                        continue block12;
                    }
                    logger.error("JoinProcessor caught exception...", e);
                }
            }
        }
    }

    @VisibleForTesting
    static class SnapshotResultDispatcher
    extends LoggingThread {
        private final RemoteGfManagerAgent agent;
        private volatile boolean shutDown;

        private SnapshotResultDispatcher(RemoteGfManagerAgent agent) {
            super("SnapshotResultDispatcher");
            this.agent = agent;
        }

        public void shutDown() {
            this.shutDown = true;
            this.interrupt();
        }

        public void run() {
            while (!this.shutDown) {
                SystemFailure.checkFailure();
                try {
                    SnapshotResultMessage msg = (SnapshotResultMessage)this.agent.snapshotResults.take();
                    this.agent.callCacheCollector(msg.getSnapshot(), msg.getSender(), msg.getSnapshotId());
                    SnapshotResultDispatcher.yield();
                }
                catch (InterruptedException ignore) {
                    if (this.shutDown) break;
                    logger.warn("Ignoring strange interrupt", (Throwable)ignore);
                }
                catch (Exception ex) {
                    logger.fatal(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    @VisibleForTesting
    static class DSConnectionDaemon
    extends LoggingThread {
        private final RemoteGfManagerAgent agent;
        private volatile boolean shutDown;

        private DSConnectionDaemon(RemoteGfManagerAgent agent) {
            super("DSConnectionDaemon");
            this.agent = agent;
        }

        public void shutDown() {
            this.shutDown = true;
            this.interrupt();
        }

        public void run() {
            block5: while (!this.shutDown) {
                SystemFailure.checkFailure();
                try {
                    this.agent.connected = false;
                    this.agent.initialized = false;
                    if (!this.shutDown) {
                        this.agent.connectToDS();
                        if (this.agent.isListening()) {
                            Assert.assertTrue(this.agent.system != null);
                        }
                        return;
                    }
                }
                catch (IncompatibleSystemException ise) {
                    logger.fatal(ise.getMessage(), (Throwable)ise);
                    this.agent.callAlertListener(new VersionMismatchAlert(this.agent, ise.getMessage()));
                }
                catch (Exception e) {
                    for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                        if (cause instanceof InterruptedException && this.shutDown) break block5;
                        if (!(cause instanceof AuthenticationFailedException)) continue;
                        this.shutDown = true;
                        this.agent.securityLogWriter.warning("[RemoteGfManagerAgent]: An AuthenticationFailedException was caught while connecting to DS", (Throwable)e);
                        break block5;
                    }
                    logger.debug("[RemoteGfManagerAgent] While connecting to DS", (Throwable)e);
                }
                try {
                    DSConnectionDaemon.sleep((long)1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.agent.connected = false;
            this.agent.initialized = false;
        }
    }
}

