/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.Serializable;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.SystemMemberBridgeServer;
import org.apache.geode.admin.SystemMemberCacheServer;
import org.apache.geode.admin.internal.SystemMemberCacheImpl;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.geode.internal.admin.AdminBridgeServer;
import org.apache.geode.internal.admin.CacheInfo;
import org.apache.geode.internal.admin.GemFireVM;

public class SystemMemberBridgeServerImpl
implements SystemMemberCacheServer,
SystemMemberBridgeServer {
    private final GemFireVM vm;
    private CacheInfo cache;
    private AdminBridgeServer bridgeInfo;

    protected SystemMemberBridgeServerImpl(SystemMemberCacheImpl cache, AdminBridgeServer bridgeInfo) throws AdminException {
        this.vm = cache.getVM();
        this.cache = cache.getCacheInfo();
        this.bridgeInfo = bridgeInfo;
    }

    private void checkRunning() throws AdminException {
        if (this.isRunning()) {
            throw new AdminException("Cannot change the configuration of a running cache server.");
        }
    }

    @Override
    public int getPort() {
        return this.bridgeInfo.getPort();
    }

    @Override
    public void setPort(int port) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setPort(port);
    }

    @Override
    public void start() throws AdminException {
        this.vm.startBridgeServer(this.cache, this.bridgeInfo);
    }

    @Override
    public boolean isRunning() {
        return this.bridgeInfo.isRunning();
    }

    @Override
    public void stop() throws AdminException {
        this.vm.stopBridgeServer(this.cache, this.bridgeInfo);
    }

    protected int getBridgeId() {
        return this.bridgeInfo.getId();
    }

    @Override
    public void refresh() {
        try {
            this.bridgeInfo = this.vm.getBridgeInfo(this.cache, this.bridgeInfo.getId());
        }
        catch (AdminException ex) {
            throw new InternalGemFireException("Unexpected exception while refreshing", ex);
        }
    }

    @Override
    public String getBindAddress() {
        return this.bridgeInfo.getBindAddress();
    }

    @Override
    public void setBindAddress(String address) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setBindAddress(address);
    }

    @Override
    public String getHostnameForClients() {
        return this.bridgeInfo.getHostnameForClients();
    }

    @Override
    public void setHostnameForClients(String name) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setHostnameForClients(name);
    }

    @Override
    public void setNotifyBySubscription(boolean b) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setNotifyBySubscription(b);
    }

    @Override
    public boolean getNotifyBySubscription() {
        return this.bridgeInfo.getNotifyBySubscription();
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setSocketBufferSize(socketBufferSize);
    }

    @Override
    public int getSocketBufferSize() {
        return this.bridgeInfo.getSocketBufferSize();
    }

    public void setTcpDelay(boolean setting) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setTcpNoDelay(setting);
    }

    public boolean getTcpDelay() {
        return this.bridgeInfo.getTcpNoDelay();
    }

    @Override
    public void setMaximumTimeBetweenPings(int maximumTimeBetweenPings) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setMaximumTimeBetweenPings(maximumTimeBetweenPings);
    }

    @Override
    public int getMaximumTimeBetweenPings() {
        return this.bridgeInfo.getMaximumTimeBetweenPings();
    }

    @Override
    public int getMaxConnections() {
        return this.bridgeInfo.getMaxConnections();
    }

    @Override
    public void setMaxConnections(int maxCons) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setMaxConnections(maxCons);
    }

    @Override
    public int getMaxThreads() {
        return this.bridgeInfo.getMaxThreads();
    }

    @Override
    public void setMaxThreads(int maxThreads) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setMaxThreads(maxThreads);
    }

    @Override
    public int getMaximumMessageCount() {
        return this.bridgeInfo.getMaximumMessageCount();
    }

    @Override
    public void setMaximumMessageCount(int maxMessageCount) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setMaximumMessageCount(maxMessageCount);
    }

    @Override
    public int getMessageTimeToLive() {
        return this.bridgeInfo.getMessageTimeToLive();
    }

    @Override
    public void setMessageTimeToLive(int messageTimeToLive) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setMessageTimeToLive(messageTimeToLive);
    }

    @Override
    public void setGroups(String[] groups) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setGroups(groups);
    }

    @Override
    public String[] getGroups() {
        return this.bridgeInfo.getGroups();
    }

    @Override
    public String getLoadProbe() {
        return this.bridgeInfo.getLoadProbe().toString();
    }

    @Override
    public void setLoadProbe(ServerLoadProbe loadProbe) throws AdminException {
        this.checkRunning();
        if (!(loadProbe instanceof Serializable)) {
            throw new IllegalArgumentException("Load probe must be Serializable to be used with admin API");
        }
        this.bridgeInfo.setLoadProbe(loadProbe);
    }

    @Override
    public long getLoadPollInterval() {
        return this.bridgeInfo.getLoadPollInterval();
    }

    @Override
    public void setLoadPollInterval(long loadPollInterval) throws AdminException {
        this.checkRunning();
        this.bridgeInfo.setLoadPollInterval(loadPollInterval);
    }
}

