/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;

public class RMIJRMPServerImpl
extends RMIServerImpl {
    private final int port;
    private final RMIClientSocketFactory clientFactory;
    private final RMIServerSocketFactory serverFactory;

    public RMIJRMPServerImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Map env) throws IOException {
        super(env);
        this.port = port;
        this.clientFactory = csf;
        this.serverFactory = ssf;
    }

    protected void export() throws IOException {
        UnicastRemoteObject.exportObject(this, this.port, this.clientFactory, this.serverFactory);
    }

    protected String getProtocol() {
        return "rmi";
    }

    public Remote toStub() throws IOException {
        return RemoteObject.toStub(this);
    }

    protected RMIConnection makeClient(String connectionId, Subject subject) throws IOException {
        RMIConnectionImpl client = new RMIConnectionImpl(this, connectionId, this.getDefaultClassLoader(), subject, this.getEnvironment());
        client.setContext(this.getContext());
        UnicastRemoteObject.exportObject(client, this.port, this.clientFactory, this.serverFactory);
        return client;
    }

    protected void closeClient(RMIConnection client) throws IOException {
        UnicastRemoteObject.unexportObject(client, true);
    }

    protected void closeServer() throws IOException {
        UnicastRemoteObject.unexportObject(this, true);
    }
}

