/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.internal.CqQueryVsdStats;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;

public class GetSubscriptionQueueSizeFunction
implements InternalFunction<String[]> {
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext<String[]> context) {
        Cache cache = context.getCache();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        String[] args = (String[])context.getArguments();
        String durableClientId = args[0];
        String cqName = args[1];
        context.getResultSender().lastResult((Object)this.createFunctionResult(memberNameOrId, durableClientId, cqName));
    }

    private CliFunctionResult createFunctionResult(String memberNameOrId, String durableClientId, String cqName) {
        try {
            CacheClientNotifier cacheClientNotifier = CacheClientNotifier.getInstance();
            if (cacheClientNotifier == null) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, "No client found on this server");
            }
            CacheClientProxy cacheClientProxy = cacheClientNotifier.getClientProxy(durableClientId);
            if (cacheClientProxy == null) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"No client found with client-id : {0}", (Object)durableClientId));
            }
            if (cqName == null || cqName.isEmpty()) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, Integer.toString(cacheClientNotifier.getDurableClientHAQueueSize(durableClientId)));
            }
            CqService cqService = cacheClientProxy.getCache().getCqService();
            if (cqService == null) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, "No cq's registered on this member");
            }
            CqQuery cqQuery = cqService.getClientCqFromServer(cacheClientProxy.getProxyID(), cqName);
            if (cqQuery == null) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"No cq found on server for client with durable-client-id : {0} with cq-name : {1}.", (Object[])new Object[]{durableClientId, cqName}));
            }
            CqQueryVsdStats cqVsdStats = ((InternalCqQuery)cqQuery).getVsdStats();
            if (cqVsdStats == null) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"No cq stats found on server for durable client id {0} with cq name {1}.", (Object[])new Object[]{durableClientId, cqName}));
            }
            long queueSize = cqVsdStats.getNumHAQueuedEvents();
            return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, Long.toString(queueSize));
        }
        catch (Exception e) {
            return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, e.getMessage());
        }
    }
}

